/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.aidl;

import android.annotation.NonNull;
import android.app.appsearch.ParcelableUtil;
import android.app.appsearch.aidl.DocumentsParcelCreator;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.GenericDocumentParcel;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.List;
import java.util.Objects;

@SafeParcelable.Class(creator="DocumentsParcelCreator", creatorIsFinal=false)
public class DocumentsParcel
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<DocumentsParcel> CREATOR = new DocumentsParcelCreator(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DocumentsParcel createFromParcel(Parcel in) {
            byte[] dataBlob = Objects.requireNonNull(ParcelableUtil.readBlob(in));
            Parcel unmarshallParcel = Parcel.obtain();
            try {
                unmarshallParcel.unmarshall(dataBlob, 0, dataBlob.length);
                unmarshallParcel.setDataPosition(0);
                DocumentsParcel documentsParcel = super.createFromParcel(unmarshallParcel);
                return documentsParcel;
            }
            finally {
                unmarshallParcel.recycle();
            }
        }
    };
    @SafeParcelable.Field(id=1, getter="getDocumentParcels")
    final List<GenericDocumentParcel> mDocumentParcels;
    @SafeParcelable.Field(id=2, getter="getTakenActionGenericDocumentParcels")
    final List<GenericDocumentParcel> mTakenActionGenericDocumentParcels;

    @SafeParcelable.Constructor
    public DocumentsParcel(@SafeParcelable.Param(id=1) List<GenericDocumentParcel> documentParcels, @SafeParcelable.Param(id=2) List<GenericDocumentParcel> takenActionGenericDocumentParcels) {
        this.mDocumentParcels = documentParcels;
        this.mTakenActionGenericDocumentParcels = takenActionGenericDocumentParcels;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        ParcelableUtil.writeBlob(dest, this.serializeToByteArray(flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private byte[] serializeToByteArray(int flags) {
        byte[] bytes;
        Parcel data = Parcel.obtain();
        try {
            DocumentsParcelCreator.writeToParcel(this, data, flags);
            bytes = data.marshall();
        }
        finally {
            data.recycle();
        }
        return bytes;
    }

    @NonNull
    public List<GenericDocumentParcel> getDocumentParcels() {
        return this.mDocumentParcels;
    }

    @NonNull
    public List<GenericDocumentParcel> getTakenActionGenericDocumentParcels() {
        return this.mTakenActionGenericDocumentParcels;
    }

    public int getTotalDocumentCount() {
        return this.mDocumentParcels.size() + this.mTakenActionGenericDocumentParcels.size();
    }
}

