/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.BatchResultCallback;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.GetByDocumentIdRequest;
import android.app.appsearch.GetSchemaResponse;
import android.app.appsearch.OpenBlobForReadResponse;
import android.app.appsearch.SearchResults;
import android.app.appsearch.SearchSessionUtil;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.aidl.AppSearchAttributionSource;
import android.app.appsearch.aidl.AppSearchResultCallback;
import android.app.appsearch.aidl.GetDocumentsAidlRequest;
import android.app.appsearch.aidl.GetSchemaAidlRequest;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.InitializeAidlRequest;
import android.app.appsearch.aidl.OpenBlobForReadAidlRequest;
import android.app.appsearch.util.ExceptionUtil;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public abstract class ReadOnlyGlobalSearchSession {
    protected final IAppSearchManager mService;
    protected final UserHandle mUserHandle;
    protected final AppSearchAttributionSource mCallerAttributionSource;
    private final boolean mIsForEnterprise;

    ReadOnlyGlobalSearchSession(@NonNull IAppSearchManager service, @NonNull UserHandle userHandle, @NonNull AppSearchAttributionSource callerAttributionSource, boolean isForEnterprise) {
        this.mService = service;
        this.mUserHandle = userHandle;
        this.mCallerAttributionSource = callerAttributionSource;
        this.mIsForEnterprise = isForEnterprise;
    }

    protected void initialize(final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<Void>> callback) {
        try {
            this.mService.initialize(new InitializeAidlRequest(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<Void>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<Void> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        if (result.isSuccess()) {
                            callback.accept(AppSearchResult.newSuccessfulResult(null));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    public void getByDocumentId(@NonNull String packageName, @NonNull String databaseName, @NonNull GetByDocumentIdRequest request, @NonNull Executor executor, @NonNull BatchResultCallback<String, GenericDocument> callback) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(databaseName);
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getDocuments(new GetDocumentsAidlRequest(this.mCallerAttributionSource, packageName, databaseName, request, this.mUserHandle, SystemClock.elapsedRealtime(), this.mIsForEnterprise), SearchSessionUtil.createGetDocumentCallback(executor, callback));
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public void openBlobForRead(@NonNull Set<AppSearchBlobHandle> handles, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<OpenBlobForReadResponse>> callback) {
        try {
            this.mService.openBlobForRead(new OpenBlobForReadAidlRequest(this.mCallerAttributionSource, null, new ArrayList<AppSearchBlobHandle>(handles), this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<OpenBlobForReadResponse>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<OpenBlobForReadResponse> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @NonNull
    public SearchResults search(@NonNull String queryExpression, @NonNull SearchSpec searchSpec) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        return new SearchResults(this.mService, this.mCallerAttributionSource, null, queryExpression, searchSpec, this.mUserHandle, this.mIsForEnterprise);
    }

    public void getSchema(@NonNull String packageName, @NonNull String databaseName, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<GetSchemaResponse>> callback) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(databaseName);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getSchema(new GetSchemaAidlRequest(this.mCallerAttributionSource, packageName, databaseName, this.mUserHandle, SystemClock.elapsedRealtime(), this.mIsForEnterprise), new AppSearchResultCallback<GetSchemaResponse>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<GetSchemaResponse> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @VisibleForTesting
    public IAppSearchManager getService() {
        return this.mService;
    }

    @VisibleForTesting
    public boolean isForEnterprise() {
        return this.mIsForEnterprise;
    }
}

