/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appsearch.JoinSpecCreator;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SafeParcelable.Class(creator="JoinSpecCreator")
public class JoinSpec
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<JoinSpec> CREATOR = new JoinSpecCreator();
    @SafeParcelable.Field(id=1, getter="getNestedQuery")
    private final String mNestedQuery;
    @SafeParcelable.Field(id=2, getter="getNestedSearchSpec")
    private final SearchSpec mNestedSearchSpec;
    @SafeParcelable.Field(id=3, getter="getChildPropertyExpression")
    private final String mChildPropertyExpression;
    @SafeParcelable.Field(id=4, getter="getMaxJoinedResultCount")
    private final int mMaxJoinedResultCount;
    @SafeParcelable.Field(id=5, getter="getAggregationScoringStrategy")
    private final int mAggregationScoringStrategy;
    private static final int DEFAULT_MAX_JOINED_RESULT_COUNT = 10;
    public static final String QUALIFIED_ID = "this.qualifiedId()";
    public static final int AGGREGATION_SCORING_OUTER_RESULT_RANKING_SIGNAL = 0;
    public static final int AGGREGATION_SCORING_RESULT_COUNT = 1;
    public static final int AGGREGATION_SCORING_MIN_RANKING_SIGNAL = 2;
    public static final int AGGREGATION_SCORING_AVG_RANKING_SIGNAL = 3;
    public static final int AGGREGATION_SCORING_MAX_RANKING_SIGNAL = 4;
    public static final int AGGREGATION_SCORING_SUM_RANKING_SIGNAL = 5;

    @SafeParcelable.Constructor
    JoinSpec(@SafeParcelable.Param(id=1) @NonNull String nestedQuery, @SafeParcelable.Param(id=2) @NonNull SearchSpec nestedSearchSpec, @SafeParcelable.Param(id=3) @NonNull String childPropertyExpression, @SafeParcelable.Param(id=4) int maxJoinedResultCount, @SafeParcelable.Param(id=5) int aggregationScoringStrategy) {
        this.mNestedQuery = Objects.requireNonNull(nestedQuery);
        this.mNestedSearchSpec = Objects.requireNonNull(nestedSearchSpec);
        this.mChildPropertyExpression = Objects.requireNonNull(childPropertyExpression);
        this.mMaxJoinedResultCount = maxJoinedResultCount;
        this.mAggregationScoringStrategy = aggregationScoringStrategy;
    }

    @NonNull
    public String getNestedQuery() {
        return this.mNestedQuery;
    }

    @NonNull
    public String getChildPropertyExpression() {
        return this.mChildPropertyExpression;
    }

    public int getMaxJoinedResultCount() {
        return this.mMaxJoinedResultCount;
    }

    @NonNull
    public SearchSpec getNestedSearchSpec() {
        return this.mNestedSearchSpec;
    }

    public int getAggregationScoringStrategy() {
        return this.mAggregationScoringStrategy;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JoinSpecCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private static final SearchSpec EMPTY_SEARCH_SPEC = new SearchSpec.Builder().build();
        private String mNestedQuery = "";
        private SearchSpec mNestedSearchSpec = EMPTY_SEARCH_SPEC;
        private String mChildPropertyExpression;
        private int mMaxJoinedResultCount = 10;
        private int mAggregationScoringStrategy = 0;

        public Builder(@NonNull String childPropertyExpression) {
            Objects.requireNonNull(childPropertyExpression);
            this.mChildPropertyExpression = childPropertyExpression;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        public Builder(@NonNull JoinSpec joinSpec) {
            Objects.requireNonNull(joinSpec);
            this.mNestedQuery = joinSpec.getNestedQuery();
            this.mNestedSearchSpec = joinSpec.getNestedSearchSpec();
            this.mChildPropertyExpression = joinSpec.getChildPropertyExpression();
            this.mMaxJoinedResultCount = joinSpec.getMaxJoinedResultCount();
            this.mAggregationScoringStrategy = joinSpec.getAggregationScoringStrategy();
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder setChildPropertyExpression(@NonNull String childPropertyExpression) {
            Objects.requireNonNull(childPropertyExpression);
            this.mChildPropertyExpression = childPropertyExpression;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setNestedSearch(@NonNull String nestedQuery, @NonNull SearchSpec nestedSearchSpec) {
            Objects.requireNonNull(nestedQuery);
            Objects.requireNonNull(nestedSearchSpec);
            this.mNestedQuery = nestedQuery;
            this.mNestedSearchSpec = nestedSearchSpec;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setMaxJoinedResultCount(int maxJoinedResultCount) {
            this.mMaxJoinedResultCount = maxJoinedResultCount;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setAggregationScoringStrategy(int aggregationScoringStrategy) {
            Preconditions.checkArgumentInRange(aggregationScoringStrategy, 0, 5, "aggregationScoringStrategy");
            this.mAggregationScoringStrategy = aggregationScoringStrategy;
            return this;
        }

        @NonNull
        public JoinSpec build() {
            return new JoinSpec(this.mNestedQuery, this.mNestedSearchSpec, this.mChildPropertyExpression, this.mMaxJoinedResultCount, this.mAggregationScoringStrategy);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AggregationScoringStrategy {
    }
}

