/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.InternalVisibilityConfigCreator;
import android.app.appsearch.PackageIdentifier;
import android.app.appsearch.SchemaVisibilityConfig;
import android.app.appsearch.SetBlobVisibilityRequest;
import android.app.appsearch.SetSchemaRequest;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@SafeParcelable.Class(creator="InternalVisibilityConfigCreator")
public class InternalVisibilityConfig
extends AbstractSafeParcelable {
    public static final  @NonNull Parcelable.Creator<InternalVisibilityConfig> CREATOR = new InternalVisibilityConfigCreator();
    @SafeParcelable.Field(id=1, getter="getSchemaType")
    private final @NonNull String mSchemaType;
    @SafeParcelable.Field(id=2, getter="isNotDisplayedBySystem")
    private final boolean mIsNotDisplayedBySystem;
    @SafeParcelable.Field(id=3, getter="getVisibilityConfig")
    private final @NonNull SchemaVisibilityConfig mVisibilityConfig;
    @SafeParcelable.Field(id=4)
    final @NonNull List<SchemaVisibilityConfig> mVisibleToConfigs;

    public static @NonNull List<InternalVisibilityConfig> toInternalVisibilityConfigs(@NonNull SetSchemaRequest setSchemaRequest) {
        Set<AppSearchSchema> searchSchemas = setSchemaRequest.getSchemas();
        Set<String> schemasNotDisplayedBySystem = setSchemaRequest.getSchemasNotDisplayedBySystem();
        Map<String, Set<PackageIdentifier>> schemasVisibleToPackages = setSchemaRequest.getSchemasVisibleToPackages();
        Map<String, Set<Set<Integer>>> schemasVisibleToPermissions = setSchemaRequest.getRequiredPermissionsForSchemaTypeVisibility();
        Map<String, PackageIdentifier> publiclyVisibleSchemas = setSchemaRequest.getPubliclyVisibleSchemas();
        Map<String, Set<SchemaVisibilityConfig>> schemasVisibleToConfigs = setSchemaRequest.getSchemasVisibleToConfigs();
        ArrayList<InternalVisibilityConfig> result = new ArrayList<InternalVisibilityConfig>(searchSchemas.size());
        for (AppSearchSchema searchSchema : searchSchemas) {
            Set<SchemaVisibilityConfig> visibleToConfigs;
            PackageIdentifier packageIdentifier;
            Set<Set<Integer>> visibleToPermissionSets;
            String schemaType = searchSchema.getSchemaType();
            Builder builder = new Builder(schemaType).setNotDisplayedBySystem(schemasNotDisplayedBySystem.contains(schemaType));
            Set<PackageIdentifier> visibleToPackages = schemasVisibleToPackages.get(schemaType);
            if (visibleToPackages != null) {
                for (PackageIdentifier packageIdentifier2 : visibleToPackages) {
                    builder.addVisibleToPackage(packageIdentifier2);
                }
            }
            if ((visibleToPermissionSets = schemasVisibleToPermissions.get(schemaType)) != null) {
                for (Set<Integer> visibleToPermissions : visibleToPermissionSets) {
                    builder.addVisibleToPermissions(visibleToPermissions);
                }
            }
            if ((packageIdentifier = publiclyVisibleSchemas.get(schemaType)) != null) {
                builder.setPubliclyVisibleTargetPackage(packageIdentifier);
            }
            if ((visibleToConfigs = schemasVisibleToConfigs.get(schemaType)) != null) {
                for (SchemaVisibilityConfig schemaVisibilityConfig : visibleToConfigs) {
                    builder.addVisibleToConfig(schemaVisibilityConfig);
                }
            }
            result.add(builder.build());
        }
        return result;
    }

    public static @NonNull List<InternalVisibilityConfig> toInternalVisibilityConfigs(@NonNull SetBlobVisibilityRequest setBlobVisibilityRequest) {
        Set<String> blobNamespacesNotDisplayedBySystem = setBlobVisibilityRequest.getNamespacesNotDisplayedBySystem();
        Map<String, Set<SchemaVisibilityConfig>> blobNamespacesVisibleToConfigs = setBlobVisibilityRequest.getNamespacesVisibleToConfigs();
        ArraySet<String> allBlobNamespaces = new ArraySet<String>(blobNamespacesNotDisplayedBySystem);
        allBlobNamespaces.addAll(blobNamespacesVisibleToConfigs.keySet());
        ArrayList<InternalVisibilityConfig> result = new ArrayList<InternalVisibilityConfig>();
        for (String namespace : allBlobNamespaces) {
            Builder builder = new Builder(namespace).setNotDisplayedBySystem(blobNamespacesNotDisplayedBySystem.contains(namespace));
            Set<SchemaVisibilityConfig> visibleToConfigs = blobNamespacesVisibleToConfigs.get(namespace);
            if (visibleToConfigs != null) {
                for (SchemaVisibilityConfig schemaVisibilityConfig : visibleToConfigs) {
                    builder.addVisibleToConfig(schemaVisibilityConfig);
                }
            }
            result.add(builder.build());
        }
        return result;
    }

    @SafeParcelable.Constructor
    InternalVisibilityConfig(@SafeParcelable.Param(id=1) @NonNull String schemaType, @SafeParcelable.Param(id=2) boolean isNotDisplayedBySystem, @SafeParcelable.Param(id=3) @NonNull SchemaVisibilityConfig schemaVisibilityConfig, @SafeParcelable.Param(id=4) @NonNull List<SchemaVisibilityConfig> visibleToConfigs) {
        this.mIsNotDisplayedBySystem = isNotDisplayedBySystem;
        this.mSchemaType = Objects.requireNonNull(schemaType);
        this.mVisibilityConfig = Objects.requireNonNull(schemaVisibilityConfig);
        this.mVisibleToConfigs = Objects.requireNonNull(visibleToConfigs);
    }

    public @NonNull String getSchemaType() {
        return this.mSchemaType;
    }

    public boolean isNotDisplayedBySystem() {
        return this.mIsNotDisplayedBySystem;
    }

    public @NonNull SchemaVisibilityConfig getVisibilityConfig() {
        return this.mVisibilityConfig;
    }

    public @NonNull Set<SchemaVisibilityConfig> getVisibleToConfigs() {
        return new ArraySet<SchemaVisibilityConfig>(this.mVisibleToConfigs);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        InternalVisibilityConfigCreator.writeToParcel(this, dest, flags);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof InternalVisibilityConfig)) {
            return false;
        }
        InternalVisibilityConfig that = (InternalVisibilityConfig)o;
        return this.mIsNotDisplayedBySystem == that.mIsNotDisplayedBySystem && Objects.equals(this.mSchemaType, that.mSchemaType) && Objects.equals(this.mVisibilityConfig, that.mVisibilityConfig) && Objects.equals(this.mVisibleToConfigs, that.mVisibleToConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.mIsNotDisplayedBySystem, this.mSchemaType, this.mVisibilityConfig, this.mVisibleToConfigs);
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_set_schema_visible_to_configs")
    public static class Builder {
        private String mSchemaType;
        private boolean mIsNotDisplayedBySystem;
        private SchemaVisibilityConfig.Builder mVisibilityConfigBuilder;
        private List<SchemaVisibilityConfig> mVisibleToConfigs = new ArrayList<SchemaVisibilityConfig>();
        private boolean mBuilt;

        public Builder(@NonNull String schemaType) {
            this.mSchemaType = Objects.requireNonNull(schemaType);
            this.mVisibilityConfigBuilder = new SchemaVisibilityConfig.Builder();
        }

        public Builder(@NonNull InternalVisibilityConfig internalVisibilityConfig) {
            Objects.requireNonNull(internalVisibilityConfig);
            this.mSchemaType = internalVisibilityConfig.mSchemaType;
            this.mIsNotDisplayedBySystem = internalVisibilityConfig.mIsNotDisplayedBySystem;
            this.mVisibilityConfigBuilder = new SchemaVisibilityConfig.Builder(internalVisibilityConfig.getVisibilityConfig());
            this.mVisibleToConfigs = internalVisibilityConfig.mVisibleToConfigs;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setSchemaType(@NonNull String schemaType) {
            this.resetIfBuilt();
            this.mSchemaType = Objects.requireNonNull(schemaType);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setVisibilityConfig(@NonNull SchemaVisibilityConfig schemaVisibilityConfig) {
            this.resetIfBuilt();
            this.mVisibilityConfigBuilder = new SchemaVisibilityConfig.Builder(schemaVisibilityConfig);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setNotDisplayedBySystem(boolean notDisplayedBySystem) {
            this.resetIfBuilt();
            this.mIsNotDisplayedBySystem = notDisplayedBySystem;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder addVisibleToPackage(@NonNull PackageIdentifier packageIdentifier) {
            this.resetIfBuilt();
            this.mVisibilityConfigBuilder.addAllowedPackage(packageIdentifier);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder clearVisibleToPackages() {
            this.resetIfBuilt();
            this.mVisibilityConfigBuilder.clearAllowedPackages();
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder addVisibleToPermissions(@NonNull Set<Integer> visibleToPermissions) {
            this.resetIfBuilt();
            this.mVisibilityConfigBuilder.addRequiredPermissions(visibleToPermissions);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder clearVisibleToPermissions() {
            this.resetIfBuilt();
            this.mVisibilityConfigBuilder.clearRequiredPermissions();
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setPubliclyVisibleTargetPackage(@Nullable PackageIdentifier packageIdentifier) {
            this.resetIfBuilt();
            this.mVisibilityConfigBuilder.setPubliclyVisibleTargetPackage(packageIdentifier);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder addVisibleToConfig(@NonNull SchemaVisibilityConfig schemaVisibilityConfig) {
            Objects.requireNonNull(schemaVisibilityConfig);
            this.resetIfBuilt();
            this.mVisibleToConfigs.add(schemaVisibilityConfig);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder clearVisibleToConfig() {
            this.resetIfBuilt();
            this.mVisibleToConfigs.clear();
            return this;
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mVisibleToConfigs = new ArrayList<SchemaVisibilityConfig>(this.mVisibleToConfigs);
                this.mBuilt = false;
            }
        }

        public @NonNull InternalVisibilityConfig build() {
            this.mBuilt = true;
            return new InternalVisibilityConfig(this.mSchemaType, this.mIsNotDisplayedBySystem, this.mVisibilityConfigBuilder.build(), this.mVisibleToConfigs);
        }
    }
}

