/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchEnvironment;
import android.content.Context;
import android.os.Environment;
import android.os.UserHandle;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FrameworkAppSearchEnvironment
implements AppSearchEnvironment {
    @Override
    public File getAppSearchDir(@NonNull Context unused, @NonNull UserHandle userHandle) {
        Objects.requireNonNull(userHandle);
        File systemCeDir = new File(Environment.getDataDirectory(), "system_ce");
        File systemCeUserDir = new File(systemCeDir, String.valueOf(userHandle.getIdentifier()));
        return new File(systemCeUserDir, "appsearch");
    }

    @Override
    public Context createContextAsUser(@NonNull Context context, @NonNull UserHandle userHandle) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(userHandle);
        return context.createContextAsUser(userHandle, 0);
    }

    @Override
    public ExecutorService createExecutorService(int corePoolSize, int maxConcurrency, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, int priority) {
        return new ThreadPoolExecutor(corePoolSize, maxConcurrency, keepAliveTime, unit, workQueue);
    }

    @Override
    public ExecutorService createSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    @Override
    @NonNull
    public ExecutorService createCachedThreadPoolExecutor() {
        return Executors.newCachedThreadPool();
    }

    @Override
    @Nullable
    public File getCacheDir(@NonNull Context context) {
        return null;
    }

    @Override
    public boolean isInfoLoggingEnabled() {
        return true;
    }

    @Override
    public int getEnvironment() {
        return 2;
    }
}

