/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.AppSearchManager;
import android.app.appsearch.AppSearchMigrationHelper;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.BatchResultCallback;
import android.app.appsearch.CommitBlobResponse;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.GetByDocumentIdRequest;
import android.app.appsearch.GetSchemaResponse;
import android.app.appsearch.InternalSetSchemaResponse;
import android.app.appsearch.InternalVisibilityConfig;
import android.app.appsearch.Migrator;
import android.app.appsearch.OpenBlobForReadResponse;
import android.app.appsearch.OpenBlobForWriteResponse;
import android.app.appsearch.PutDocumentsRequest;
import android.app.appsearch.RemoveBlobResponse;
import android.app.appsearch.RemoveByDocumentIdRequest;
import android.app.appsearch.ReportUsageRequest;
import android.app.appsearch.SearchResults;
import android.app.appsearch.SearchSessionUtil;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.SearchSuggestionResult;
import android.app.appsearch.SearchSuggestionSpec;
import android.app.appsearch.SetBlobVisibilityRequest;
import android.app.appsearch.SetSchemaRequest;
import android.app.appsearch.SetSchemaResponse;
import android.app.appsearch.StorageInfo;
import android.app.appsearch.aidl.AppSearchAttributionSource;
import android.app.appsearch.aidl.AppSearchBatchResultParcel;
import android.app.appsearch.aidl.AppSearchResultCallback;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.CommitBlobAidlRequest;
import android.app.appsearch.aidl.DocumentsParcel;
import android.app.appsearch.aidl.GetDocumentsAidlRequest;
import android.app.appsearch.aidl.GetNamespacesAidlRequest;
import android.app.appsearch.aidl.GetSchemaAidlRequest;
import android.app.appsearch.aidl.GetStorageInfoAidlRequest;
import android.app.appsearch.aidl.IAppSearchBatchResultCallback;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.InitializeAidlRequest;
import android.app.appsearch.aidl.OpenBlobForReadAidlRequest;
import android.app.appsearch.aidl.OpenBlobForWriteAidlRequest;
import android.app.appsearch.aidl.PersistToDiskAidlRequest;
import android.app.appsearch.aidl.PutDocumentsAidlRequest;
import android.app.appsearch.aidl.RemoveBlobAidlRequest;
import android.app.appsearch.aidl.RemoveByDocumentIdAidlRequest;
import android.app.appsearch.aidl.RemoveByQueryAidlRequest;
import android.app.appsearch.aidl.ReportUsageAidlRequest;
import android.app.appsearch.aidl.SearchSuggestionAidlRequest;
import android.app.appsearch.aidl.SetBlobVisibilityAidlRequest;
import android.app.appsearch.aidl.SetSchemaAidlRequest;
import android.app.appsearch.exceptions.AppSearchException;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.GenericDocumentParcel;
import android.app.appsearch.stats.SchemaMigrationStats;
import android.app.appsearch.util.ExceptionUtil;
import android.app.appsearch.util.SchemaMigrationUtil;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os._Original_Build;
import android.util.ArraySet;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class AppSearchSession
implements Closeable {
    private static final String TAG = "AppSearchSession";
    private final AppSearchAttributionSource mCallerAttributionSource;
    private final String mDatabaseName;
    private final UserHandle mUserHandle;
    private final IAppSearchManager mService;
    @Nullable
    private final File mCacheDirectory;
    private boolean mIsMutated = false;
    private boolean mIsClosed = false;

    static void createSearchSession(@NonNull AppSearchManager.SearchContext searchContext, @NonNull IAppSearchManager service, @NonNull UserHandle userHandle, @NonNull AppSearchAttributionSource callerAttributionSource, @Nullable File cacheDirectory, @NonNull Executor executor, @NonNull Consumer<AppSearchResult<AppSearchSession>> callback) {
        AppSearchSession searchSession = new AppSearchSession(service, userHandle, callerAttributionSource, searchContext.mDatabaseName, cacheDirectory);
        searchSession.initialize(executor, callback);
    }

    private void initialize(final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<AppSearchSession>> callback) {
        try {
            this.mService.initialize(new InitializeAidlRequest(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<AppSearchSession>(){

                @Override
                public void onResult(@NonNull AppSearchResult<AppSearchSession> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        if (result.isSuccess()) {
                            callback.accept(AppSearchResult.newSuccessfulResult(AppSearchSession.this));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    private AppSearchSession(@NonNull IAppSearchManager service, @NonNull UserHandle userHandle, @NonNull AppSearchAttributionSource callerAttributionSource, @NonNull String databaseName, @Nullable File cacheDirectory) {
        this.mService = service;
        this.mUserHandle = userHandle;
        this.mCallerAttributionSource = callerAttributionSource;
        this.mDatabaseName = databaseName;
        this.mCacheDirectory = cacheDirectory;
    }

    public void setSchema(@NonNull SetSchemaRequest request, @NonNull Executor workExecutor, @NonNull Executor callbackExecutor, @NonNull Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(workExecutor);
        Objects.requireNonNull(callbackExecutor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        ArrayList<AppSearchSchema> schemaList = new ArrayList<AppSearchSchema>(request.getSchemas());
        for (int i = 0; i < schemaList.size(); ++i) {
            if (((AppSearchSchema)schemaList.get(i)).getParentTypes().isEmpty() || _Original_Build.VERSION.SDK_INT >= 34) continue;
            throw new UnsupportedOperationException("SCHEMA_ADD_PARENT_TYPE is not available on this AppSearch implementation.");
        }
        List<InternalVisibilityConfig> visibilityConfigs = InternalVisibilityConfig.toInternalVisibilityConfigs(request);
        if (request.getMigrators().isEmpty()) {
            this.setSchemaNoMigrations(request, schemaList, visibilityConfigs, callbackExecutor, callback);
        } else {
            this.setSchemaWithMigrations(request, schemaList, visibilityConfigs, workExecutor, callbackExecutor, callback);
        }
        this.mIsMutated = true;
    }

    public void getSchema(final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<GetSchemaResponse>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        String targetPackageName = this.mCallerAttributionSource.getPackageName();
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getSchema(new GetSchemaAidlRequest(this.mCallerAttributionSource, targetPackageName, this.mDatabaseName, this.mUserHandle, SystemClock.elapsedRealtime(), false), new AppSearchResultCallback<GetSchemaResponse>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<GetSchemaResponse> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        if (result.isSuccess()) {
                            GetSchemaResponse response = Objects.requireNonNull((GetSchemaResponse)result.getResultValue());
                            callback.accept(AppSearchResult.newSuccessfulResult(response));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    public void getNamespaces(final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<Set<String>>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getNamespaces(new GetNamespacesAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<List<String>>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<List<String>> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        if (result.isSuccess()) {
                            List namespaces = Objects.requireNonNull((List)result.getResultValue());
                            callback.accept(AppSearchResult.newSuccessfulResult(new ArraySet(namespaces)));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    public void put(@NonNull PutDocumentsRequest request, final @NonNull Executor executor, final @NonNull BatchResultCallback<String, Void> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        DocumentsParcel documentsParcel = new DocumentsParcel(AppSearchSession.toGenericDocumentParcels(request.getGenericDocuments()), AppSearchSession.toGenericDocumentParcels(request.getTakenActionGenericDocuments()));
        try {
            this.mService.putDocuments(new PutDocumentsAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, documentsParcel, this.mUserHandle, SystemClock.elapsedRealtime()), new IAppSearchBatchResultCallback.Stub(this){

                @Override
                public void onResult(AppSearchBatchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.onResult(resultParcel.getResult()));
                }

                @Override
                public void onSystemError(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> SearchSessionUtil.sendSystemErrorToCallback(resultParcel.getResult(), callback));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    public void getByDocumentId(@NonNull GetByDocumentIdRequest request, @NonNull Executor executor, @NonNull BatchResultCallback<String, GenericDocument> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        String targetPackageName = this.mCallerAttributionSource.getPackageName();
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getDocuments(new GetDocumentsAidlRequest(this.mCallerAttributionSource, targetPackageName, this.mDatabaseName, request, this.mUserHandle, SystemClock.elapsedRealtime(), false), SearchSessionUtil.createGetDocumentCallback(executor, callback));
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public void openBlobForWrite(@NonNull Set<AppSearchBlobHandle> handles, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<OpenBlobForWriteResponse>> callback) {
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.openBlobForWrite(new OpenBlobForWriteAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, new ArrayList<AppSearchBlobHandle>(handles), this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<OpenBlobForWriteResponse>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<OpenBlobForWriteResponse> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public void removeBlob(@NonNull Set<AppSearchBlobHandle> handles, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<RemoveBlobResponse>> callback) {
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.removeBlob(new RemoveBlobAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, new ArrayList<AppSearchBlobHandle>(handles), this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<RemoveBlobResponse>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<RemoveBlobResponse> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public void commitBlob(@NonNull Set<AppSearchBlobHandle> handles, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<CommitBlobResponse>> callback) {
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.commitBlob(new CommitBlobAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, new ArrayList<AppSearchBlobHandle>(handles), this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<CommitBlobResponse>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<CommitBlobResponse> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public void openBlobForRead(@NonNull Set<AppSearchBlobHandle> handles, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<OpenBlobForReadResponse>> callback) {
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.openBlobForRead(new OpenBlobForReadAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, new ArrayList<AppSearchBlobHandle>(handles), this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<OpenBlobForReadResponse>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<OpenBlobForReadResponse> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public void setBlobVisibility(@NonNull SetBlobVisibilityRequest request, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<Void>> callback) {
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            List<InternalVisibilityConfig> visibilityConfigs = InternalVisibilityConfig.toInternalVisibilityConfigs(request);
            this.mService.setBlobVisibility(new SetBlobVisibilityAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, new ArrayList<InternalVisibilityConfig>(visibilityConfigs), this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<Void>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<Void> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @NonNull
    public SearchResults search(@NonNull String queryExpression, @NonNull SearchSpec searchSpec) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        return new SearchResults(this.mService, this.mCallerAttributionSource, this.mDatabaseName, queryExpression, searchSpec, this.mUserHandle, false);
    }

    public void searchSuggestion(@NonNull String suggestionQueryExpression, @NonNull SearchSuggestionSpec searchSuggestionSpec, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<List<SearchSuggestionResult>>> callback) {
        Objects.requireNonNull(suggestionQueryExpression);
        Objects.requireNonNull(searchSuggestionSpec);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.searchSuggestion(new SearchSuggestionAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, suggestionQueryExpression, searchSuggestionSpec, this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<List<SearchSuggestionResult>>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<List<SearchSuggestionResult>> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        if (result.isSuccess()) {
                            List suggestions = Objects.requireNonNull((List)result.getResultValue());
                            callback.accept(AppSearchResult.newSuccessfulResult(suggestions));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    public void reportUsage(@NonNull ReportUsageRequest request, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        String targetPackageName = this.mCallerAttributionSource.getPackageName();
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.reportUsage(new ReportUsageAidlRequest(this.mCallerAttributionSource, targetPackageName, this.mDatabaseName, request, false, this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<Void>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<Void> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    public void remove(@NonNull RemoveByDocumentIdRequest request, final @NonNull Executor executor, final @NonNull BatchResultCallback<String, Void> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.removeByDocumentId(new RemoveByDocumentIdAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, request, this.mUserHandle, SystemClock.elapsedRealtime()), new IAppSearchBatchResultCallback.Stub(this){

                @Override
                public void onResult(AppSearchBatchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.onResult(resultParcel.getResult()));
                }

                @Override
                public void onSystemError(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> SearchSessionUtil.sendSystemErrorToCallback(resultParcel.getResult(), callback));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    public void remove(@NonNull String queryExpression, @NonNull SearchSpec searchSpec, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        if (searchSpec.getJoinSpec() != null) {
            throw new IllegalArgumentException("JoinSpec not allowed in removeByQuery, but JoinSpec was provided.");
        }
        try {
            this.mService.removeByQuery(new RemoveByQueryAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, queryExpression, searchSpec, this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<Void>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<Void> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    public void getStorageInfo(final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<StorageInfo>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getStorageInfo(new GetStorageInfoAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<StorageInfo>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<StorageInfo> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        StorageInfo storageInfo = Objects.requireNonNull((StorageInfo)result.getResultValue());
                        if (result.isSuccess()) {
                            callback.accept(AppSearchResult.newSuccessfulResult(storageInfo));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @Override
    public void close() {
        if (this.mIsMutated && !this.mIsClosed) {
            try {
                this.mService.persistToDisk(new PersistToDiskAidlRequest(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime()));
                this.mIsClosed = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to close the AppSearchSession", e);
            }
        }
    }

    private void setSchemaNoMigrations(@NonNull SetSchemaRequest request, @NonNull List<AppSearchSchema> schemas, @NonNull List<InternalVisibilityConfig> visibilityConfigs, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        try {
            SetSchemaAidlRequest setSchemaAidlRequest = new SetSchemaAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, schemas, visibilityConfigs, request.isForceOverride(), request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), 0);
            AppSearchResultCallback<InternalSetSchemaResponse> callbackBase = new AppSearchResultCallback<InternalSetSchemaResponse>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<InternalSetSchemaResponse> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        if (result.isSuccess()) {
                            try {
                                InternalSetSchemaResponse internalSetSchemaResponse = (InternalSetSchemaResponse)result.getResultValue();
                                if (internalSetSchemaResponse == null) {
                                    callback.accept(AppSearchResult.newFailedResult(2, "Received null InternalSetSchemaResponse during setSchema call"));
                                    return;
                                }
                                if (!internalSetSchemaResponse.isSuccess()) {
                                    callback.accept(AppSearchResult.newFailedResult(7, internalSetSchemaResponse.getErrorMessage()));
                                    return;
                                }
                                callback.accept(AppSearchResult.newSuccessfulResult(internalSetSchemaResponse.getSetSchemaResponse()));
                            }
                            catch (RuntimeException e) {
                                callback.accept(AppSearchResult.throwableToFailedResult(e));
                            }
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            };
            this.mService.setSchema(setSchemaAidlRequest, callbackBase);
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    private void setSchemaWithMigrations(@NonNull SetSchemaRequest request, @NonNull List<AppSearchSchema> schemas, @NonNull List<InternalVisibilityConfig> visibilityConfigs, @NonNull Executor workExecutor, @NonNull Executor callbackExecutor, @NonNull Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        long totalLatencyStartTimeMillis = SystemClock.elapsedRealtime();
        long waitExecutorStartLatencyMillis = SystemClock.elapsedRealtime();
        SearchSessionUtil.safeExecute(workExecutor, callback, () -> {
            try {
                long waitExecutorEndLatencyMillis = SystemClock.elapsedRealtime();
                String packageName = this.mCallerAttributionSource.getPackageName();
                SchemaMigrationStats.Builder statsBuilder = new SchemaMigrationStats.Builder(packageName, this.mDatabaseName);
                long getSchemaLatencyStartTimeMillis = SystemClock.elapsedRealtime();
                CountDownLatch getSchemaLatch = new CountDownLatch(1);
                AtomicReference getSchemaResultRef = new AtomicReference();
                this.getSchema(callbackExecutor, result -> {
                    getSchemaResultRef.set(result);
                    getSchemaLatch.countDown();
                });
                getSchemaLatch.await();
                AppSearchResult getSchemaResult = (AppSearchResult)getSchemaResultRef.get();
                if (!getSchemaResult.isSuccess()) {
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(getSchemaResult)));
                    return;
                }
                GetSchemaResponse getSchemaResponse = Objects.requireNonNull((GetSchemaResponse)getSchemaResult.getResultValue());
                int currentVersion = getSchemaResponse.getVersion();
                int finalVersion = request.getVersion();
                Map<String, Migrator> activeMigrators = SchemaMigrationUtil.getActiveMigrators(getSchemaResponse.getSchemas(), request.getMigrators(), currentVersion, finalVersion);
                long getSchemaLatencyEndTimeMillis = SystemClock.elapsedRealtime();
                if (activeMigrators.isEmpty()) {
                    this.setSchemaNoMigrations(request, schemas, visibilityConfigs, callbackExecutor, callback);
                    return;
                }
                long firstSetSchemaLatencyStartMillis = SystemClock.elapsedRealtime();
                final CountDownLatch setSchemaLatch = new CountDownLatch(1);
                final AtomicReference setSchemaResultRef = new AtomicReference();
                SetSchemaAidlRequest setSchemaAidlRequest = new SetSchemaAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, schemas, visibilityConfigs, false, request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), 1);
                this.mService.setSchema(setSchemaAidlRequest, new AppSearchResultCallback<InternalSetSchemaResponse>(this){

                    @Override
                    public void onResult(@NonNull AppSearchResult<InternalSetSchemaResponse> result) {
                        setSchemaResultRef.set(result);
                        setSchemaLatch.countDown();
                    }
                });
                setSchemaLatch.await();
                AppSearchResult setSchemaResult = (AppSearchResult)setSchemaResultRef.get();
                if (!setSchemaResult.isSuccess()) {
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(setSchemaResult)));
                    return;
                }
                InternalSetSchemaResponse internalSetSchemaResponse1 = (InternalSetSchemaResponse)setSchemaResult.getResultValue();
                if (internalSetSchemaResponse1 == null) {
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(2, "Received null InternalSetSchemaResponse during setSchema call")));
                    return;
                }
                long firstSetSchemaLatencyEndTimeMillis = SystemClock.elapsedRealtime();
                SchemaMigrationUtil.checkDeletedAndIncompatibleAfterMigration(internalSetSchemaResponse1, activeMigrators.keySet());
                try (AppSearchMigrationHelper migrationHelper = new AppSearchMigrationHelper(this.mService, this.mUserHandle, this.mCallerAttributionSource, this.mDatabaseName, request.getSchemas(), this.mCacheDirectory);){
                    InternalSetSchemaResponse internalSetSchemaResponse;
                    long queryAndTransformLatencyStartMillis = SystemClock.elapsedRealtime();
                    for (Map.Entry<String, Migrator> entry : activeMigrators.entrySet()) {
                        migrationHelper.queryAndTransform(entry.getKey(), entry.getValue(), currentVersion, finalVersion, statsBuilder);
                    }
                    long queryAndTransformLatencyEndTimeMillis = SystemClock.elapsedRealtime();
                    long secondSetSchemaLatencyStartMillis = SystemClock.elapsedRealtime();
                    if (internalSetSchemaResponse1.isSuccess()) {
                        internalSetSchemaResponse = internalSetSchemaResponse1;
                    } else {
                        final CountDownLatch setSchema2Latch = new CountDownLatch(1);
                        final AtomicReference setSchema2ResultRef = new AtomicReference();
                        SetSchemaAidlRequest setSchemaAidlRequest1 = new SetSchemaAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, schemas, visibilityConfigs, true, request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), 2);
                        this.mService.setSchema(setSchemaAidlRequest1, new AppSearchResultCallback<InternalSetSchemaResponse>(this){

                            @Override
                            public void onResult(@NonNull AppSearchResult<InternalSetSchemaResponse> result) {
                                setSchema2ResultRef.set(result);
                                setSchema2Latch.countDown();
                            }
                        });
                        setSchema2Latch.await();
                        AppSearchResult setSchema2Result = (AppSearchResult)setSchema2ResultRef.get();
                        if (!setSchema2Result.isSuccess()) {
                            SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(setSchema2Result)));
                            return;
                        }
                        InternalSetSchemaResponse internalSetSchemaResponse2 = (InternalSetSchemaResponse)setSchema2Result.getResultValue();
                        if (internalSetSchemaResponse2 == null) {
                            SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(2, "Received null response during setSchema call")));
                            return;
                        }
                        if (!internalSetSchemaResponse2.isSuccess()) {
                            SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(2, internalSetSchemaResponse2.getErrorMessage())));
                            return;
                        }
                        internalSetSchemaResponse = internalSetSchemaResponse2;
                    }
                    long secondSetSchemaLatencyEndTimeMillis = SystemClock.elapsedRealtime();
                    statsBuilder.setExecutorAcquisitionLatencyMillis((int)(waitExecutorEndLatencyMillis - waitExecutorStartLatencyMillis)).setGetSchemaLatencyMillis((int)(getSchemaLatencyEndTimeMillis - getSchemaLatencyStartTimeMillis)).setFirstSetSchemaLatencyMillis((int)(firstSetSchemaLatencyEndTimeMillis - firstSetSchemaLatencyStartMillis)).setIsFirstSetSchemaSuccess(internalSetSchemaResponse1.isSuccess()).setQueryAndTransformLatencyMillis((int)(queryAndTransformLatencyEndTimeMillis - queryAndTransformLatencyStartMillis)).setSecondSetSchemaLatencyMillis((int)(secondSetSchemaLatencyEndTimeMillis - secondSetSchemaLatencyStartMillis));
                    SetSchemaResponse.Builder responseBuilder = new SetSchemaResponse.Builder(internalSetSchemaResponse.getSetSchemaResponse()).addMigratedTypes(activeMigrators.keySet());
                    AppSearchResult<SetSchemaResponse> putResult = migrationHelper.putMigratedDocuments(responseBuilder, statsBuilder, totalLatencyStartTimeMillis);
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(putResult));
                }
            }
            catch (AppSearchException | RemoteException | IOException | InterruptedException | RuntimeException | ExecutionException e) {
                SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.throwableToFailedResult(e)));
            }
        });
    }

    @NonNull
    private static List<GenericDocumentParcel> toGenericDocumentParcels(List<GenericDocument> docs) {
        ArrayList<GenericDocumentParcel> docParcels = new ArrayList<GenericDocumentParcel>(docs.size());
        for (int i = 0; i < docs.size(); ++i) {
            docParcels.add(docs.get(i).getDocumentParcel());
        }
        return docParcels;
    }
}

