/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.Migrator;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.SetSchemaResponse;
import android.app.appsearch.aidl.AppSearchAttributionSource;
import android.app.appsearch.aidl.AppSearchResultCallback;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.PutDocumentsFromFileAidlRequest;
import android.app.appsearch.aidl.WriteSearchResultsToFileAidlRequest;
import android.app.appsearch.exceptions.AppSearchException;
import android.app.appsearch.safeparcel.GenericDocumentParcel;
import android.app.appsearch.stats.SchemaMigrationStats;
import android.app.appsearch.util.ExceptionUtil;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArraySet;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;

public class AppSearchMigrationHelper
implements Closeable {
    private final IAppSearchManager mService;
    private final AppSearchAttributionSource mCallerAttributionSource;
    private final String mDatabaseName;
    private final UserHandle mUserHandle;
    @Nullable
    private final File mTempDirectoryForSchemaMigration;
    private final File mMigratedFile;
    private final Set<String> mDestinationTypes;
    private int mTotalNeedMigratedDocumentCount = 0;

    AppSearchMigrationHelper(@NonNull IAppSearchManager service, @NonNull UserHandle userHandle, @NonNull AppSearchAttributionSource callerAttributionSource, @NonNull String databaseName, @NonNull Set<AppSearchSchema> newSchemas, @Nullable File tempDirectoryForSchemaMigration) throws IOException {
        this.mService = Objects.requireNonNull(service);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mCallerAttributionSource = Objects.requireNonNull(callerAttributionSource);
        this.mDatabaseName = Objects.requireNonNull(databaseName);
        this.mTempDirectoryForSchemaMigration = tempDirectoryForSchemaMigration;
        this.mMigratedFile = File.createTempFile("appsearch", null, this.mTempDirectoryForSchemaMigration);
        this.mDestinationTypes = new ArraySet<String>(newSchemas.size());
        for (AppSearchSchema newSchema : newSchemas) {
            this.mDestinationTypes.add(newSchema.getSchemaType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryAndTransform(@NonNull String schemaType, @NonNull Migrator migrator, int currentVersion, int finalVersion, @Nullable SchemaMigrationStats.Builder schemaMigrationStatsBuilder) throws IOException, AppSearchException, InterruptedException, ExecutionException {
        File queryFile = File.createTempFile("appsearch", null, this.mTempDirectoryForSchemaMigration);
        try (ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open(queryFile, 0x20000000);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference resultReference = new AtomicReference();
            this.mService.writeSearchResultsToFile(new WriteSearchResultsToFileAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, fileDescriptor, "", new SearchSpec.Builder().addFilterSchemas(schemaType).setTermMatch(1).build(), this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<Void>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<Void> result) {
                    resultReference.set(result);
                    latch.countDown();
                }
            });
            latch.await();
            AppSearchResult result = (AppSearchResult)resultReference.get();
            if (!result.isSuccess()) {
                throw new AppSearchException(result.getResultCode(), result.getErrorMessage());
            }
            this.readAndTransform(queryFile, migrator, currentVersion, finalVersion, schemaMigrationStatsBuilder);
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
        finally {
            queryFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    AppSearchResult<SetSchemaResponse> putMigratedDocuments(@NonNull SetSchemaResponse.Builder responseBuilder, @NonNull SchemaMigrationStats.Builder schemaMigrationStatsBuilder, long totalLatencyStartTimeMillis) {
        if (this.mTotalNeedMigratedDocumentCount == 0) {
            return AppSearchResult.newSuccessfulResult(responseBuilder.build());
        }
        try (ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open(this.mMigratedFile, 0x10000000);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference resultReference = new AtomicReference();
            this.mService.putDocumentsFromFile(new PutDocumentsFromFileAidlRequest(this.mCallerAttributionSource, this.mDatabaseName, fileDescriptor, this.mUserHandle, schemaMigrationStatsBuilder.build(), totalLatencyStartTimeMillis, SystemClock.elapsedRealtime()), new AppSearchResultCallback<List<SetSchemaResponse.MigrationFailure>>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<List<SetSchemaResponse.MigrationFailure>> result) {
                    resultReference.set(result);
                    latch.countDown();
                }
            });
            latch.await();
            AppSearchResult result = (AppSearchResult)resultReference.get();
            if (!result.isSuccess()) {
                AppSearchResult<SetSchemaResponse> appSearchResult = AppSearchResult.newFailedResult(result);
                return appSearchResult;
            }
            List migrationFailures = Objects.requireNonNull((List)result.getResultValue());
            responseBuilder.addMigrationFailures(migrationFailures);
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            AppSearchResult<SetSchemaResponse> appSearchResult = AppSearchResult.throwableToFailedResult(e);
            return appSearchResult;
        }
        finally {
            this.mMigratedFile.delete();
        }
        return AppSearchResult.newSuccessfulResult(responseBuilder.build());
    }

    private void readAndTransform(@NonNull File file, @NonNull Migrator migrator, int currentVersion, int finalVersion, @Nullable SchemaMigrationStats.Builder schemaMigrationStatsBuilder) throws IOException, AppSearchException {
        try (DataInputStream inputStream = new DataInputStream(new FileInputStream(file));
             DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(this.mMigratedFile, true));){
            while (true) {
                GenericDocument document;
                try {
                    document = AppSearchMigrationHelper.readDocumentFromInputStream(inputStream);
                }
                catch (EOFException e) {
                    break;
                }
                GenericDocument newDocument = currentVersion < finalVersion ? migrator.onUpgrade(currentVersion, finalVersion, document) : migrator.onDowngrade(currentVersion, finalVersion, document);
                ++this.mTotalNeedMigratedDocumentCount;
                if (!this.mDestinationTypes.contains(newDocument.getSchemaType())) {
                    throw new AppSearchException(7, "Receive a migrated document with schema type: " + newDocument.getSchemaType() + ". But the schema types doesn't exist in the request");
                }
                AppSearchMigrationHelper.writeDocumentToOutputStream(outputStream, newDocument);
            }
        }
        if (schemaMigrationStatsBuilder != null) {
            schemaMigrationStatsBuilder.setTotalNeedMigratedDocumentCount(this.mTotalNeedMigratedDocumentCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static GenericDocument readDocumentFromInputStream(@NonNull DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        if (length == 0) {
            throw new EOFException();
        }
        byte[] serializedMessage = new byte[length];
        inputStream.read(serializedMessage);
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(serializedMessage, 0, serializedMessage.length);
            parcel.setDataPosition(0);
            GenericDocumentParcel genericDocumentParcel = GenericDocumentParcel.CREATOR.createFromParcel(parcel);
            GenericDocument genericDocument = new GenericDocument(genericDocumentParcel);
            return genericDocument;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocumentToOutputStream(@NonNull DataOutputStream outputStream, @NonNull GenericDocument document) throws IOException {
        GenericDocumentParcel documentParcel = document.getDocumentParcel();
        Parcel parcel = Parcel.obtain();
        try {
            documentParcel.writeToParcel(parcel, 0);
            byte[] serializedMessage = parcel.marshall();
            outputStream.writeInt(serializedMessage.length);
            outputStream.write(serializedMessage);
        }
        finally {
            parcel.recycle();
        }
    }

    @Override
    public void close() throws IOException {
        this.mMigratedFile.delete();
    }
}

