/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appfunctions.AppFunctionAttribution;
import android.app.appfunctions.GenericDocumentWrapper;
import android.app.appsearch.GenericDocument;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags;
import java.util.Objects;

@FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
public class ExecuteAppFunctionRequest
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<ExecuteAppFunctionRequest> CREATOR = new Parcelable.Creator<ExecuteAppFunctionRequest>(){

        @Override
        public ExecuteAppFunctionRequest createFromParcel(Parcel parcel) {
            String targetPackageName = Objects.requireNonNull(parcel.readString8());
            String functionIdentifier = Objects.requireNonNull(parcel.readString8());
            GenericDocumentWrapper parameters = Objects.requireNonNull(GenericDocumentWrapper.CREATOR.createFromParcel(parcel));
            Bundle extras = Objects.requireNonNull(parcel.readBundle(Bundle.class.getClassLoader()));
            if (Flags.appFunctionAccessApiEnabled()) {
                AppFunctionAttribution attribution = parcel.readTypedObject(AppFunctionAttribution.CREATOR);
                return new ExecuteAppFunctionRequest(targetPackageName, functionIdentifier, extras, parameters, attribution);
            }
            return new ExecuteAppFunctionRequest(targetPackageName, functionIdentifier, extras, parameters, null);
        }

        public ExecuteAppFunctionRequest[] newArray(int size) {
            return new ExecuteAppFunctionRequest[size];
        }
    };
    @NonNull
    private final String mTargetPackageName;
    @NonNull
    private final String mFunctionIdentifier;
    @NonNull
    private final Bundle mExtras;
    @NonNull
    private final GenericDocumentWrapper mParameters;
    @Nullable
    private final AppFunctionAttribution mAttribution;

    private ExecuteAppFunctionRequest(@NonNull String targetPackageName, @NonNull String functionIdentifier, @NonNull Bundle extras, @NonNull GenericDocumentWrapper parameters, @Nullable AppFunctionAttribution attribution) {
        this.mTargetPackageName = Objects.requireNonNull(targetPackageName);
        this.mFunctionIdentifier = Objects.requireNonNull(functionIdentifier);
        this.mExtras = Objects.requireNonNull(extras);
        this.mParameters = Objects.requireNonNull(parameters);
        this.mAttribution = attribution;
    }

    @NonNull
    public String getTargetPackageName() {
        return this.mTargetPackageName;
    }

    @NonNull
    public String getFunctionIdentifier() {
        return this.mFunctionIdentifier;
    }

    @NonNull
    public GenericDocument getParameters() {
        return this.mParameters.getValue();
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    @FlaggedApi(value="android.permission.flags.app_function_access_api_enabled")
    @Nullable
    public AppFunctionAttribution getAttribution() {
        return this.mAttribution;
    }

    public int getRequestDataSize() {
        return this.mTargetPackageName.getBytes().length + this.mFunctionIdentifier.getBytes().length + this.mParameters.getDataSize() + this.mExtras.getSize();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mTargetPackageName);
        dest.writeString8(this.mFunctionIdentifier);
        this.mParameters.writeToParcel(dest, flags);
        dest.writeBundle(this.mExtras);
        if (Flags.appFunctionAccessApiEnabled()) {
            dest.writeTypedObject(this.mAttribution, flags);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        @NonNull
        private final String mTargetPackageName;
        @NonNull
        private final String mFunctionIdentifier;
        @NonNull
        private Bundle mExtras = Bundle.EMPTY;
        @NonNull
        private GenericDocument mParameters = new GenericDocument.Builder("", "", "").build();
        @Nullable
        private AppFunctionAttribution mAttribution = null;

        public Builder(@NonNull String targetPackageName, @NonNull String functionIdentifier) {
            this.mTargetPackageName = Objects.requireNonNull(targetPackageName);
            this.mFunctionIdentifier = Objects.requireNonNull(functionIdentifier);
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = Objects.requireNonNull(extras);
            return this;
        }

        @NonNull
        public Builder setParameters(@NonNull GenericDocument parameters) {
            Objects.requireNonNull(parameters);
            this.mParameters = parameters;
            return this;
        }

        @FlaggedApi(value="android.permission.flags.app_function_access_api_enabled")
        @NonNull
        public Builder setAttribution(@NonNull AppFunctionAttribution attribution) {
            this.mAttribution = Objects.requireNonNull(attribution);
            return this;
        }

        @NonNull
        public ExecuteAppFunctionRequest build() {
            return new ExecuteAppFunctionRequest(this.mTargetPackageName, this.mFunctionIdentifier, this.mExtras, new GenericDocumentWrapper(this.mParameters), this.mAttribution);
        }
    }
}

