/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appfunctions.AppFunctionStaticMetadataHelper;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.GenericDocument;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;

@FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
public class AppFunctionRuntimeMetadata
extends GenericDocument {
    public static final String RUNTIME_SCHEMA_TYPE = "AppFunctionRuntimeMetadata";
    public static final String APP_FUNCTION_INDEXER_PACKAGE = "android";
    public static final String APP_FUNCTION_RUNTIME_METADATA_DB = "appfunctions-db";
    public static final String APP_FUNCTION_RUNTIME_NAMESPACE = "app_functions_runtime";
    public static final String PROPERTY_FUNCTION_ID = "functionId";
    public static final String PROPERTY_PACKAGE_NAME = "packageName";
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_APP_FUNCTION_STATIC_METADATA_QUALIFIED_ID = "appFunctionStaticMetadataQualifiedId";
    private static final String TAG = "AppSearchAppFunction";
    private static final String RUNTIME_SCHEMA_TYPE_SEPARATOR = "-";

    public AppFunctionRuntimeMetadata(@NonNull GenericDocument genericDocument) {
        super(genericDocument);
    }

    public static String getRuntimeSchemaNameForPackage(@NonNull String pkg) {
        return "AppFunctionRuntimeMetadata-" + Objects.requireNonNull(pkg);
    }

    @NonNull
    public static String getPackageNameFromSchema(String metadataSchemaType) {
        String[] split = metadataSchemaType.split(RUNTIME_SCHEMA_TYPE_SEPARATOR);
        if (split.length > 2) {
            throw new IllegalArgumentException("Invalid schema type: " + metadataSchemaType + " for app function runtime");
        }
        if (split.length < 2) {
            return APP_FUNCTION_INDEXER_PACKAGE;
        }
        return split[1];
    }

    public static String getDocumentIdForAppFunction(@NonNull String pkg, @NonNull String functionId) {
        return pkg + "/" + functionId;
    }

    @NonNull
    public static AppSearchSchema createAppFunctionRuntimeSchema(@NonNull String packageName) {
        return AppFunctionRuntimeMetadata.getAppFunctionRuntimeSchemaBuilder(AppFunctionRuntimeMetadata.getRuntimeSchemaNameForPackage(packageName)).addParentType(RUNTIME_SCHEMA_TYPE).build();
    }

    public static AppSearchSchema createParentAppFunctionRuntimeSchema() {
        return AppFunctionRuntimeMetadata.getAppFunctionRuntimeSchemaBuilder(RUNTIME_SCHEMA_TYPE).build();
    }

    private static AppSearchSchema.Builder getAppFunctionRuntimeSchemaBuilder(@NonNull String schemaType) {
        return new AppSearchSchema.Builder(schemaType).addProperty(new AppSearchSchema.StringPropertyConfig.Builder(PROPERTY_FUNCTION_ID).setCardinality(2).setIndexingType(1).setTokenizerType(2).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder(PROPERTY_PACKAGE_NAME).setCardinality(2).setIndexingType(1).setTokenizerType(2).build()).addProperty(new AppSearchSchema.LongPropertyConfig.Builder(PROPERTY_ENABLED).setCardinality(2).setIndexingType(1).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder(PROPERTY_APP_FUNCTION_STATIC_METADATA_QUALIFIED_ID).setCardinality(2).setJoinableValueType(1).build());
    }

    @NonNull
    public String getFunctionId() {
        return Objects.requireNonNull(this.getPropertyString(PROPERTY_FUNCTION_ID));
    }

    @NonNull
    public String getPackageName() {
        return Objects.requireNonNull(this.getPropertyString(PROPERTY_PACKAGE_NAME));
    }

    public int getEnabled() {
        return (int)this.getPropertyLong(PROPERTY_ENABLED);
    }

    @Nullable
    @VisibleForTesting
    public String getAppFunctionStaticMetadataQualifiedId() {
        return this.getPropertyString(PROPERTY_APP_FUNCTION_STATIC_METADATA_QUALIFIED_ID);
    }

    public static class Builder
    extends GenericDocument.Builder<Builder> {
        public Builder(@NonNull String packageName, @NonNull String functionId) {
            super(AppFunctionRuntimeMetadata.APP_FUNCTION_RUNTIME_NAMESPACE, AppFunctionRuntimeMetadata.getDocumentIdForAppFunction(Objects.requireNonNull(packageName), Objects.requireNonNull(functionId)), AppFunctionRuntimeMetadata.getRuntimeSchemaNameForPackage(packageName));
            this.setPropertyString(AppFunctionRuntimeMetadata.PROPERTY_PACKAGE_NAME, packageName);
            this.setPropertyString(AppFunctionRuntimeMetadata.PROPERTY_FUNCTION_ID, functionId);
            this.setPropertyString(AppFunctionRuntimeMetadata.PROPERTY_APP_FUNCTION_STATIC_METADATA_QUALIFIED_ID, AppFunctionStaticMetadataHelper.getStaticMetadataQualifiedId(packageName, functionId));
        }

        public Builder(AppFunctionRuntimeMetadata original) {
            this(original.getPackageName(), original.getFunctionId());
            this.setEnabled(original.getEnabled());
        }

        @NonNull
        public Builder setEnabled(int enabledState) {
            if (enabledState != 0 && enabledState != 1 && enabledState != 2) {
                throw new IllegalArgumentException("Value of EnabledState is unsupported.");
            }
            this.setPropertyLong(AppFunctionRuntimeMetadata.PROPERTY_ENABLED, enabledState);
            return this;
        }

        @Override
        @NonNull
        public AppFunctionRuntimeMetadata build() {
            return new AppFunctionRuntimeMetadata(super.build());
        }
    }
}

