/*
 * Decompiled with CFR 0.152.
 */
package android.app.adservices.topics;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class TopicParcel
implements Parcelable {
    private final long mTaxonomyVersion;
    private final long mModelVersion;
    private final int mTopicId;
    @NonNull
    public static final Parcelable.Creator<TopicParcel> CREATOR = new Parcelable.Creator<TopicParcel>(){

        @Override
        public TopicParcel createFromParcel(Parcel in) {
            return new TopicParcel(in);
        }

        public TopicParcel[] newArray(int size) {
            return new TopicParcel[size];
        }
    };

    private TopicParcel(@NonNull Builder builder) {
        this.mTaxonomyVersion = builder.mTaxonomyVersion;
        this.mModelVersion = builder.mModelVersion;
        this.mTopicId = builder.mTopicId;
    }

    private TopicParcel(@NonNull Parcel in) {
        this.mTaxonomyVersion = in.readLong();
        this.mModelVersion = in.readLong();
        this.mTopicId = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeLong(this.mTaxonomyVersion);
        out.writeLong(this.mModelVersion);
        out.writeInt(this.mTopicId);
    }

    public long getTaxonomyVersion() {
        return this.mTaxonomyVersion;
    }

    public long getModelVersion() {
        return this.mModelVersion;
    }

    public int getTopicId() {
        return this.mTopicId;
    }

    public int hashCode() {
        return Objects.hash(this.getTaxonomyVersion(), this.getModelVersion(), this.getTopicId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopicParcel)) {
            return false;
        }
        TopicParcel topicParcel = (TopicParcel)obj;
        return this.getTaxonomyVersion() == topicParcel.getTaxonomyVersion() && this.getModelVersion() == topicParcel.getModelVersion() && this.getTopicId() == topicParcel.getTopicId();
    }

    public static class Builder {
        private long mTaxonomyVersion;
        private long mModelVersion;
        private int mTopicId;

        @NonNull
        public Builder setTaxonomyVersion(long taxonomyVersion) {
            this.mTaxonomyVersion = taxonomyVersion;
            return this;
        }

        @NonNull
        public Builder setModelVersion(long modelVersion) {
            this.mModelVersion = modelVersion;
            return this;
        }

        @NonNull
        public Builder setTopicId(int topicId) {
            this.mTopicId = topicId;
            return this;
        }

        @NonNull
        public TopicParcel build() {
            return new TopicParcel(this);
        }
    }
}

