/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.IOnProjectionStateChangedListener;
import android.app.IUiModeManager;
import android.app.IUiModeManagerCallback;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Binder;
import android.os.IpcDataCache;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.android.app.Flags;
import com.android.internal.util.function.pooled.PooledLambda;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.time.LocalTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Stream;

public class UiModeManager {
    private static final String TAG = "UiModeManager";
    public static String ACTION_ENTER_CAR_MODE = "android.app.action.ENTER_CAR_MODE";
    @SystemApi
    public static final String ACTION_ENTER_CAR_MODE_PRIORITIZED = "android.app.action.ENTER_CAR_MODE_PRIORITIZED";
    public static String ACTION_EXIT_CAR_MODE = "android.app.action.EXIT_CAR_MODE";
    @SystemApi
    public static final String ACTION_EXIT_CAR_MODE_PRIORITIZED = "android.app.action.EXIT_CAR_MODE_PRIORITIZED";
    public static String ACTION_ENTER_DESK_MODE = "android.app.action.ENTER_DESK_MODE";
    public static String ACTION_EXIT_DESK_MODE = "android.app.action.EXIT_DESK_MODE";
    @SystemApi
    public static final String EXTRA_CALLING_PACKAGE = "android.app.extra.CALLING_PACKAGE";
    @SystemApi
    public static final String EXTRA_PRIORITY = "android.app.extra.PRIORITY";
    public static final int MODE_NIGHT_AUTO = 0;
    public static final int MODE_NIGHT_CUSTOM = 3;
    public static final int MODE_NIGHT_NO = 1;
    public static final int MODE_NIGHT_YES = 2;
    public static final int MODE_ATTENTION_THEME_OVERLAY_OFF = 1000;
    public static final int MODE_ATTENTION_THEME_OVERLAY_NIGHT = 1001;
    public static final int MODE_ATTENTION_THEME_OVERLAY_DAY = 1002;
    public static final int MODE_ATTENTION_THEME_OVERLAY_UNKNOWN = -1;
    @SystemApi
    public static final int MODE_NIGHT_CUSTOM_TYPE_UNKNOWN = -1;
    @SystemApi
    public static final int MODE_NIGHT_CUSTOM_TYPE_SCHEDULE = 0;
    @SystemApi
    public static final int MODE_NIGHT_CUSTOM_TYPE_BEDTIME = 1;
    public static final int FORCE_INVERT_TYPE_OFF = 0;
    public static final int FORCE_INVERT_TYPE_DARK = 1;
    public static final int FORCE_INVERT_TYPE_LIGHT = 2;
    private static Globals sGlobals;
    @Nullable
    private Context mContext;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final Map<OnProjectionStateChangedListener, InnerListener> mProjectionStateListenerMap = new ArrayMap<OnProjectionStateChangedListener, InnerListener>();
    @GuardedBy(value={"mLock"})
    private final OnProjectionStateChangedListenerResourceManager mOnProjectionStateChangedListenerResourceManager = new OnProjectionStateChangedListenerResourceManager();
    public static final int ENABLE_CAR_MODE_GO_CAR_HOME = 1;
    public static final int ENABLE_CAR_MODE_ALLOW_SLEEP = 2;
    public static final int DISABLE_CAR_MODE_GO_HOME = 1;
    public static final int DISABLE_CAR_MODE_ALL_PRIORITIES = 2;
    @SystemApi
    public static final int DEFAULT_PRIORITY = 0;
    private final IpcDataCache.QueryHandler<Void, Integer> mCurrentModeTypeQuery = new IpcDataCache.QueryHandler<Void, Integer>(){

        @Override
        @NonNull
        public Integer apply(Void query) {
            return UiModeManager.this.getCurrentModeTypeFromServer();
        }
    };
    private static final String CURRENT_MODE_TYPE_API = "getCurrentModeType";
    private final IpcDataCache<Void, Integer> mCurrentModeTypeCache = new IpcDataCache<Void, Integer>(1, "system_server", "getCurrentModeType", "CurrentModeTypeCache", this.mCurrentModeTypeQuery);
    private final IpcDataCache.QueryHandler<Void, Integer> mNightModeQuery = new IpcDataCache.QueryHandler<Void, Integer>(){

        @Override
        @NonNull
        public Integer apply(Void query) {
            return UiModeManager.this.getNightModeFromServer();
        }
    };
    private static final String NIGHT_MODE_API = "getNightMode";
    private final IpcDataCache<Void, Integer> mNightModeCache = new IpcDataCache<Void, Integer>(1, "system_server", "getNightMode", "NightModeCache", this.mNightModeQuery);
    @SystemApi
    public static final int PROJECTION_TYPE_NONE = 0;
    @SystemApi
    public static final int PROJECTION_TYPE_AUTOMOTIVE = 1;
    @SystemApi
    public static final int PROJECTION_TYPE_ALL = -1;

    @UnsupportedAppUsage
    UiModeManager() throws ServiceManager.ServiceNotFoundException {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UiModeManager(Context context) throws ServiceManager.ServiceNotFoundException {
        IUiModeManager service = IUiModeManager.Stub.asInterface(ServiceManager.getServiceOrThrow("uimode"));
        this.mContext = context;
        if (service == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sGlobals == null) {
                sGlobals = new Globals(service);
            }
        }
    }

    public void enableCarMode(int flags) {
        this.enableCarMode(0, flags);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ENTER_CAR_MODE_PRIORITIZED")
    public void enableCarMode(int priority, int flags) {
        if (sGlobals != null) {
            try {
                UiModeManager.sGlobals.mService.enableCarMode(flags, priority, this.mContext == null ? null : this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void disableCarMode(int flags) {
        if (sGlobals != null) {
            try {
                UiModeManager.sGlobals.mService.disableCarModeByCallingPackage(flags, this.mContext == null ? null : this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private Integer getCurrentModeTypeFromServer() {
        try {
            if (sGlobals != null) {
                return UiModeManager.sGlobals.mService.getCurrentModeType();
            }
            return 1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.enable_current_mode_type_binder_cache")
    public static void invalidateCurrentModeTypeCache() {
        IpcDataCache.invalidateCache("system_server", CURRENT_MODE_TYPE_API);
    }

    public int getCurrentModeType() {
        if (Flags.enableCurrentModeTypeBinderCache()) {
            return this.mCurrentModeTypeCache.query(null);
        }
        return this.getCurrentModeTypeFromServer();
    }

    public void setNightMode(int mode) {
        if (sGlobals != null) {
            try {
                UiModeManager.sGlobals.mService.setNightMode(mode);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public void setNightModeCustomType(int nightModeCustomType) {
        if (sGlobals != null) {
            try {
                UiModeManager.sGlobals.mService.setNightModeCustomType(nightModeCustomType);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public int getNightModeCustomType() {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.getNightModeCustomType();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public void setAttentionModeThemeOverlay(int attentionModeThemeOverlayType) {
        if (sGlobals != null) {
            try {
                UiModeManager.sGlobals.mService.setAttentionModeThemeOverlay(attentionModeThemeOverlayType);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public int getAttentionModeThemeOverlay() {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.getAttentionModeThemeOverlay();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    public void setApplicationNightMode(int mode) {
        if (sGlobals != null) {
            try {
                UiModeManager.sGlobals.mService.setApplicationNightMode(mode);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private Integer getNightModeFromServer() {
        try {
            if (sGlobals != null) {
                return UiModeManager.sGlobals.mService.getNightMode();
            }
            return -1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.enable_night_mode_binder_cache")
    public static void invalidateNightModeCache() {
        IpcDataCache.invalidateCache("system_server", NIGHT_MODE_API);
    }

    public int getNightMode() {
        if (Flags.enableNightModeBinderCache()) {
            return this.mNightModeCache.query(null);
        }
        return this.getNightModeFromServer();
    }

    public boolean isUiModeLocked() {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.isUiModeLocked();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public boolean isNightModeLocked() {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.isNightModeLocked();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public boolean setNightModeActivatedForCustomMode(int nightModeCustomType, boolean active) {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.setNightModeActivatedForCustomMode(nightModeCustomType, active);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public boolean setNightModeActivated(boolean active) {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.setNightModeActivated(active);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @NonNull
    public LocalTime getCustomNightModeStart() {
        if (sGlobals != null) {
            try {
                return LocalTime.ofNanoOfDay(UiModeManager.sGlobals.mService.getCustomNightModeStart() * 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return LocalTime.MIDNIGHT;
    }

    public void setCustomNightModeStart(@NonNull LocalTime time) {
        if (sGlobals != null) {
            try {
                UiModeManager.sGlobals.mService.setCustomNightModeStart(time.toNanoOfDay() / 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @NonNull
    public LocalTime getCustomNightModeEnd() {
        if (sGlobals != null) {
            try {
                return LocalTime.ofNanoOfDay(UiModeManager.sGlobals.mService.getCustomNightModeEnd() * 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return LocalTime.MIDNIGHT;
    }

    public void setCustomNightModeEnd(@NonNull LocalTime time) {
        if (sGlobals != null) {
            try {
                UiModeManager.sGlobals.mService.setCustomNightModeEnd(time.toNanoOfDay() / 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TOGGLE_AUTOMOTIVE_PROJECTION", conditional=true)
    public boolean requestProjection(int projectionType) {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.requestProjection(new Binder(), projectionType, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TOGGLE_AUTOMOTIVE_PROJECTION", conditional=true)
    public boolean releaseProjection(int projectionType) {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.releaseProjection(projectionType, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PROJECTION_STATE")
    @NonNull
    public Set<String> getProjectingPackages(int projectionType) {
        if (sGlobals != null) {
            try {
                return new ArraySet<String>(UiModeManager.sGlobals.mService.getProjectingPackages(projectionType));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Set.of();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PROJECTION_STATE")
    public int getActiveProjectionTypes() {
        if (sGlobals != null) {
            try {
                return UiModeManager.sGlobals.mService.getActiveProjectionTypes();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PROJECTION_STATE")
    public void addOnProjectionStateChangedListener(int projectionType, @NonNull Executor executor, @NonNull OnProjectionStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProjectionStateListenerMap.containsKey(listener)) {
                Slog.i(TAG, "Attempted to add listener that was already added.");
                return;
            }
            if (sGlobals != null) {
                InnerListener innerListener = new InnerListener(executor, listener, this.mOnProjectionStateChangedListenerResourceManager);
                try {
                    UiModeManager.sGlobals.mService.addOnProjectionStateChangedListener(innerListener, projectionType);
                    this.mProjectionStateListenerMap.put(listener, innerListener);
                }
                catch (RemoteException e) {
                    this.mOnProjectionStateChangedListenerResourceManager.remove(innerListener);
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PROJECTION_STATE")
    public void removeOnProjectionStateChangedListener(@NonNull OnProjectionStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            InnerListener innerListener = this.mProjectionStateListenerMap.get(listener);
            if (innerListener == null) {
                Slog.i(TAG, "Attempted to remove listener that was not added.");
                return;
            }
            if (sGlobals != null) {
                try {
                    UiModeManager.sGlobals.mService.removeOnProjectionStateChangedListener(innerListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mProjectionStateListenerMap.remove(listener);
            this.mOnProjectionStateChangedListenerResourceManager.remove(innerListener);
        }
    }

    public float getContrast() {
        return sGlobals.getContrast();
    }

    public void addContrastChangeListener(@NonNull Executor executor, @NonNull ContrastChangeListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        sGlobals.addContrastChangeListener(listener, executor);
    }

    public void removeContrastChangeListener(@NonNull ContrastChangeListener listener) {
        Objects.requireNonNull(listener);
        sGlobals.removeContrastChangeListener(listener);
    }

    public int getForceInvertState() {
        return sGlobals.getForceInvertState();
    }

    public void addForceInvertStateChangeListener(@NonNull Executor executor, @NonNull ForceInvertStateChangeListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        sGlobals.addForceInvertStateChangeListener(listener, executor);
    }

    public void removeForceInvertStateChangeListener(@NonNull ForceInvertStateChangeListener listener) {
        Objects.requireNonNull(listener);
        sGlobals.removeForceInvertStateChangeListener(listener);
    }

    private static class OnProjectionStateChangedListenerResourceManager {
        private final Map<InnerListener, OnProjectionStateChangedListener> mOuterListenerMap = new ArrayMap<InnerListener, OnProjectionStateChangedListener>(1);
        private final Map<InnerListener, Executor> mExecutorMap = new ArrayMap<InnerListener, Executor>(1);

        private OnProjectionStateChangedListenerResourceManager() {
        }

        void put(@NonNull InnerListener innerListener, @NonNull Executor executor, OnProjectionStateChangedListener outerListener) {
            this.mOuterListenerMap.put(innerListener, outerListener);
            this.mExecutorMap.put(innerListener, executor);
        }

        void remove(InnerListener innerListener) {
            this.mOuterListenerMap.remove(innerListener);
            this.mExecutorMap.remove(innerListener);
        }

        OnProjectionStateChangedListener getOuterListener(@NonNull InnerListener innerListener) {
            return this.mOuterListenerMap.get(innerListener);
        }

        Executor getExecutor(@NonNull InnerListener innerListener) {
            return this.mExecutorMap.get(innerListener);
        }
    }

    private static class Globals
    extends IUiModeManagerCallback.Stub {
        private final IUiModeManager mService;
        private final Object mGlobalsLock = new Object();
        private int mForceInvertState = 0;
        private float mContrast = 0.0f;
        private final ArrayMap<ContrastChangeListener, Executor> mContrastChangeListeners = new ArrayMap();
        private final ArrayMap<ForceInvertStateChangeListener, Executor> mForceInvertStateChangeListeners = new ArrayMap();

        Globals(IUiModeManager service) {
            this.mService = service;
            try {
                this.mService.addCallback(this);
                this.mContrast = this.mService.getContrast();
                this.mForceInvertState = this.mService.getForceInvertState();
            }
            catch (RemoteException e) {
                Log.e(UiModeManager.TAG, "Setup failed: UiModeManagerService is dead", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getForceInvertState() {
            Object object = this.mGlobalsLock;
            synchronized (object) {
                return this.mForceInvertState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addForceInvertStateChangeListener(ForceInvertStateChangeListener listener, Executor executor) {
            Object object = this.mGlobalsLock;
            synchronized (object) {
                this.mForceInvertStateChangeListeners.put(listener, executor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeForceInvertStateChangeListener(ForceInvertStateChangeListener listener) {
            Object object = this.mGlobalsLock;
            synchronized (object) {
                this.mForceInvertStateChangeListeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyForceInvertStateChanged(int forceInvertState) {
            ArrayMap<ForceInvertStateChangeListener, Executor> listeners = new ArrayMap<ForceInvertStateChangeListener, Executor>();
            Object object = this.mGlobalsLock;
            synchronized (object) {
                if (this.mForceInvertState == forceInvertState) {
                    return;
                }
                this.mForceInvertState = forceInvertState;
                listeners.putAll((Map<ForceInvertStateChangeListener, Executor>)this.mForceInvertStateChangeListeners);
            }
            listeners.forEach((listener, executor) -> {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onForceInvertStateChanged(forceInvertState));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private float getContrast() {
            Object object = this.mGlobalsLock;
            synchronized (object) {
                return this.mContrast;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addContrastChangeListener(ContrastChangeListener listener, Executor executor) {
            Object object = this.mGlobalsLock;
            synchronized (object) {
                this.mContrastChangeListeners.put(listener, executor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeContrastChangeListener(ContrastChangeListener listener) {
            Object object = this.mGlobalsLock;
            synchronized (object) {
                this.mContrastChangeListeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyContrastChanged(float contrast) {
            Object object = this.mGlobalsLock;
            synchronized (object) {
                if ((double)Math.abs(this.mContrast - contrast) < 1.0E-10) {
                    return;
                }
                this.mContrast = contrast;
                this.mContrastChangeListeners.forEach((listener, executor) -> executor.execute(() -> listener.onContrastChanged(contrast)));
            }
        }
    }

    private static class InnerListener
    extends IOnProjectionStateChangedListener.Stub {
        private final WeakReference<OnProjectionStateChangedListenerResourceManager> mResourceManager;

        private InnerListener(@NonNull Executor executor, @NonNull OnProjectionStateChangedListener outerListener, @NonNull OnProjectionStateChangedListenerResourceManager resourceManager) {
            resourceManager.put(this, executor, outerListener);
            this.mResourceManager = new WeakReference<OnProjectionStateChangedListenerResourceManager>(resourceManager);
        }

        @Override
        public void onProjectionStateChanged(int activeProjectionTypes, List<String> projectingPackages) {
            OnProjectionStateChangedListenerResourceManager resourceManager = (OnProjectionStateChangedListenerResourceManager)this.mResourceManager.get();
            if (resourceManager == null) {
                Slog.w(UiModeManager.TAG, "Can't execute onProjectionStateChanged, resource manager is gone.");
                return;
            }
            OnProjectionStateChangedListener outerListener = resourceManager.getOuterListener(this);
            Executor executor = resourceManager.getExecutor(this);
            if (outerListener == null || executor == null) {
                Slog.w(UiModeManager.TAG, "Can't execute onProjectionStatechanged, references are null.");
                return;
            }
            executor.execute(PooledLambda.obtainRunnable(OnProjectionStateChangedListener::onProjectionStateChanged, outerListener, activeProjectionTypes, new ArraySet<String>(projectingPackages)).recycleOnUse());
        }
    }

    @SystemApi
    public static interface OnProjectionStateChangedListener {
        public void onProjectionStateChanged(int var1, @NonNull Set<String> var2);
    }

    public static interface ContrastChangeListener {
        public void onContrastChanged(float var1);
    }

    public static interface ForceInvertStateChangeListener {
        public void onForceInvertStateChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProjectionType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisableCarMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnableCarMode {
    }

    public static class ContrastUtils {
        private static final float CONTRAST_MIN_VALUE = -1.0f;
        private static final float CONTRAST_MAX_VALUE = 1.0f;
        public static final float CONTRAST_DEFAULT_VALUE = 0.0f;
        public static final int CONTRAST_LEVEL_STANDARD = 0;
        public static final int CONTRAST_LEVEL_MEDIUM = 1;
        public static final int CONTRAST_LEVEL_HIGH = 2;

        private static Stream<Integer> allContrastLevels() {
            return Stream.of(0, 1, 2);
        }

        public static int toContrastLevel(float contrast) {
            if (contrast < -1.0f || contrast > 1.0f) {
                throw new IllegalArgumentException("contrast values should be in [-1, 1]");
            }
            return ContrastUtils.allContrastLevels().min(Comparator.comparingDouble(contrastLevel -> Math.abs((float)contrastLevel.intValue() - 2.0f * contrast))).orElseThrow();
        }

        public static float fromContrastLevel(int contrastLevel) {
            if (ContrastUtils.allContrastLevels().noneMatch(level -> level == contrastLevel)) {
                throw new IllegalArgumentException("unrecognized contrast level: " + contrastLevel);
            }
            return (float)contrastLevel / 2.0f;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ContrastLevel {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ForceInvertType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NightModeCustomReturnType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NightModeCustomType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttentionModeThemeOverlayReturnType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttentionModeThemeOverlayType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NightMode {
    }
}

