/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accounts.AccountManager;
import android.accounts.IAccountManager;
import android.adservices.AdServicesFrameworkInitializer;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.BackgroundInstallControlManager;
import android.app.ContextImpl;
import android.app.DisabledWallpaperManager;
import android.app.DownloadManager;
import android.app.DreamManager;
import android.app.GameManager;
import android.app.GrammaticalInflectionManager;
import android.app.IAlarmManager;
import android.app.IGameManagerService;
import android.app.IGrammaticalInflectionManager;
import android.app.ILocaleManager;
import android.app.IWallpaperManager;
import android.app.KeyguardManager;
import android.app.LocaleManager;
import android.app.NotificationManager;
import android.app.SearchManager;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.app.UriGrantsManager;
import android.app.VrManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.app.admin.IDevicePolicyManager;
import android.app.ambientcontext.AmbientContextManager;
import android.app.ambientcontext.IAmbientContextManager;
import android.app.appfunctions.AppFunctionManager;
import android.app.appfunctions.AppFunctionManagerConfiguration;
import android.app.appfunctions.IAppFunctionManager;
import android.app.appsearch.AppSearchManagerFrameworkInitializer;
import android.app.blob.BlobStoreManagerFrameworkInitializer;
import android.app.contentsuggestions.ContentSuggestionsManager;
import android.app.contentsuggestions.IContentSuggestionsManager;
import android.app.contextualsearch.ContextualSearchManager;
import android.app.ecm.EnhancedConfirmationFrameworkInitializer;
import android.app.job.JobSchedulerFrameworkInitializer;
import android.app.ondeviceintelligence.OnDeviceIntelligenceFrameworkInitializer;
import android.app.people.PeopleManager;
import android.app.prediction.AppPredictionManager;
import android.app.role.RoleFrameworkInitializer;
import android.app.sdksandbox.SdkSandboxManagerFrameworkInitializer;
import android.app.search.SearchUiManager;
import android.app.slice.SliceManager;
import android.app.smartspace.SmartspaceManager;
import android.app.supervision.ISupervisionManager;
import android.app.supervision.SupervisionManager;
import android.app.time.TimeManager;
import android.app.timedetector.TimeDetector;
import android.app.timedetector.TimeDetectorImpl;
import android.app.timezonedetector.TimeZoneDetector;
import android.app.timezonedetector.TimeZoneDetectorImpl;
import android.app.trust.TrustManager;
import android.app.usage.IStorageStatsManager;
import android.app.usage.IUsageStatsManager;
import android.app.usage.StorageStatsManager;
import android.app.usage.UsageStatsManager;
import android.app.wallpapereffectsgeneration.IWallpaperEffectsGenerationManager;
import android.app.wallpapereffectsgeneration.WallpaperEffectsGenerationManager;
import android.app.wearable.IWearableSensingManager;
import android.app.wearable.WearableSensingManager;
import android.apphibernation.AppHibernationManager;
import android.appwidget.AppWidgetManager;
import android.bluetooth.BluetoothFrameworkInitializer;
import android.companion.CompanionDeviceManager;
import android.companion.ICompanionDeviceManager;
import android.companion.datatransfer.continuity.ITaskContinuityManager;
import android.companion.datatransfer.continuity.TaskContinuityManager;
import android.companion.virtual.IVirtualDeviceManager;
import android.companion.virtual.VirtualDeviceManager;
import android.compat.Compatibility;
import android.content.ClipboardManager;
import android.content.ContentCaptureOptions;
import android.content.Context;
import android.content.IRestrictionsManager;
import android.content.RestrictionsManager;
import android.content.om.IOverlayManager;
import android.content.om.OverlayManager;
import android.content.pm.ApplicationInfo;
import android.content.pm.CrossProfileApps;
import android.content.pm.DataLoaderManager;
import android.content.pm.ICrossProfileApps;
import android.content.pm.IDataLoaderManager;
import android.content.pm.IShortcutService;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ShortcutManager;
import android.content.pm.verify.domain.DomainVerificationManager;
import android.content.pm.verify.domain.IDomainVerificationManager;
import android.content.res.Resources;
import android.content.rollback.RollbackManagerFrameworkInitializer;
import android.credentials.CredentialManager;
import android.credentials.ICredentialManager;
import android.debug.AdbManager;
import android.debug.IAdbManager;
import android.devicelock.DeviceLockFrameworkInitializer;
import android.graphics.fonts.FontManager;
import android.hardware.ConsumerIrManager;
import android.hardware.ISensorPrivacyManager;
import android.hardware.ISerialManager;
import android.hardware.SensorManager;
import android.hardware.SensorPrivacyManager;
import android.hardware.SerialManager;
import android.hardware.SystemSensorManager;
import android.hardware.biometrics.BiometricManager;
import android.hardware.biometrics.IAuthService;
import android.hardware.camera2.CameraManager;
import android.hardware.devicestate.DeviceStateManager;
import android.hardware.display.ColorDisplayManager;
import android.hardware.display.DisplayManager;
import android.hardware.face.FaceManager;
import android.hardware.face.IFaceService;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.input.InputManager;
import android.hardware.iris.IIrisService;
import android.hardware.iris.IrisManager;
import android.hardware.lights.LightsManager;
import android.hardware.lights.SystemLightsManager;
import android.hardware.location.ContextHubManager;
import android.hardware.location.IContextHubService;
import android.hardware.radio.RadioManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbManager;
import android.health.connect.HealthServicesInitializer;
import android.location.CountryDetector;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.location.LocationManager;
import android.media.AudioDeviceVolumeManager;
import android.media.AudioManager;
import android.media.MediaFrameworkInitializer;
import android.media.MediaFrameworkPlatformInitializer;
import android.media.MediaRouter;
import android.media.metrics.IMediaMetricsManager;
import android.media.metrics.MediaMetricsManager;
import android.media.midi.IMidiManager;
import android.media.midi.MidiManager;
import android.media.musicrecognition.IMusicRecognitionManager;
import android.media.musicrecognition.MusicRecognitionManager;
import android.media.projection.MediaProjectionManager;
import android.media.quality.IMediaQualityManager;
import android.media.quality.MediaQualityManager;
import android.media.soundtrigger.SoundTriggerManager;
import android.media.tv.ITvInputManager;
import android.media.tv.TvInputManager;
import android.media.tv.ad.ITvAdManager;
import android.media.tv.ad.TvAdManager;
import android.media.tv.interactive.ITvInteractiveAppManager;
import android.media.tv.interactive.TvInteractiveAppManager;
import android.media.tv.tunerresourcemanager.ITunerResourceManager;
import android.media.tv.tunerresourcemanager.TunerResourceManager;
import android.nearby.NearbyFrameworkInitializer;
import android.net.ConnectivityFrameworkInitializer;
import android.net.ConnectivityFrameworkInitializerBaklava;
import android.net.ConnectivityFrameworkInitializerTiramisu;
import android.net.INetworkPolicyManager;
import android.net.IPacProxyManager;
import android.net.IVpnManager;
import android.net.NetworkPolicyManager;
import android.net.NetworkScoreManager;
import android.net.NetworkWatchlistManager;
import android.net.PacProxyManager;
import android.net.TetheringManager;
import android.net.VpnManager;
import android.net.wifi.WifiFrameworkInitializer;
import android.net.wifi.nl80211.WifiNl80211Manager;
import android.net.wifi.sharedconnectivity.app.SharedConnectivityManager;
import android.nfc.NfcFrameworkInitializer;
import android.ondevicepersonalization.OnDevicePersonalizationFrameworkInitializer;
import android.os.BatteryManager;
import android.os.BatteryStatsManager;
import android.os.BugreportManager;
import android.os.DropBoxManager;
import android.os.HardwarePropertiesManager;
import android.os.IBatteryPropertiesRegistrar;
import android.os.IBinder;
import android.os.IDumpstate;
import android.os.IHardwarePropertiesManager;
import android.os.IHintManager;
import android.os.IPowerManager;
import android.os.IPowerStatsService;
import android.os.IRecoverySystem;
import android.os.ISecurityStateManager;
import android.os.ISystemUpdateManager;
import android.os.IThermalService;
import android.os.IUserManager;
import android.os.IncidentManager;
import android.os.PerformanceHintManager;
import android.os.PermissionEnforcer;
import android.os.PowerManager;
import android.os.Process;
import android.os.ProfilingFrameworkInitializer;
import android.os.RecoverySystem;
import android.os.SecurityStateManager;
import android.os.ServiceManager;
import android.os.StatsFrameworkInitializer;
import android.os.SystemConfigManager;
import android.os.SystemUpdateManager;
import android.os.SystemVibrator;
import android.os.SystemVibratorManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.Vibrator;
import android.os.VibratorManager;
import android.os.flagging.ConfigInfrastructureFrameworkInitializer;
import android.os.health.SystemHealthManager;
import android.os.image.DynamicSystemManager;
import android.os.image.IDynamicSystemService;
import android.os.incremental.IIncrementalService;
import android.os.incremental.IncrementalManager;
import android.os.storage.StorageManager;
import android.permission.LegacyPermissionManager;
import android.permission.PermissionCheckerManager;
import android.permission.PermissionControllerManager;
import android.permission.PermissionManager;
import android.print.IPrintManager;
import android.print.PrintManager;
import android.provider.E2eeContactKeysManager;
import android.provider.ProviderFrameworkInitializer;
import android.ranging.RangingFrameworkInitializer;
import android.safetycenter.SafetyCenterFrameworkInitializer;
import android.scheduling.SchedulingFrameworkInitializer;
import android.security.FileIntegrityManager;
import android.security.IFileIntegrityService;
import android.security.advancedprotection.AdvancedProtectionManager;
import android.security.advancedprotection.IAdvancedProtectionService;
import android.security.attestationverification.AttestationVerificationManager;
import android.security.attestationverification.IAttestationVerificationManagerService;
import android.security.authenticationpolicy.AuthenticationPolicyManager;
import android.security.authenticationpolicy.IAuthenticationPolicyService;
import android.security.intrusiondetection.IIntrusionDetectionService;
import android.security.intrusiondetection.IntrusionDetectionManager;
import android.security.keystore.KeyStoreManager;
import android.service.chooser.ChooserManager;
import android.service.oemlock.IOemLockService;
import android.service.oemlock.OemLockManager;
import android.service.persistentdata.IPersistentDataBlockService;
import android.service.persistentdata.PersistentDataBlockManager;
import android.service.vr.IVrManager;
import android.system.virtualmachine.VirtualizationFrameworkInitializer;
import android.telecom.TelecomManager;
import android.telephony.MmsManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.TelephonyRegistryManager;
import android.transparency.BinaryTransparencyManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.uwb.UwbFrameworkInitializer;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.CaptioningManager;
import android.view.autofill.AutofillManager;
import android.view.autofill.IAutoFillManager;
import android.view.contentcapture.ContentCaptureManager;
import android.view.contentcapture.IContentCaptureManager;
import android.view.displayhash.DisplayHashManager;
import android.view.inputmethod.InputMethodManager;
import android.view.selectiontoolbar.ISelectionToolbarManager;
import android.view.selectiontoolbar.SelectionToolbarManager;
import android.view.textclassifier.TextClassificationManager;
import android.view.textservice.TextServicesManager;
import android.view.translation.ITranslationManager;
import android.view.translation.TranslationManager;
import android.view.translation.UiTranslationManager;
import android.webkit.WebViewBootstrapFrameworkInitializer;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.app.ISoundTriggerService;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.graphics.fonts.IFontManager;
import com.android.internal.hidden_from_bootclasspath.android.service.chooser.Flags;
import com.android.internal.net.INetworkWatchlistManager;
import com.android.internal.os.IBinaryTransparencyService;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.policy.PhoneLayoutInflater;
import com.android.internal.util.Preconditions;
import java.util.Map;
import java.util.Objects;

@SystemApi
public class SystemServiceRegistry {
    private static final String TAG = "SystemServiceRegistry";
    public static boolean sEnableServiceNotFoundWtf = false;
    static final long NULL_GAME_MANAGER_IN_WEAR = 340929737L;
    private static final Map<Class<?>, String> SYSTEM_SERVICE_NAMES = new ArrayMap();
    private static final Map<String, ServiceFetcher<?>> SYSTEM_SERVICE_FETCHERS = new ArrayMap();
    private static final Map<String, String> SYSTEM_SERVICE_CLASS_NAMES = new ArrayMap<String, String>();
    private static int sServiceCacheSize;
    private static volatile boolean sInitializing;

    private SystemServiceRegistry() {
    }

    private static void ensureInitializing(String methodName) {
        Preconditions.checkState(sInitializing, "Internal error: %s can only be called during class initialization.", methodName);
    }

    public static Object[] createServiceCache() {
        return new Object[sServiceCacheSize];
    }

    private static ServiceFetcher<?> getSystemServiceFetcher(String name) {
        if (name == null) {
            return null;
        }
        ServiceFetcher<?> fetcher = SYSTEM_SERVICE_FETCHERS.get(name);
        if (fetcher == null) {
            if (sEnableServiceNotFoundWtf) {
                Slog.wtf(TAG, "Unknown manager requested: " + name);
            }
            return null;
        }
        return fetcher;
    }

    private static boolean hasSystemFeatureOpportunistic(@NonNull ContextImpl ctx, @NonNull String featureName) {
        PackageManager manager = ctx.getPackageManager();
        if (manager == null) {
            return true;
        }
        return manager.hasSystemFeature(featureName);
    }

    public static Object getSystemService(@NonNull ContextImpl ctx, String name) {
        ServiceFetcher<?> fetcher = SystemServiceRegistry.getSystemServiceFetcher(name);
        if (fetcher == null) {
            return null;
        }
        Object ret = fetcher.getService(ctx);
        if (sEnableServiceNotFoundWtf && ret == null) {
            switch (name) {
                case "content_capture": 
                case "app_prediction": 
                case "incremental": 
                case "ethernet": 
                case "contexthub": 
                case "virtualization": 
                case "virtualdevice": {
                    return null;
                }
                case "vcn_management": {
                    if (SystemServiceRegistry.hasSystemFeatureOpportunistic(ctx, "android.hardware.telephony.subscription")) break;
                    return null;
                }
                case "search": {
                    if (!SystemServiceRegistry.hasSystemFeatureOpportunistic(ctx, "android.hardware.type.watch")) break;
                    return null;
                }
                case "appwidget": {
                    if (SystemServiceRegistry.hasSystemFeatureOpportunistic(ctx, "android.software.app_widgets")) break;
                    return null;
                }
                case "textservices": {
                    if (!com.android.internal.hidden_from_bootclasspath.android.server.Flags.removeTextService() || !SystemServiceRegistry.hasSystemFeatureOpportunistic(ctx, "android.hardware.type.watch")) break;
                    return null;
                }
            }
            Slog.wtf(TAG, "Manager wrapper not available: " + name);
            return null;
        }
        return ret;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.webkit.update_service_ipc_wrapper")
    @Nullable
    public static Object getSystemServiceWithNoContext(@NonNull String name) {
        ServiceFetcher<?> fetcher = SystemServiceRegistry.getSystemServiceFetcher(name);
        if (fetcher == null) {
            return null;
        }
        if (!fetcher.supportsFetchWithoutContext()) {
            throw new IllegalArgumentException("Manager cannot be fetched without a context: " + name);
        }
        return fetcher.getService(null);
    }

    public static String getSystemServiceName(Class<?> serviceClass) {
        if (serviceClass == null) {
            return null;
        }
        String serviceName = SYSTEM_SERVICE_NAMES.get(serviceClass);
        if (sEnableServiceNotFoundWtf && serviceName == null) {
            Slog.wtf(TAG, "Unknown manager requested: " + serviceClass.getCanonicalName());
        }
        return serviceName;
    }

    private static <T> void registerService(@NonNull String serviceName, @NonNull Class<T> serviceClass, @NonNull ServiceFetcher<T> serviceFetcher) {
        SYSTEM_SERVICE_NAMES.put(serviceClass, serviceName);
        SYSTEM_SERVICE_FETCHERS.put(serviceName, serviceFetcher);
        SYSTEM_SERVICE_CLASS_NAMES.put(serviceName, serviceClass.getSimpleName());
    }

    @Nullable
    public static String getSystemServiceClassName(@NonNull String name) {
        return SYSTEM_SERVICE_CLASS_NAMES.get(name);
    }

    @SystemApi
    public static <TServiceClass> void registerStaticService(final @NonNull String serviceName, @NonNull Class<TServiceClass> serviceWrapperClass, final @NonNull StaticServiceProducerWithBinder<TServiceClass> serviceProducer) {
        SystemServiceRegistry.ensureInitializing("registerStaticService");
        Preconditions.checkStringNotEmpty(serviceName);
        Objects.requireNonNull(serviceWrapperClass);
        Objects.requireNonNull(serviceProducer);
        SystemServiceRegistry.registerService(serviceName, serviceWrapperClass, new StaticServiceFetcher<TServiceClass>(){

            @Override
            public TServiceClass createService() throws ServiceManager.ServiceNotFoundException {
                return serviceProducer.createService(ServiceManager.getServiceOrThrow(serviceName));
            }
        });
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.webkit.update_service_ipc_wrapper")
    public static <TServiceClass> void registerForeverStaticService(final @NonNull String serviceName, @NonNull Class<TServiceClass> serviceWrapperClass, final @NonNull StaticServiceProducerWithBinder<TServiceClass> serviceProducer) {
        SystemServiceRegistry.ensureInitializing("registerStaticService");
        Preconditions.checkStringNotEmpty(serviceName);
        Objects.requireNonNull(serviceWrapperClass);
        Objects.requireNonNull(serviceProducer);
        SystemServiceRegistry.registerService(serviceName, serviceWrapperClass, new StaticServiceFetcher<TServiceClass>(){

            @Override
            public TServiceClass createService() throws ServiceManager.ServiceNotFoundException {
                return serviceProducer.createService(ServiceManager.getServiceOrThrow(serviceName));
            }

            @Override
            public boolean supportsFetchWithoutContext() {
                return true;
            }
        });
    }

    @SystemApi
    public static <TServiceClass> void registerStaticService(@NonNull String serviceName, @NonNull Class<TServiceClass> serviceWrapperClass, final @NonNull StaticServiceProducerWithoutBinder<TServiceClass> serviceProducer) {
        SystemServiceRegistry.ensureInitializing("registerStaticService");
        Preconditions.checkStringNotEmpty(serviceName);
        Objects.requireNonNull(serviceWrapperClass);
        Objects.requireNonNull(serviceProducer);
        SystemServiceRegistry.registerService(serviceName, serviceWrapperClass, new StaticServiceFetcher<TServiceClass>(){

            @Override
            public TServiceClass createService() {
                return serviceProducer.createService();
            }
        });
    }

    @SystemApi
    public static <TServiceClass> void registerContextAwareService(final @NonNull String serviceName, @NonNull Class<TServiceClass> serviceWrapperClass, final @NonNull ContextAwareServiceProducerWithBinder<TServiceClass> serviceProducer) {
        SystemServiceRegistry.ensureInitializing("registerContextAwareService");
        Preconditions.checkStringNotEmpty(serviceName);
        Objects.requireNonNull(serviceWrapperClass);
        Objects.requireNonNull(serviceProducer);
        SystemServiceRegistry.registerService(serviceName, serviceWrapperClass, new CachedServiceFetcher<TServiceClass>(){

            @Override
            public TServiceClass createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return serviceProducer.createService(ctx.getOuterContext(), ServiceManager.getServiceOrThrow(serviceName));
            }
        });
    }

    @SystemApi
    public static <TServiceClass> void registerContextAwareService(@NonNull String serviceName, @NonNull Class<TServiceClass> serviceWrapperClass, final @NonNull ContextAwareServiceProducerWithoutBinder<TServiceClass> serviceProducer) {
        SystemServiceRegistry.ensureInitializing("registerContextAwareService");
        Preconditions.checkStringNotEmpty(serviceName);
        Objects.requireNonNull(serviceWrapperClass);
        Objects.requireNonNull(serviceProducer);
        SystemServiceRegistry.registerService(serviceName, serviceWrapperClass, new CachedServiceFetcher<TServiceClass>(){

            @Override
            public TServiceClass createService(ContextImpl ctx) {
                return serviceProducer.createService(ctx.getOuterContext());
            }
        });
    }

    public static void onServiceNotFound(ServiceManager.ServiceNotFoundException e) {
        if (Process.myUid() < 10000) {
            Log.wtf(TAG, e.getMessage(), e);
        } else {
            Log.w(TAG, e.getMessage());
        }
    }

    static {
        SystemServiceRegistry.registerService("accessibility", AccessibilityManager.class, new CachedServiceFetcher<AccessibilityManager>(){

            @Override
            public AccessibilityManager createService(ContextImpl ctx) {
                return AccessibilityManager.getInstance(ctx);
            }
        });
        SystemServiceRegistry.registerService("captioning", CaptioningManager.class, new CachedServiceFetcher<CaptioningManager>(){

            @Override
            public CaptioningManager createService(ContextImpl ctx) {
                return new CaptioningManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("account", AccountManager.class, new CachedServiceFetcher<AccountManager>(){

            @Override
            public AccountManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("account");
                IAccountManager service = IAccountManager.Stub.asInterface(b);
                return new AccountManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("activity", ActivityManager.class, new CachedServiceFetcher<ActivityManager>(){

            @Override
            public ActivityManager createService(ContextImpl ctx) {
                return new ActivityManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("activity_task", ActivityTaskManager.class, new CachedServiceFetcher<ActivityTaskManager>(){

            @Override
            public ActivityTaskManager createService(ContextImpl ctx) {
                return ActivityTaskManager.getInstance();
            }
        });
        SystemServiceRegistry.registerService("uri_grants", UriGrantsManager.class, new CachedServiceFetcher<UriGrantsManager>(){

            @Override
            public UriGrantsManager createService(ContextImpl ctx) {
                return new UriGrantsManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("alarm", AlarmManager.class, new CachedServiceFetcher<AlarmManager>(){

            @Override
            public AlarmManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("alarm");
                IAlarmManager service = IAlarmManager.Stub.asInterface(b);
                return new AlarmManager(service, ctx);
            }
        });
        SystemServiceRegistry.registerService("audio", AudioManager.class, new CachedServiceFetcher<AudioManager>(){

            @Override
            public AudioManager createService(ContextImpl ctx) {
                return new AudioManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("audio_device_volume", AudioDeviceVolumeManager.class, new CachedServiceFetcher<AudioDeviceVolumeManager>(){

            @Override
            public AudioDeviceVolumeManager createService(ContextImpl ctx) {
                return new AudioDeviceVolumeManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("media_router", MediaRouter.class, new CachedServiceFetcher<MediaRouter>(){

            @Override
            public MediaRouter createService(ContextImpl ctx) {
                return new MediaRouter(ctx);
            }
        });
        SystemServiceRegistry.registerService("hdmi_control", HdmiControlManager.class, new StaticServiceFetcher<HdmiControlManager>(){

            @Override
            public HdmiControlManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("hdmi_control");
                return new HdmiControlManager(IHdmiControlService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("textclassification", TextClassificationManager.class, new CachedServiceFetcher<TextClassificationManager>(){

            @Override
            public TextClassificationManager createService(ContextImpl ctx) {
                return new TextClassificationManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("selection_toolbar", SelectionToolbarManager.class, new CachedServiceFetcher<SelectionToolbarManager>(){

            @Override
            public SelectionToolbarManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("selection_toolbar");
                return new SelectionToolbarManager(ISelectionToolbarManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("font", FontManager.class, new CachedServiceFetcher<FontManager>(){

            @Override
            public FontManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("font");
                return FontManager.create(IFontManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("clipboard", ClipboardManager.class, new CachedServiceFetcher<ClipboardManager>(){

            @Override
            public ClipboardManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new ClipboardManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SYSTEM_SERVICE_NAMES.put(android.text.ClipboardManager.class, "clipboard");
        SystemServiceRegistry.registerService("pac_proxy", PacProxyManager.class, new CachedServiceFetcher<PacProxyManager>(){

            @Override
            public PacProxyManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("pac_proxy");
                IPacProxyManager service = IPacProxyManager.Stub.asInterface(b);
                return new PacProxyManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("netd", IBinder.class, new StaticServiceFetcher<IBinder>(){

            @Override
            public IBinder createService() throws ServiceManager.ServiceNotFoundException {
                return ServiceManager.getServiceOrThrow("netd");
            }
        });
        SystemServiceRegistry.registerService("tethering", TetheringManager.class, new CachedServiceFetcher<TetheringManager>(){

            @Override
            public TetheringManager createService(ContextImpl ctx) {
                return new TetheringManager(ctx, () -> ServiceManager.getService("tethering"));
            }
        });
        SystemServiceRegistry.registerService("vpn_management", VpnManager.class, new CachedServiceFetcher<VpnManager>(){

            @Override
            public VpnManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("vpn_management");
                IVpnManager service = IVpnManager.Stub.asInterface(b);
                if (service == null && ctx.getPackageManager().hasSystemFeature("android.hardware.type.watch") && com.android.internal.hidden_from_bootclasspath.android.server.Flags.allowRemovingVpnService()) {
                    return null;
                }
                return new VpnManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("country_detector", CountryDetector.class, new StaticServiceFetcher<CountryDetector>(){

            @Override
            public CountryDetector createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("country_detector");
                return new CountryDetector(ICountryDetector.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("device_policy", DevicePolicyManager.class, new CachedServiceFetcher<DevicePolicyManager>(){

            @Override
            public DevicePolicyManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("device_policy");
                return new DevicePolicyManager(ctx, IDevicePolicyManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("download", DownloadManager.class, new CachedServiceFetcher<DownloadManager>(){

            @Override
            public DownloadManager createService(ContextImpl ctx) {
                return new DownloadManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("batterymanager", BatteryManager.class, new CachedServiceFetcher<BatteryManager>(){

            @Override
            public BatteryManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBatteryStats stats = IBatteryStats.Stub.asInterface(ServiceManager.getServiceOrThrow("batterystats"));
                IBatteryPropertiesRegistrar registrar = IBatteryPropertiesRegistrar.Stub.asInterface(ServiceManager.getServiceOrThrow("batteryproperties"));
                return new BatteryManager(ctx, stats, registrar);
            }
        });
        SystemServiceRegistry.registerService("dropbox", DropBoxManager.class, new CachedServiceFetcher<DropBoxManager>(){

            @Override
            public DropBoxManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("dropbox");
                IDropBoxManagerService service = IDropBoxManagerService.Stub.asInterface(b);
                return new DropBoxManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("transparency", BinaryTransparencyManager.class, new CachedServiceFetcher<BinaryTransparencyManager>(){

            @Override
            public BinaryTransparencyManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("transparency");
                IBinaryTransparencyService service = IBinaryTransparencyService.Stub.asInterface(b);
                return new BinaryTransparencyManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("input", InputManager.class, new CachedServiceFetcher<InputManager>(){

            @Override
            public InputManager createService(ContextImpl ctx) {
                return new InputManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("display", DisplayManager.class, new CachedServiceFetcher<DisplayManager>(){

            @Override
            public DisplayManager createService(ContextImpl ctx) {
                return new DisplayManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("color_display", ColorDisplayManager.class, new CachedServiceFetcher<ColorDisplayManager>(){

            @Override
            public ColorDisplayManager createService(ContextImpl ctx) {
                return new ColorDisplayManager();
            }
        });
        SystemServiceRegistry.registerService("input_method", InputMethodManager.class, new ServiceFetcher<InputMethodManager>(){

            @Override
            public InputMethodManager getService(ContextImpl ctx) {
                return InputMethodManager.forContext(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("textservices", TextServicesManager.class, new CachedServiceFetcher<TextServicesManager>(){

            @Override
            public TextServicesManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                if (ctx.getPackageManager().hasSystemFeature("android.hardware.type.watch") && ServiceManager.getService("textservices") == null && com.android.internal.hidden_from_bootclasspath.android.server.Flags.removeTextService()) {
                    return null;
                }
                return TextServicesManager.createInstance((Context)ctx);
            }
        });
        SystemServiceRegistry.registerService("keyguard", KeyguardManager.class, new CachedServiceFetcher<KeyguardManager>(){

            @Override
            public KeyguardManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new KeyguardManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("layout_inflater", LayoutInflater.class, new CachedServiceFetcher<LayoutInflater>(){

            @Override
            public LayoutInflater createService(ContextImpl ctx) {
                return new PhoneLayoutInflater(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("location", LocationManager.class, new CachedServiceFetcher<LocationManager>(){

            @Override
            public LocationManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("location");
                return new LocationManager(ctx, ILocationManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("netpolicy", NetworkPolicyManager.class, new CachedServiceFetcher<NetworkPolicyManager>(){

            @Override
            public NetworkPolicyManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new NetworkPolicyManager(ctx, INetworkPolicyManager.Stub.asInterface(ServiceManager.getServiceOrThrow("netpolicy")));
            }
        });
        SystemServiceRegistry.registerService("notification", NotificationManager.class, new CachedServiceFetcher<NotificationManager>(){

            @Override
            public NotificationManager createService(ContextImpl ctx) {
                Context outerContext = ctx.getOuterContext();
                return new NotificationManager(new ContextThemeWrapper(outerContext, Resources.selectSystemTheme(0, outerContext.getApplicationInfo().targetSdkVersion, 16973835, 16973935, 16974126, 16974130)));
            }
        });
        SystemServiceRegistry.registerService("people", PeopleManager.class, new CachedServiceFetcher<PeopleManager>(){

            @Override
            public PeopleManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new PeopleManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("power", PowerManager.class, new CachedServiceFetcher<PowerManager>(){

            @Override
            public PowerManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder powerBinder = ServiceManager.getServiceOrThrow("power");
                IPowerManager powerService = IPowerManager.Stub.asInterface(powerBinder);
                IBinder thermalBinder = ServiceManager.getServiceOrThrow("thermalservice");
                IThermalService thermalService = IThermalService.Stub.asInterface(thermalBinder);
                return new PowerManager(ctx.getOuterContext(), powerService, thermalService, ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("performance_hint", PerformanceHintManager.class, new CachedServiceFetcher<PerformanceHintManager>(){

            @Override
            public PerformanceHintManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return PerformanceHintManager.create();
            }
        });
        SystemServiceRegistry.registerService("recovery", RecoverySystem.class, new CachedServiceFetcher<RecoverySystem>(){

            @Override
            public RecoverySystem createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("recovery");
                IRecoverySystem service = IRecoverySystem.Stub.asInterface(b);
                return new RecoverySystem(service);
            }
        });
        SystemServiceRegistry.registerService("search", SearchManager.class, new CachedServiceFetcher<SearchManager>(){

            @Override
            public SearchManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new SearchManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("security_state", SecurityStateManager.class, new CachedServiceFetcher<SecurityStateManager>(){

            @Override
            public SecurityStateManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("security_state");
                ISecurityStateManager service = ISecurityStateManager.Stub.asInterface(b);
                return new SecurityStateManager(service);
            }
        });
        SystemServiceRegistry.registerService("sensor", SensorManager.class, new CachedServiceFetcher<SensorManager>(){

            @Override
            public SensorManager createService(ContextImpl ctx) {
                return new SystemSensorManager(ctx.getOuterContext(), ctx.mMainThread.getHandler().getLooper());
            }
        });
        SystemServiceRegistry.registerService("sensor_privacy", SensorPrivacyManager.class, new CachedServiceFetcher<SensorPrivacyManager>(){

            @Override
            public SensorPrivacyManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("sensor_privacy");
                return SensorPrivacyManager.getInstance(ctx, ISensorPrivacyManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("statusbar", StatusBarManager.class, new CachedServiceFetcher<StatusBarManager>(){

            @Override
            public StatusBarManager createService(ContextImpl ctx) {
                return new StatusBarManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("storage", StorageManager.class, new CachedServiceFetcher<StorageManager>(){

            @Override
            public StorageManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new StorageManager(ctx, ctx.mMainThread.getHandler().getLooper());
            }
        });
        SystemServiceRegistry.registerService("storagestats", StorageStatsManager.class, new CachedServiceFetcher<StorageStatsManager>(){

            @Override
            public StorageStatsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IStorageStatsManager service = IStorageStatsManager.Stub.asInterface(ServiceManager.getServiceOrThrow("storagestats"));
                return new StorageStatsManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("system_update", SystemUpdateManager.class, new CachedServiceFetcher<SystemUpdateManager>(){

            @Override
            public SystemUpdateManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("system_update");
                ISystemUpdateManager service = ISystemUpdateManager.Stub.asInterface(b);
                return new SystemUpdateManager(service);
            }
        });
        SystemServiceRegistry.registerService("system_config", SystemConfigManager.class, new CachedServiceFetcher<SystemConfigManager>(){

            @Override
            public SystemConfigManager createService(ContextImpl ctx) {
                return new SystemConfigManager();
            }
        });
        SystemServiceRegistry.registerService("telephony_registry", TelephonyRegistryManager.class, new CachedServiceFetcher<TelephonyRegistryManager>(){

            @Override
            public TelephonyRegistryManager createService(ContextImpl ctx) {
                return new TelephonyRegistryManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("telecom", TelecomManager.class, new CachedServiceFetcher<TelecomManager>(){

            @Override
            public TelecomManager createService(ContextImpl ctx) {
                return new TelecomManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("mms", MmsManager.class, new CachedServiceFetcher<MmsManager>(){

            @Override
            public MmsManager createService(ContextImpl ctx) {
                return new MmsManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("uimode", UiModeManager.class, new CachedServiceFetcher<UiModeManager>(){

            @Override
            public UiModeManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new UiModeManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("usb", UsbManager.class, new CachedServiceFetcher<UsbManager>(){

            @Override
            public UsbManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("usb");
                return new UsbManager(ctx, IUsbManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("adb", AdbManager.class, new CachedServiceFetcher<AdbManager>(){

            @Override
            public AdbManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("adb");
                return new AdbManager(ctx, IAdbManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("serial", SerialManager.class, new CachedServiceFetcher<SerialManager>(){

            @Override
            public SerialManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("serial");
                return new SerialManager(ctx, ISerialManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("vibrator_manager", VibratorManager.class, new CachedServiceFetcher<VibratorManager>(){

            @Override
            public VibratorManager createService(ContextImpl ctx) {
                return new SystemVibratorManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("vibrator", Vibrator.class, new CachedServiceFetcher<Vibrator>(){

            @Override
            public Vibrator createService(ContextImpl ctx) {
                return new SystemVibrator(ctx);
            }
        });
        SystemServiceRegistry.registerService("wallpaper", WallpaperManager.class, new CachedServiceFetcher<WallpaperManager>(){

            @Override
            public WallpaperManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("wallpaper");
                if (b == null) {
                    ApplicationInfo appInfo = ctx.getApplicationInfo();
                    if (appInfo.targetSdkVersion >= 28 && appInfo.isInstantApp()) {
                        throw new ServiceManager.ServiceNotFoundException("wallpaper");
                    }
                    boolean enabled = Resources.getSystem().getBoolean(17891741);
                    if (!enabled) {
                        return DisabledWallpaperManager.getInstance();
                    }
                    Log.e(SystemServiceRegistry.TAG, "No wallpaper service");
                }
                IWallpaperManager service = IWallpaperManager.Stub.asInterface(b);
                return new WallpaperManager(service, ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("wifinl80211", WifiNl80211Manager.class, new CachedServiceFetcher<WifiNl80211Manager>(){

            @Override
            public WifiNl80211Manager createService(ContextImpl ctx) {
                return new WifiNl80211Manager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("window", WindowManager.class, new CachedServiceFetcher<WindowManager>(){

            @Override
            public WindowManager createService(ContextImpl ctx) {
                return new WindowManagerImpl((Context)ctx);
            }
        });
        SystemServiceRegistry.registerService("user", UserManager.class, new CachedServiceFetcher<UserManager>(){

            @Override
            public UserManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("user");
                IUserManager service = IUserManager.Stub.asInterface(b);
                return new UserManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("appops", AppOpsManager.class, new CachedServiceFetcher<AppOpsManager>(){

            @Override
            public AppOpsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("appops");
                IAppOpsService service = IAppOpsService.Stub.asInterface(b);
                return new AppOpsManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("camera", CameraManager.class, new CachedServiceFetcher<CameraManager>(){

            @Override
            public CameraManager createService(ContextImpl ctx) {
                return new CameraManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("launcherapps", LauncherApps.class, new CachedServiceFetcher<LauncherApps>(){

            @Override
            public LauncherApps createService(ContextImpl ctx) {
                return new LauncherApps(ctx);
            }
        });
        SystemServiceRegistry.registerService("restrictions", RestrictionsManager.class, new CachedServiceFetcher<RestrictionsManager>(){

            @Override
            public RestrictionsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("restrictions");
                IRestrictionsManager service = IRestrictionsManager.Stub.asInterface(b);
                return new RestrictionsManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("print", PrintManager.class, new CachedServiceFetcher<PrintManager>(){

            @Override
            public PrintManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IPrintManager service = null;
                if (ctx.getPackageManager().hasSystemFeature("android.software.print")) {
                    service = IPrintManager.Stub.asInterface(ServiceManager.getServiceOrThrow("print"));
                }
                int userId = ctx.getUserId();
                int appId = UserHandle.getAppId(ctx.getApplicationInfo().uid);
                return new PrintManager(ctx.getOuterContext(), service, userId, appId);
            }
        });
        SystemServiceRegistry.registerService("companiondevice", CompanionDeviceManager.class, new CachedServiceFetcher<CompanionDeviceManager>(){

            @Override
            public CompanionDeviceManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                ICompanionDeviceManager service = null;
                if (ctx.getPackageManager().hasSystemFeature("android.software.companion_device_setup")) {
                    service = ICompanionDeviceManager.Stub.asInterface(ServiceManager.getServiceOrThrow("companiondevice"));
                }
                return new CompanionDeviceManager(service, ctx.getOuterContext());
            }
        });
        if (com.android.internal.hidden_from_bootclasspath.android.app.appfunctions.flags.Flags.enableAppFunctionManager()) {
            SystemServiceRegistry.registerService("app_function", AppFunctionManager.class, new CachedServiceFetcher<AppFunctionManager>(){

                @Override
                public AppFunctionManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                    if (!AppFunctionManagerConfiguration.isSupported(ctx)) {
                        return null;
                    }
                    IAppFunctionManager service = IAppFunctionManager.Stub.asInterface(ServiceManager.getServiceOrThrow("app_function"));
                    return new AppFunctionManager(service, ctx.getOuterContext());
                }
            });
        }
        SystemServiceRegistry.registerService("virtualdevice", VirtualDeviceManager.class, new CachedServiceFetcher<VirtualDeviceManager>(){

            @Override
            public VirtualDeviceManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                if (!ctx.getResources().getBoolean(17891740)) {
                    return null;
                }
                IVirtualDeviceManager service = IVirtualDeviceManager.Stub.asInterface(ServiceManager.getServiceOrThrow("virtualdevice"));
                return new VirtualDeviceManager(service, ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("consumer_ir", ConsumerIrManager.class, new CachedServiceFetcher<ConsumerIrManager>(){

            @Override
            public ConsumerIrManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new ConsumerIrManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("trust", TrustManager.class, new StaticServiceFetcher<TrustManager>(){

            @Override
            public TrustManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("trust");
                return new TrustManager(b);
            }
        });
        SystemServiceRegistry.registerService("fingerprint", FingerprintManager.class, new CachedServiceFetcher<FingerprintManager>(){

            @Override
            public FingerprintManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder binder = ctx.getApplicationInfo().targetSdkVersion >= 26 ? ServiceManager.getServiceOrThrow("fingerprint") : ServiceManager.getService("fingerprint");
                IFingerprintService service = IFingerprintService.Stub.asInterface(binder);
                return new FingerprintManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("face", FaceManager.class, new CachedServiceFetcher<FaceManager>(){

            @Override
            public FaceManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder binder = ctx.getApplicationInfo().targetSdkVersion >= 26 ? ServiceManager.getServiceOrThrow("face") : ServiceManager.getService("face");
                IFaceService service = IFaceService.Stub.asInterface(binder);
                return new FaceManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("iris", IrisManager.class, new CachedServiceFetcher<IrisManager>(){

            @Override
            public IrisManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder binder = ServiceManager.getServiceOrThrow("iris");
                IIrisService service = IIrisService.Stub.asInterface(binder);
                return new IrisManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("biometric", BiometricManager.class, new CachedServiceFetcher<BiometricManager>(){

            @Override
            public BiometricManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder binder = ServiceManager.getServiceOrThrow("auth");
                IAuthService service = IAuthService.Stub.asInterface(binder);
                return new BiometricManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("authentication_policy", AuthenticationPolicyManager.class, new CachedServiceFetcher<AuthenticationPolicyManager>(){

            @Override
            public AuthenticationPolicyManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                if (!com.android.internal.hidden_from_bootclasspath.android.security.Flags.secureLockdown()) {
                    throw new ServiceManager.ServiceNotFoundException("authentication_policy");
                }
                IBinder binder = ServiceManager.getServiceOrThrow("authentication_policy");
                IAuthenticationPolicyService service = IAuthenticationPolicyService.Stub.asInterface(binder);
                return new AuthenticationPolicyManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("tv_interactive_app", TvInteractiveAppManager.class, new CachedServiceFetcher<TvInteractiveAppManager>(){

            @Override
            public TvInteractiveAppManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("tv_interactive_app");
                ITvInteractiveAppManager service = ITvInteractiveAppManager.Stub.asInterface(iBinder);
                return new TvInteractiveAppManager(service, ctx.getUserId());
            }
        });
        SystemServiceRegistry.registerService("tv_ad", TvAdManager.class, new CachedServiceFetcher<TvAdManager>(){

            @Override
            public TvAdManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("tv_ad");
                ITvAdManager service = ITvAdManager.Stub.asInterface(iBinder);
                return new TvAdManager(service, ctx.getUserId());
            }
        });
        SystemServiceRegistry.registerService("tv_input", TvInputManager.class, new CachedServiceFetcher<TvInputManager>(){

            @Override
            public TvInputManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("tv_input");
                ITvInputManager service = ITvInputManager.Stub.asInterface(iBinder);
                return new TvInputManager(service, ctx.getUserId());
            }
        });
        SystemServiceRegistry.registerService("tv_tuner_resource_mgr", TunerResourceManager.class, new CachedServiceFetcher<TunerResourceManager>(){

            @Override
            public TunerResourceManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("tv_tuner_resource_mgr");
                ITunerResourceManager service = ITunerResourceManager.Stub.asInterface(iBinder);
                return new TunerResourceManager(service, ctx.getUserId());
            }
        });
        SystemServiceRegistry.registerService("network_score", NetworkScoreManager.class, new CachedServiceFetcher<NetworkScoreManager>(){

            @Override
            public NetworkScoreManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new NetworkScoreManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("usagestats", UsageStatsManager.class, new CachedServiceFetcher<UsageStatsManager>(){

            @Override
            public UsageStatsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("usagestats");
                IUsageStatsManager service = IUsageStatsManager.Stub.asInterface(iBinder);
                return new UsageStatsManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("persistent_data_block", PersistentDataBlockManager.class, new StaticServiceFetcher<PersistentDataBlockManager>(){

            @Override
            public PersistentDataBlockManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("persistent_data_block");
                IPersistentDataBlockService persistentDataBlockService = IPersistentDataBlockService.Stub.asInterface(b);
                if (persistentDataBlockService != null) {
                    return new PersistentDataBlockManager(persistentDataBlockService);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("oem_lock", OemLockManager.class, new StaticServiceFetcher<OemLockManager>(){

            @Override
            public OemLockManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("oem_lock");
                IOemLockService oemLockService = IOemLockService.Stub.asInterface(b);
                if (oemLockService != null) {
                    return new OemLockManager(oemLockService);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("media_projection", MediaProjectionManager.class, new CachedServiceFetcher<MediaProjectionManager>(){

            @Override
            public MediaProjectionManager createService(ContextImpl ctx) {
                return new MediaProjectionManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("appwidget", AppWidgetManager.class, new CachedServiceFetcher<AppWidgetManager>(){

            @Override
            public AppWidgetManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("appwidget");
                return b == null ? null : new AppWidgetManager(ctx, IAppWidgetService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("midi", MidiManager.class, new CachedServiceFetcher<MidiManager>(){

            @Override
            public MidiManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("midi");
                return new MidiManager(IMidiManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("broadcastradio", RadioManager.class, new CachedServiceFetcher<RadioManager>(){

            @Override
            public RadioManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new RadioManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("hardware_properties", HardwarePropertiesManager.class, new CachedServiceFetcher<HardwarePropertiesManager>(){

            @Override
            public HardwarePropertiesManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("hardware_properties");
                IHardwarePropertiesManager service = IHardwarePropertiesManager.Stub.asInterface(b);
                return new HardwarePropertiesManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("soundtrigger", SoundTriggerManager.class, new CachedServiceFetcher<SoundTriggerManager>(){

            @Override
            public SoundTriggerManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("soundtrigger");
                return new SoundTriggerManager(ctx, ISoundTriggerService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("shortcut", ShortcutManager.class, new CachedServiceFetcher<ShortcutManager>(){

            @Override
            public ShortcutManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("shortcut");
                return new ShortcutManager(ctx, IShortcutService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("overlay", OverlayManager.class, new CachedServiceFetcher<OverlayManager>(){

            @Override
            public OverlayManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = Compatibility.isChangeEnabled(205919743L) ? ServiceManager.getService("overlay") : ServiceManager.getServiceOrThrow("overlay");
                return new OverlayManager(ctx, IOverlayManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("network_watchlist", NetworkWatchlistManager.class, new CachedServiceFetcher<NetworkWatchlistManager>(){

            @Override
            public NetworkWatchlistManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("network_watchlist");
                return new NetworkWatchlistManager(ctx, INetworkWatchlistManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("systemhealth", SystemHealthManager.class, new CachedServiceFetcher<SystemHealthManager>(){

            @Override
            public SystemHealthManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder batteryStats = ServiceManager.getServiceOrThrow("batterystats");
                IBinder powerStats = ServiceManager.getService("powerstats");
                IBinder perfHint = ServiceManager.getService("performance_hint");
                return new SystemHealthManager(IBatteryStats.Stub.asInterface(batteryStats), IPowerStatsService.Stub.asInterface(powerStats), IHintManager.Stub.asInterface(perfHint));
            }
        });
        SystemServiceRegistry.registerService("contexthub", ContextHubManager.class, new CachedServiceFetcher<ContextHubManager>(){

            @Override
            public ContextHubManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("contexthub");
                if (b == null) {
                    return null;
                }
                return new ContextHubManager(IContextHubService.Stub.asInterface(b), ctx.mMainThread.getHandler().getLooper());
            }
        });
        SystemServiceRegistry.registerService("incident", IncidentManager.class, new CachedServiceFetcher<IncidentManager>(){

            @Override
            public IncidentManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new IncidentManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("bugreport", BugreportManager.class, new CachedServiceFetcher<BugreportManager>(){

            @Override
            public BugreportManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("bugreport");
                return new BugreportManager(ctx.getOuterContext(), IDumpstate.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("autofill", AutofillManager.class, new CachedServiceFetcher<AutofillManager>(){

            @Override
            public AutofillManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("autofill");
                IAutoFillManager service = IAutoFillManager.Stub.asInterface(b);
                return new AutofillManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("credential", CredentialManager.class, new CachedServiceFetcher<CredentialManager>(){

            @Override
            public CredentialManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("credential");
                ICredentialManager service = ICredentialManager.Stub.asInterface(b);
                if (service != null) {
                    return new CredentialManager(ctx.getOuterContext(), service);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("music_recognition", MusicRecognitionManager.class, new CachedServiceFetcher<MusicRecognitionManager>(){

            @Override
            public MusicRecognitionManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("music_recognition");
                return new MusicRecognitionManager(IMusicRecognitionManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("content_capture", ContentCaptureManager.class, new CachedServiceFetcher<ContentCaptureManager>(){

            @Override
            public ContentCaptureManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b;
                IContentCaptureManager service;
                Context outerContext = ctx.getOuterContext();
                ContentCaptureOptions options = outerContext.getContentCaptureOptions();
                if (options != null && (options.lite || options.isWhitelisted(outerContext)) && (service = IContentCaptureManager.Stub.asInterface(b = ServiceManager.getService("content_capture"))) != null) {
                    return new ContentCaptureManager(outerContext, service, options);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("translation", TranslationManager.class, new CachedServiceFetcher<TranslationManager>(){

            @Override
            public TranslationManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("translation");
                ITranslationManager service = ITranslationManager.Stub.asInterface(b);
                if (service != null) {
                    return new TranslationManager(ctx.getOuterContext(), service);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("ui_translation", UiTranslationManager.class, new CachedServiceFetcher<UiTranslationManager>(){

            @Override
            public UiTranslationManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("translation");
                ITranslationManager service = ITranslationManager.Stub.asInterface(b);
                if (service != null) {
                    return new UiTranslationManager(ctx.getOuterContext(), service);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("search_ui", SearchUiManager.class, new CachedServiceFetcher<SearchUiManager>(){

            @Override
            public SearchUiManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("search_ui");
                return b == null ? null : new SearchUiManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("smartspace", SmartspaceManager.class, new CachedServiceFetcher<SmartspaceManager>(){

            @Override
            public SmartspaceManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("smartspace");
                return b == null ? null : new SmartspaceManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("contextual_search", ContextualSearchManager.class, new CachedServiceFetcher<ContextualSearchManager>(){

            @Override
            public ContextualSearchManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("contextual_search");
                return b == null ? null : new ContextualSearchManager();
            }
        });
        SystemServiceRegistry.registerService("app_prediction", AppPredictionManager.class, new CachedServiceFetcher<AppPredictionManager>(){

            @Override
            public AppPredictionManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("app_prediction");
                return b == null ? null : new AppPredictionManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("content_suggestions", ContentSuggestionsManager.class, new CachedServiceFetcher<ContentSuggestionsManager>(){

            @Override
            public ContentSuggestionsManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("content_suggestions");
                IContentSuggestionsManager service = IContentSuggestionsManager.Stub.asInterface(b);
                return new ContentSuggestionsManager(ctx.getUserId(), service);
            }
        });
        SystemServiceRegistry.registerService("wallpaper_effects_generation", WallpaperEffectsGenerationManager.class, new CachedServiceFetcher<WallpaperEffectsGenerationManager>(){

            @Override
            public WallpaperEffectsGenerationManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("wallpaper_effects_generation");
                return b == null ? null : new WallpaperEffectsGenerationManager(IWallpaperEffectsGenerationManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("vrmanager", VrManager.class, new CachedServiceFetcher<VrManager>(){

            @Override
            public VrManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("vrmanager");
                return new VrManager(IVrManager.Stub.asInterface(b));
            }
        });
        if (com.android.internal.hidden_from_bootclasspath.android.companion.Flags.enableTaskContinuity()) {
            SystemServiceRegistry.registerService("task_continuity", TaskContinuityManager.class, new CachedServiceFetcher<TaskContinuityManager>(){

                @Override
                public TaskContinuityManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                    IBinder iBinder = ServiceManager.getServiceOrThrow("task_continuity");
                    ITaskContinuityManager service = ITaskContinuityManager.Stub.asInterface(iBinder);
                    return new TaskContinuityManager(ctx, service);
                }
            });
        }
        SystemServiceRegistry.registerService("crossprofileapps", CrossProfileApps.class, new CachedServiceFetcher<CrossProfileApps>(){

            @Override
            public CrossProfileApps createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("crossprofileapps");
                return new CrossProfileApps(ctx.getOuterContext(), ICrossProfileApps.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("slice", SliceManager.class, new CachedServiceFetcher<SliceManager>(){

            @Override
            public SliceManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new SliceManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("time_detector", TimeDetector.class, new CachedServiceFetcher<TimeDetector>(){

            @Override
            public TimeDetector createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new TimeDetectorImpl();
            }
        });
        SystemServiceRegistry.registerService("time_zone_detector", TimeZoneDetector.class, new CachedServiceFetcher<TimeZoneDetector>(){

            @Override
            public TimeZoneDetector createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new TimeZoneDetectorImpl();
            }
        });
        SystemServiceRegistry.registerService("time_manager", TimeManager.class, new CachedServiceFetcher<TimeManager>(){

            @Override
            public TimeManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new TimeManager();
            }
        });
        SystemServiceRegistry.registerService("permission", PermissionManager.class, new CachedServiceFetcher<PermissionManager>(){

            @Override
            public PermissionManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new PermissionManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("legacy_permission", LegacyPermissionManager.class, new CachedServiceFetcher<LegacyPermissionManager>(){

            @Override
            public LegacyPermissionManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new LegacyPermissionManager();
            }
        });
        SystemServiceRegistry.registerService("permission_controller", PermissionControllerManager.class, new CachedServiceFetcher<PermissionControllerManager>(){

            @Override
            public PermissionControllerManager createService(ContextImpl ctx) {
                return new PermissionControllerManager(ctx.getOuterContext(), ctx.getMainThreadHandler());
            }
        });
        SystemServiceRegistry.registerService("permission_checker", PermissionCheckerManager.class, new CachedServiceFetcher<PermissionCheckerManager>(){

            @Override
            public PermissionCheckerManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new PermissionCheckerManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("permission_enforcer", PermissionEnforcer.class, new CachedServiceFetcher<PermissionEnforcer>(){

            @Override
            public PermissionEnforcer createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new PermissionEnforcer(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("dynamic_system", DynamicSystemManager.class, new CachedServiceFetcher<DynamicSystemManager>(){

            @Override
            public DynamicSystemManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("dynamic_system");
                return new DynamicSystemManager(IDynamicSystemService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("batterystats", BatteryStatsManager.class, new CachedServiceFetcher<BatteryStatsManager>(){

            @Override
            public BatteryStatsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("batterystats");
                return new BatteryStatsManager(IBatteryStats.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("dataloader_manager", DataLoaderManager.class, new CachedServiceFetcher<DataLoaderManager>(){

            @Override
            public DataLoaderManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("dataloader_manager");
                return new DataLoaderManager(IDataLoaderManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("lights", LightsManager.class, new CachedServiceFetcher<LightsManager>(){

            @Override
            public LightsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new SystemLightsManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("locale", LocaleManager.class, new CachedServiceFetcher<LocaleManager>(){

            @Override
            public LocaleManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new LocaleManager(ctx, ILocaleManager.Stub.asInterface(ServiceManager.getServiceOrThrow("locale")));
            }
        });
        SystemServiceRegistry.registerService("incremental", IncrementalManager.class, new CachedServiceFetcher<IncrementalManager>(){

            @Override
            public IncrementalManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("incremental");
                if (b == null) {
                    return null;
                }
                return new IncrementalManager(IIncrementalService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("file_integrity", FileIntegrityManager.class, new CachedServiceFetcher<FileIntegrityManager>(){

            @Override
            public FileIntegrityManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("file_integrity");
                return new FileIntegrityManager(ctx.getOuterContext(), IFileIntegrityService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("attestation_verification", AttestationVerificationManager.class, new CachedServiceFetcher<AttestationVerificationManager>(){

            @Override
            public AttestationVerificationManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("attestation_verification");
                return new AttestationVerificationManager(ctx.getOuterContext(), IAttestationVerificationManagerService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("app_hibernation", AppHibernationManager.class, new CachedServiceFetcher<AppHibernationManager>(){

            @Override
            public AppHibernationManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("app_hibernation");
                return b == null ? null : new AppHibernationManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("dream", DreamManager.class, new CachedServiceFetcher<DreamManager>(){

            @Override
            public DreamManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new DreamManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("device_state", DeviceStateManager.class, new CachedServiceFetcher<DeviceStateManager>(){

            @Override
            public DeviceStateManager createService(ContextImpl ctx) {
                return new DeviceStateManager();
            }
        });
        SystemServiceRegistry.registerService("media_metrics", MediaMetricsManager.class, new CachedServiceFetcher<MediaMetricsManager>(){

            @Override
            public MediaMetricsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("media_metrics");
                IMediaMetricsManager service = IMediaMetricsManager.Stub.asInterface(iBinder);
                return new MediaMetricsManager(service, ctx.getUserId());
            }
        });
        SystemServiceRegistry.registerService("game", GameManager.class, new CachedServiceFetcher<GameManager>(){

            @Override
            public GameManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder binder;
                PackageManager pm = ctx.getPackageManager();
                boolean isWatch = pm.hasSystemFeature("android.hardware.type.watch");
                IBinder iBinder = binder = com.android.internal.hidden_from_bootclasspath.android.server.Flags.removeGameManagerServiceFromWear() && isWatch ? ServiceManager.getService("game") : ServiceManager.getServiceOrThrow("game");
                if (binder == null && Compatibility.isChangeEnabled(340929737L)) {
                    return null;
                }
                return new GameManager(ctx.getOuterContext(), IGameManagerService.Stub.asInterface(binder));
            }
        });
        SystemServiceRegistry.registerService("domain_verification", DomainVerificationManager.class, new CachedServiceFetcher<DomainVerificationManager>(){

            @Override
            public DomainVerificationManager createService(ContextImpl context) throws ServiceManager.ServiceNotFoundException {
                IBinder binder = ServiceManager.getServiceOrThrow("domain_verification");
                IDomainVerificationManager service = IDomainVerificationManager.Stub.asInterface(binder);
                return new DomainVerificationManager(context, service);
            }
        });
        SystemServiceRegistry.registerService("display_hash", DisplayHashManager.class, new CachedServiceFetcher<DisplayHashManager>(){

            @Override
            public DisplayHashManager createService(ContextImpl ctx) {
                return new DisplayHashManager();
            }
        });
        SystemServiceRegistry.registerService("ambient_context", AmbientContextManager.class, new CachedServiceFetcher<AmbientContextManager>(){

            @Override
            public AmbientContextManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("ambient_context");
                IAmbientContextManager manager = IAmbientContextManager.Stub.asInterface(iBinder);
                return new AmbientContextManager(ctx.getOuterContext(), manager);
            }
        });
        SystemServiceRegistry.registerService("wearable_sensing", WearableSensingManager.class, new CachedServiceFetcher<WearableSensingManager>(){

            @Override
            public WearableSensingManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getService("wearable_sensing");
                if (iBinder != null) {
                    IWearableSensingManager manager = IWearableSensingManager.Stub.asInterface(iBinder);
                    return new WearableSensingManager(ctx.getOuterContext(), manager);
                }
                if (ctx.getPackageManager().hasSystemFeature("android.hardware.type.watch") && com.android.internal.hidden_from_bootclasspath.android.server.Flags.removeWearableSensingServiceFromWear()) {
                    return null;
                }
                throw new ServiceManager.ServiceNotFoundException("wearable_sensing");
            }
        });
        SystemServiceRegistry.registerService("grammatical_inflection", GrammaticalInflectionManager.class, new CachedServiceFetcher<GrammaticalInflectionManager>(){

            @Override
            public GrammaticalInflectionManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new GrammaticalInflectionManager(ctx, IGrammaticalInflectionManager.Stub.asInterface(ServiceManager.getServiceOrThrow("grammatical_inflection")));
            }
        });
        SystemServiceRegistry.registerService("shared_connectivity", SharedConnectivityManager.class, new CachedServiceFetcher<SharedConnectivityManager>(){

            @Override
            public SharedConnectivityManager createService(ContextImpl ctx) {
                return SharedConnectivityManager.create(ctx);
            }
        });
        SystemServiceRegistry.registerService("keystore", KeyStoreManager.class, new StaticServiceFetcher<KeyStoreManager>(){

            @Override
            public KeyStoreManager createService() throws ServiceManager.ServiceNotFoundException {
                if (!com.android.internal.hidden_from_bootclasspath.android.security.Flags.keystoreGrantApi()) {
                    throw new ServiceManager.ServiceNotFoundException("KeyStoreManager is not supported");
                }
                return KeyStoreManager.getInstance();
            }
        });
        SystemServiceRegistry.registerService("contact_keys", E2eeContactKeysManager.class, new CachedServiceFetcher<E2eeContactKeysManager>(){

            @Override
            public E2eeContactKeysManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                if (!com.android.internal.hidden_from_bootclasspath.android.provider.Flags.userKeys()) {
                    throw new ServiceManager.ServiceNotFoundException("ContactKeysManager is not supported");
                }
                return new E2eeContactKeysManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("supervision", SupervisionManager.class, new CachedServiceFetcher<SupervisionManager>(){

            @Override
            public SupervisionManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                if (!com.android.internal.hidden_from_bootclasspath.android.app.supervision.flags.Flags.supervisionApi()) {
                    throw new ServiceManager.ServiceNotFoundException("SupervisionManager is not supported");
                }
                IBinder iBinder = ServiceManager.getServiceOrThrow("supervision");
                ISupervisionManager service = ISupervisionManager.Stub.asInterface(iBinder);
                return new SupervisionManager(ctx, service);
            }
        });
        if (com.android.internal.hidden_from_bootclasspath.android.security.Flags.aapmApi()) {
            SystemServiceRegistry.registerService("advanced_protection", AdvancedProtectionManager.class, new CachedServiceFetcher<AdvancedProtectionManager>(){

                @Override
                public AdvancedProtectionManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                    IBinder iBinder = ServiceManager.getService("advanced_protection");
                    IAdvancedProtectionService service = IAdvancedProtectionService.Stub.asInterface(iBinder);
                    if (service == null) {
                        return null;
                    }
                    return new AdvancedProtectionManager(service);
                }
            });
        }
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.bicClient()) {
            SystemServiceRegistry.registerService("background_install_control", BackgroundInstallControlManager.class, new CachedServiceFetcher<BackgroundInstallControlManager>(){

                @Override
                public BackgroundInstallControlManager createService(ContextImpl ctx) {
                    return new BackgroundInstallControlManager(ctx);
                }
            });
        }
        SystemServiceRegistry.registerService("media_quality", MediaQualityManager.class, new CachedServiceFetcher<MediaQualityManager>(){

            @Override
            public MediaQualityManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("media_quality");
                IMediaQualityManager service = IMediaQualityManager.Stub.asInterface(iBinder);
                return new MediaQualityManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("intrusion_detection", IntrusionDetectionManager.class, new CachedServiceFetcher<IntrusionDetectionManager>(){

            @Override
            public IntrusionDetectionManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                if (!com.android.internal.hidden_from_bootclasspath.android.security.Flags.aflApi()) {
                    throw new ServiceManager.ServiceNotFoundException("Intrusion Detection is not supported");
                }
                IBinder b = ServiceManager.getServiceOrThrow("intrusion_detection");
                IIntrusionDetectionService service = IIntrusionDetectionService.Stub.asInterface(b);
                return new IntrusionDetectionManager(service);
            }
        });
        if (Flags.interactiveChooser()) {
            SystemServiceRegistry.registerService("chooser", ChooserManager.class, new StaticServiceFetcher<ChooserManager>(){

                @Override
                public ChooserManager createService() {
                    return new ChooserManager();
                }
            });
        }
        sInitializing = true;
        try {
            ConnectivityFrameworkInitializer.registerServiceWrappers();
            JobSchedulerFrameworkInitializer.registerServiceWrappers();
            BlobStoreManagerFrameworkInitializer.initialize();
            BluetoothFrameworkInitializer.registerServiceWrappers();
            NfcFrameworkInitializer.registerServiceWrappers();
            TelephonyFrameworkInitializer.registerServiceWrappers();
            AppSearchManagerFrameworkInitializer.initialize();
            HealthServicesInitializer.registerServiceWrappers();
            WifiFrameworkInitializer.registerServiceWrappers();
            StatsFrameworkInitializer.registerServiceWrappers();
            RollbackManagerFrameworkInitializer.initialize();
            MediaFrameworkPlatformInitializer.registerServiceWrappers();
            MediaFrameworkInitializer.registerServiceWrappers();
            RoleFrameworkInitializer.registerServiceWrappers();
            SchedulingFrameworkInitializer.registerServiceWrappers();
            SdkSandboxManagerFrameworkInitializer.registerServiceWrappers();
            AdServicesFrameworkInitializer.registerServiceWrappers();
            UwbFrameworkInitializer.registerServiceWrappers();
            SafetyCenterFrameworkInitializer.registerServiceWrappers();
            ConnectivityFrameworkInitializerTiramisu.registerServiceWrappers();
            NearbyFrameworkInitializer.registerServiceWrappers();
            OnDevicePersonalizationFrameworkInitializer.registerServiceWrappers();
            OnDeviceIntelligenceFrameworkInitializer.registerServiceWrappers();
            DeviceLockFrameworkInitializer.registerServiceWrappers();
            VirtualizationFrameworkInitializer.registerServiceWrappers();
            ConnectivityFrameworkInitializerBaklava.registerServiceWrappers();
            if (com.android.internal.hidden_from_bootclasspath.android.provider.flags.Flags.newStoragePublicApi()) {
                ConfigInfrastructureFrameworkInitializer.registerServiceWrappers();
            }
            if (com.android.internal.hidden_from_bootclasspath.com.android.server.telecom.flags.Flags.telecomMainlineBlockedNumbersManager()) {
                ProviderFrameworkInitializer.registerServiceWrappers();
            }
            if (com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags.enhancedConfirmationModeApisEnabled()) {
                EnhancedConfirmationFrameworkInitializer.registerServiceWrappers();
            }
            if (com.android.internal.hidden_from_bootclasspath.android.server.Flags.telemetryApisService()) {
                ProfilingFrameworkInitializer.registerServiceWrappers();
            }
            if (com.android.internal.hidden_from_bootclasspath.android.webkit.Flags.updateServiceIpcWrapper()) {
                WebViewBootstrapFrameworkInitializer.registerServiceWrappers();
            }
            RangingFrameworkInitializer.registerServiceWrappers();
        }
        finally {
            sInitializing = false;
        }
    }

    static interface ServiceFetcher<T> {
        public T getService(ContextImpl var1);

        default public boolean supportsFetchWithoutContext() {
            return false;
        }
    }

    @SystemApi
    public static interface StaticServiceProducerWithBinder<TServiceClass> {
        @NonNull
        public TServiceClass createService(@NonNull IBinder var1);
    }

    @SystemApi
    public static interface StaticServiceProducerWithoutBinder<TServiceClass> {
        @NonNull
        public TServiceClass createService();
    }

    @SystemApi
    public static interface ContextAwareServiceProducerWithBinder<TServiceClass> {
        @NonNull
        public TServiceClass createService(@NonNull Context var1, @NonNull IBinder var2);
    }

    @SystemApi
    public static interface ContextAwareServiceProducerWithoutBinder<TServiceClass> {
        @NonNull
        public TServiceClass createService(@NonNull Context var1);
    }

    static abstract class StaticServiceFetcher<T>
    implements ServiceFetcher<T> {
        private T mCachedInstance;

        StaticServiceFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getService(ContextImpl ctx) {
            StaticServiceFetcher staticServiceFetcher = this;
            synchronized (staticServiceFetcher) {
                if (this.mCachedInstance == null) {
                    try {
                        this.mCachedInstance = this.createService();
                    }
                    catch (ServiceManager.ServiceNotFoundException e) {
                        SystemServiceRegistry.onServiceNotFound(e);
                    }
                }
                return this.mCachedInstance;
            }
        }

        public abstract T createService() throws ServiceManager.ServiceNotFoundException;

        @Override
        public boolean supportsFetchWithoutContext() {
            return false;
        }
    }

    static abstract class CachedServiceFetcher<T>
    implements ServiceFetcher<T> {
        private final int mCacheIndex = sServiceCacheSize++;

        CachedServiceFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public T getService(ContextImpl ctx) {
            cache = ctx.mServiceCache;
            gates = ctx.mServiceInitializationStateArray;
            interrupted = false;
            ret = null;
            while (true) {
                block24: {
                    doInitialize = false;
                    var7_7 = cache;
                    // MONITORENTER : cache
                    service = cache[this.mCacheIndex];
                    if (service == null) break block24;
                    ret = service;
                    // MONITOREXIT : var7_7
                    ** GOTO lbl38
                }
                if (gates[this.mCacheIndex] == 2 || gates[this.mCacheIndex] == 3) {
                    gates[this.mCacheIndex] = 0;
                }
                if (gates[this.mCacheIndex] == 0) {
                    doInitialize = true;
                    gates[this.mCacheIndex] = 1;
                }
                // MONITOREXIT : var7_7
                if (!doInitialize) {
                    var7_7 = cache;
                    // MONITORENTER : cache
                } else {
                    service = null;
                    newState = 3;
                    try {
                        service = this.createService(ctx);
                        newState = 2;
                    }
                    catch (ServiceManager.ServiceNotFoundException e) {
                        SystemServiceRegistry.onServiceNotFound(e);
                    }
                    finally {
                        var9_13 = cache;
                    }
                    ret = service;
lbl38:
                    // 2 sources

                    if (interrupted == false) return (T)ret;
                    Thread.currentThread().interrupt();
                    return (T)ret;
                }
                while (gates[this.mCacheIndex] < 2) {
                    try {
                        interrupted |= Thread.interrupted();
                        cache.wait();
                    }
                    catch (InterruptedException e) {
                        Slog.w("SystemServiceRegistry", "getService() interrupted");
                        interrupted = true;
                    }
                }
                // MONITOREXIT : var7_7
            }
        }

        public abstract T createService(ContextImpl var1) throws ServiceManager.ServiceNotFoundException;

        @Override
        public boolean supportsFetchWithoutContext() {
            return false;
        }
    }
}

