/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IUnsafeIntentStrictModeCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.IUnsafeIntentStrictModeCallback";

    public void onUnsafeIntent(int var1, Intent var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUnsafeIntentStrictModeCallback {
        static final int TRANSACTION_onUnsafeIntent = 1;

        public Stub() {
            this.attachInterface(this, IUnsafeIntentStrictModeCallback.DESCRIPTOR);
        }

        public static IUnsafeIntentStrictModeCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUnsafeIntentStrictModeCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IUnsafeIntentStrictModeCallback) {
                return (IUnsafeIntentStrictModeCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onUnsafeIntent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUnsafeIntentStrictModeCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    Intent _arg1 = data.readTypedObject(Intent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onUnsafeIntent(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IUnsafeIntentStrictModeCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUnsafeIntentStrictModeCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnsafeIntent(int type, Intent intent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IUnsafeIntentStrictModeCallback.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeTypedObject(intent, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUnsafeIntentStrictModeCallback {
        @Override
        public void onUnsafeIntent(int type, Intent intent) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

