/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.Immutable;
import com.android.internal.util.Preconditions;
import com.android.layoutlib.androidx.annotation.FloatRange;
import com.android.layoutlib.androidx.annotation.IntRange;

@SystemApi
@Immutable
public class GameModeConfiguration
implements Parcelable {
    public static final int FPS_OVERRIDE_NONE = 0;
    @NonNull
    public static final Parcelable.Creator<GameModeConfiguration> CREATOR = new Parcelable.Creator<GameModeConfiguration>(){

        @Override
        public GameModeConfiguration createFromParcel(Parcel in) {
            return new GameModeConfiguration(in);
        }

        public GameModeConfiguration[] newArray(int size) {
            return new GameModeConfiguration[size];
        }
    };
    private final float mScalingFactor;
    private final int mFpsOverride;

    GameModeConfiguration(float scalingFactor, int fpsOverride) {
        this.mScalingFactor = scalingFactor;
        this.mFpsOverride = fpsOverride;
    }

    GameModeConfiguration(Parcel in) {
        this.mScalingFactor = in.readFloat();
        this.mFpsOverride = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeFloat(this.mScalingFactor);
        dest.writeInt(this.mFpsOverride);
    }

    public float getScalingFactor() {
        return this.mScalingFactor;
    }

    public int getFpsOverride() {
        return this.mFpsOverride;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GameModeConfiguration)) {
            return false;
        }
        GameModeConfiguration config = (GameModeConfiguration)obj;
        return config.mFpsOverride == this.mFpsOverride && config.mScalingFactor == this.mScalingFactor;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.mFpsOverride;
        result = 31 * result + Float.floatToIntBits(this.mScalingFactor);
        return result;
    }

    @SystemApi
    public static class Builder {
        private float mScalingFactor;
        private int mFpsOverride;

        public Builder() {
        }

        public Builder(@NonNull GameModeConfiguration configuration) {
            this.mFpsOverride = configuration.mFpsOverride;
            this.mScalingFactor = configuration.mScalingFactor;
        }

        @NonNull
        public Builder setScalingFactor(@FloatRange(from=0.1, to=1.0) float scalingFactor) {
            Preconditions.checkArgument((double)scalingFactor >= 0.1 && (double)scalingFactor <= 1.0, "Scaling factor should fall between 0.1 and 1.0 (inclusive)");
            this.mScalingFactor = scalingFactor;
            return this;
        }

        @NonNull
        public Builder setFpsOverride(@IntRange(from=0L) int fpsOverride) {
            Preconditions.checkArgument(fpsOverride >= 0, "FPS override should be non-negative");
            this.mFpsOverride = fpsOverride;
            return this;
        }

        @NonNull
        public GameModeConfiguration build() {
            return new GameModeConfiguration(this.mScalingFactor, this.mFpsOverride);
        }
    }
}

