/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Bundle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@SuppressLint(value={"UserHandleName"})
@RavenwoodKeepWholeClass
public class ComponentOptions {
    public static final String KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED = "android.pendingIntent.backgroundActivityAllowed";
    private Integer mPendingIntentBalAllowed = 0;

    ComponentOptions() {
    }

    ComponentOptions(Bundle opts) {
        opts.setDefusable(true);
        this.mPendingIntentBalAllowed = opts.getInt(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED, 0);
    }

    @Deprecated
    public void setPendingIntentBackgroundActivityLaunchAllowed(boolean allowed) {
        this.mPendingIntentBalAllowed = allowed ? 1 : 2;
    }

    @Deprecated
    public boolean isPendingIntentBackgroundActivityLaunchAllowed() {
        return this.mPendingIntentBalAllowed != 2;
    }

    @NonNull
    public ComponentOptions setPendingIntentBackgroundActivityStartMode(int state) {
        switch (state) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mPendingIntentBalAllowed = state;
                break;
            }
            default: {
                this.mPendingIntentBalAllowed = 1;
            }
        }
        return this;
    }

    public int getPendingIntentBackgroundActivityStartMode() {
        return this.mPendingIntentBalAllowed;
    }

    public Bundle toBundle() {
        Bundle b = new Bundle();
        if (this.mPendingIntentBalAllowed != 0) {
            b.putInt(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED, this.mPendingIntentBalAllowed);
        }
        return b;
    }

    @Nullable
    public static ComponentOptions fromBundle(@Nullable Bundle options) {
        return options != null ? new ComponentOptions(options) : null;
    }
}

