/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.app.IApplicationThread;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IpcDataCache;
import android.os.ParcelFileDescriptor;
import android.util.ArrayMap;
import android.util.IndentingPrintWriter;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.app.Flags;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public class BroadcastStickyCache {
    @VisibleForTesting
    public static final String[] STICKY_BROADCAST_ACTIONS = new String[]{"android.media.action.HDMI_AUDIO_PLUG", "android.intent.action.HEADSET_PLUG", "android.media.SCO_AUDIO_STATE_CHANGED", "android.media.ACTION_SCO_AUDIO_STATE_UPDATED", "android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION", "android.media.RINGER_MODE_CHANGED", "android.net.conn.CONNECTIVITY_CHANGE", "android.intent.action.BATTERY_CHANGED", "android.intent.action.DEVICE_STORAGE_FULL", "android.intent.action.DEVICE_STORAGE_LOW", "android.intent.action.SIM_STATE_CHANGED", "android.net.nsd.STATE_CHANGED", "android.telephony.action.SERVICE_PROVIDERS_UPDATED", "android.net.conn.TETHER_STATE_CHANGED", "android.os.UpdateLock.UPDATE_LOCK_CHANGED", "android.hardware.usb.action.USB_STATE", "android.net.wifi.action.WIFI_SCAN_AVAILABILITY_CHANGED", "android.net.wifi.STATE_CHANGE", "android.net.wifi.supplicant.STATE_CHANGE", "android.net.wifi.WIFI_STATE_CHANGED", "android.net.wifi.p2p.STATE_CHANGED", "android.intent.action.HDMI_PLUGGED", "android.net.conn.INET_CONDITION_ACTION"};
    @VisibleForTesting
    public static final ArrayMap<String, String> sActionApiNameMap = new ArrayMap();
    @GuardedBy(value={"BroadcastStickyCache.class"})
    private static final ArrayMap<String, IpcDataCache.Config> sActionConfigMap = new ArrayMap();
    @GuardedBy(value={"BroadcastStickyCache.class"})
    private static final ArrayMap<StickyBroadcastFilter, IpcDataCache<Void, Intent>> sFilterCacheMap = new ArrayMap();

    public static boolean useCache(@Nullable IntentFilter filter) {
        return Flags.useStickyBcastCache() && filter != null && filter.safeCountActions() == 1 && ArrayUtils.contains(STICKY_BROADCAST_ACTIONS, filter.getAction(0));
    }

    public static void invalidateCache(@NonNull String action) {
        if (!Flags.useStickyBcastCache() || !ArrayUtils.contains(STICKY_BROADCAST_ACTIONS, action)) {
            return;
        }
        IpcDataCache.invalidateCache("system_server", sActionApiNameMap.get(action));
    }

    public static void invalidateAllCaches() {
        for (int i = sActionApiNameMap.size() - 1; i >= 0; --i) {
            IpcDataCache.invalidateCache("system_server", sActionApiNameMap.valueAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Intent getIntent(@NonNull IApplicationThread applicationThread, @NonNull String mBasePackageName, @Nullable String attributionTag, @NonNull IntentFilter filter, @Nullable String broadcastPermission, int userId, int flags) {
        Class<BroadcastStickyCache> clazz = BroadcastStickyCache.class;
        synchronized (BroadcastStickyCache.class) {
            IpcDataCache<Void, Intent> intentDataCache = BroadcastStickyCache.findIpcDataCache(filter);
            if (intentDataCache == null) {
                String action = filter.getAction(0);
                StickyBroadcastFilter stickyBroadcastFilter = new StickyBroadcastFilter(filter, action);
                IpcDataCache.Config config = BroadcastStickyCache.getConfig(action);
                intentDataCache = new IpcDataCache<Void, Intent>(config, query -> ActivityManager.getService().registerReceiverWithFeature(applicationThread, mBasePackageName, attributionTag, "null", null, filter, broadcastPermission, userId, flags));
                sFilterCacheMap.put(stickyBroadcastFilter, intentDataCache);
            }
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return intentDataCache.query(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearCacheForTest() {
        Class<BroadcastStickyCache> clazz = BroadcastStickyCache.class;
        synchronized (BroadcastStickyCache.class) {
            sFilterCacheMap.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    @GuardedBy(value={"BroadcastStickyCache.class"})
    private static IpcDataCache<Void, Intent> findIpcDataCache(@NonNull IntentFilter filter) {
        for (int i = sFilterCacheMap.size() - 1; i >= 0; --i) {
            StickyBroadcastFilter existingFilter = sFilterCacheMap.keyAt(i);
            if (!filter.getAction(0).equals(existingFilter.action()) || !IntentFilter.filterEquals(existingFilter.filter(), filter)) continue;
            return sFilterCacheMap.valueAt(i);
        }
        return null;
    }

    @NonNull
    @GuardedBy(value={"BroadcastStickyCache.class"})
    private static IpcDataCache.Config getConfig(@NonNull String action) {
        if (!sActionConfigMap.containsKey(action)) {
            sActionConfigMap.put(action, new IpcDataCache.Config(32, "system_server", sActionApiNameMap.get(action)).cacheNulls(true));
        }
        return sActionConfigMap.get(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCacheInfo(@NonNull ParcelFileDescriptor pfd) {
        if (!Flags.useStickyBcastCache()) {
            return;
        }
        FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(pfd.getFileDescriptor()));
        Class<BroadcastStickyCache> clazz = BroadcastStickyCache.class;
        synchronized (BroadcastStickyCache.class) {
            BroadcastStickyCache.dumpCacheLocked(pw);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ((PrintWriter)pw).flush();
            return;
        }
    }

    @GuardedBy(value={"BroadcastStickyCache.class"})
    private static void dumpCacheLocked(@NonNull PrintWriter pw) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ", "  ");
        ipw.println("Cached sticky broadcasts:");
        ipw.increaseIndent();
        int count = sFilterCacheMap.size();
        if (count == 0) {
            ipw.println("<empty>");
        } else {
            for (int i = 0; i < count; ++i) {
                StickyBroadcastFilter stickyBroadcast = sFilterCacheMap.keyAt(i);
                IpcDataCache<Void, Intent> ipcDataCache = sFilterCacheMap.valueAt(i);
                ipw.print("Entry #");
                ipw.print(i);
                ipw.println(":");
                ipw.increaseIndent();
                ipw.print("action", stickyBroadcast.action).println();
                ipw.print("filter", stickyBroadcast.filter.toLongString()).println();
                ipcDataCache.dumpCacheEntries(pw);
                ipw.decreaseIndent();
            }
        }
        ipw.decreaseIndent();
    }

    static {
        sActionApiNameMap.put("android.media.action.HDMI_AUDIO_PLUG", "hdmi_audio_plug");
        sActionApiNameMap.put("android.intent.action.HEADSET_PLUG", "headset_plug");
        sActionApiNameMap.put("android.media.SCO_AUDIO_STATE_CHANGED", "sco_audio_state_changed");
        sActionApiNameMap.put("android.media.ACTION_SCO_AUDIO_STATE_UPDATED", "action_sco_audio_state_updated");
        sActionApiNameMap.put("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION", "internal_ringer_mode_changed_action");
        sActionApiNameMap.put("android.media.RINGER_MODE_CHANGED", "ringer_mode_changed");
        sActionApiNameMap.put("android.net.conn.CONNECTIVITY_CHANGE", "connectivity_change");
        sActionApiNameMap.put("android.intent.action.BATTERY_CHANGED", "battery_changed");
        sActionApiNameMap.put("android.intent.action.DEVICE_STORAGE_FULL", "device_storage_full");
        sActionApiNameMap.put("android.intent.action.DEVICE_STORAGE_LOW", "device_storage_low");
        sActionApiNameMap.put("android.intent.action.SIM_STATE_CHANGED", "sim_state_changed");
        sActionApiNameMap.put("android.net.nsd.STATE_CHANGED", "nsd_state_changed");
        sActionApiNameMap.put("android.telephony.action.SERVICE_PROVIDERS_UPDATED", "service_providers_updated");
        sActionApiNameMap.put("android.net.conn.TETHER_STATE_CHANGED", "tether_state_changed");
        sActionApiNameMap.put("android.os.UpdateLock.UPDATE_LOCK_CHANGED", "update_lock_changed");
        sActionApiNameMap.put("android.hardware.usb.action.USB_STATE", "usb_state");
        sActionApiNameMap.put("android.net.wifi.action.WIFI_SCAN_AVAILABILITY_CHANGED", "wifi_scan_availability_changed");
        sActionApiNameMap.put("android.net.wifi.STATE_CHANGE", "network_state_change");
        sActionApiNameMap.put("android.net.wifi.supplicant.STATE_CHANGE", "supplicant_state_change");
        sActionApiNameMap.put("android.net.wifi.WIFI_STATE_CHANGED", "wifi_state_changed");
        sActionApiNameMap.put("android.net.wifi.p2p.STATE_CHANGED", "wifi_p2p_state_changed");
        sActionApiNameMap.put("android.intent.action.HDMI_PLUGGED", "hdmi_plugged");
        sActionApiNameMap.put("android.net.conn.INET_CONDITION_ACTION", "inet_condition_action");
    }

    @VisibleForTesting
    private static class StickyBroadcastFilter
    extends Record {
        @NonNull
        private final IntentFilter filter;
        @NonNull
        private final String action;

        private StickyBroadcastFilter(@NonNull IntentFilter filter, @NonNull String action) {
            this.filter = filter;
            this.action = action;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StickyBroadcastFilter.class, "filter;action", "filter", "action"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StickyBroadcastFilter.class, "filter;action", "filter", "action"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StickyBroadcastFilter.class, "filter;action", "filter", "action"}, this, o);
        }

        @NonNull
        public IntentFilter filter() {
            return this.filter;
        }

        @NonNull
        public String action() {
            return this.action;
        }
    }
}

