/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import com.android.internal.util.Preconditions;
import java.util.List;
import java.util.Objects;

public class BackgroundStartPrivileges {
    public static final BackgroundStartPrivileges NONE = new BackgroundStartPrivileges(false, false, null);
    public static final BackgroundStartPrivileges ALLOW_BAL = new BackgroundStartPrivileges(true, true, null);
    public static final BackgroundStartPrivileges ALLOW_FGS = new BackgroundStartPrivileges(false, true, null);
    private final boolean mAllowsBackgroundActivityStarts;
    private final boolean mAllowsBackgroundForegroundServiceStarts;
    private final IBinder mOriginatingToken;

    private BackgroundStartPrivileges(boolean allowsBackgroundActivityStarts, boolean allowsBackgroundForegroundServiceStarts, @Nullable IBinder originatingToken) {
        Preconditions.checkArgument(!allowsBackgroundActivityStarts || allowsBackgroundForegroundServiceStarts, "backgroundActivityStarts implies bgFgServiceStarts");
        this.mAllowsBackgroundActivityStarts = allowsBackgroundActivityStarts;
        this.mAllowsBackgroundForegroundServiceStarts = allowsBackgroundForegroundServiceStarts;
        this.mOriginatingToken = originatingToken;
    }

    public static BackgroundStartPrivileges allowBackgroundActivityStarts(@Nullable IBinder originatingToken) {
        if (originatingToken == null) {
            return ALLOW_BAL;
        }
        return new BackgroundStartPrivileges(true, true, originatingToken);
    }

    @NonNull
    public BackgroundStartPrivileges merge(@Nullable BackgroundStartPrivileges other) {
        boolean allowsBackgroundFgsStarts;
        if (other == NONE || other == null) {
            return this;
        }
        if (this == NONE) {
            return other;
        }
        boolean allowsBackgroundActivityStarts = this.allowsBackgroundActivityStarts() || other.allowsBackgroundActivityStarts();
        boolean bl = allowsBackgroundFgsStarts = this.allowsBackgroundFgsStarts() || other.allowsBackgroundFgsStarts();
        if (this.mOriginatingToken == other.mOriginatingToken) {
            if (this.mAllowsBackgroundActivityStarts == allowsBackgroundActivityStarts && this.mAllowsBackgroundForegroundServiceStarts == allowsBackgroundFgsStarts) {
                return this;
            }
            if (other.mAllowsBackgroundActivityStarts == allowsBackgroundActivityStarts && other.mAllowsBackgroundForegroundServiceStarts == allowsBackgroundFgsStarts) {
                return other;
            }
            return new BackgroundStartPrivileges(allowsBackgroundActivityStarts, allowsBackgroundFgsStarts, this.mOriginatingToken);
        }
        if (allowsBackgroundActivityStarts) {
            return ALLOW_BAL;
        }
        if (allowsBackgroundFgsStarts) {
            return ALLOW_FGS;
        }
        return NONE;
    }

    @NonNull
    public static BackgroundStartPrivileges merge(@Nullable List<BackgroundStartPrivileges> list) {
        if (list == null || list.isEmpty()) {
            return NONE;
        }
        BackgroundStartPrivileges current = list.get(0);
        int i = list.size();
        while (i-- > 1) {
            current = current.merge(list.get(i));
        }
        return current;
    }

    public boolean allowsBackgroundActivityStarts() {
        return this.mAllowsBackgroundActivityStarts;
    }

    public boolean allowsBackgroundFgsStarts() {
        return this.mAllowsBackgroundForegroundServiceStarts;
    }

    public boolean allowsAny() {
        return this.mAllowsBackgroundActivityStarts || this.mAllowsBackgroundForegroundServiceStarts;
    }

    public boolean allowsNothing() {
        return !this.allowsAny();
    }

    @Nullable
    public IBinder getOriginatingToken() {
        return this.mOriginatingToken;
    }

    public String toString() {
        if (this == ALLOW_BAL) {
            return "BSP.ALLOW_BAL";
        }
        if (this == ALLOW_FGS) {
            return "BSP.ALLOW_FGS";
        }
        if (this == NONE) {
            return "BSP.NONE";
        }
        return "BackgroundStartPrivileges[allowsBackgroundActivityStarts=" + this.mAllowsBackgroundActivityStarts + ", allowsBackgroundForegroundServiceStarts=" + this.mAllowsBackgroundForegroundServiceStarts + ", originatingToken=" + this.mOriginatingToken + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundStartPrivileges that = (BackgroundStartPrivileges)o;
        return this.mAllowsBackgroundActivityStarts == that.mAllowsBackgroundActivityStarts && this.mAllowsBackgroundForegroundServiceStarts == that.mAllowsBackgroundForegroundServiceStarts && Objects.equals(this.mOriginatingToken, that.mOriginatingToken);
    }

    public int hashCode() {
        return Objects.hash(this.mAllowsBackgroundActivityStarts, this.mAllowsBackgroundForegroundServiceStarts, this.mOriginatingToken);
    }
}

