/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.CurrentTimeMillisLong;
import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.AppOpsManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.Immutable;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@Immutable
public class AsyncNotedAppOp
implements Parcelable {
    private final int mOpCode;
    private final int mNotingUid;
    @Nullable
    private final String mAttributionTag;
    @NonNull
    private final String mMessage;
    private final long mTime;
    @NonNull
    public static final Parcelable.Creator<AsyncNotedAppOp> CREATOR = new Parcelable.Creator<AsyncNotedAppOp>(){

        public AsyncNotedAppOp[] newArray(int size) {
            return new AsyncNotedAppOp[size];
        }

        @Override
        public AsyncNotedAppOp createFromParcel(@NonNull Parcel in) {
            return new AsyncNotedAppOp(in);
        }
    };

    @NonNull
    public String getOp() {
        return AppOpsManager.opToPublicName(this.mOpCode);
    }

    private void onConstructed() {
        Preconditions.checkArgumentInRange(this.mOpCode, 0, 166, "opCode");
    }

    private String opCodeToString() {
        return this.getOp();
    }

    public AsyncNotedAppOp(int opCode, int notingUid, @Nullable String attributionTag, @NonNull String message, long time) {
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L);
        this.mNotingUid = notingUid;
        AnnotationValidations.validate(IntRange.class, null, this.mNotingUid, "from", 0L);
        this.mAttributionTag = attributionTag;
        this.mMessage = message;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMessage);
        this.mTime = time;
        AnnotationValidations.validate(CurrentTimeMillisLong.class, null, this.mTime);
        this.onConstructed();
    }

    public int getNotingUid() {
        return this.mNotingUid;
    }

    @Nullable
    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    @NonNull
    public String getMessage() {
        return this.mMessage;
    }

    public long getTime() {
        return this.mTime;
    }

    public String toString() {
        return "AsyncNotedAppOp { opCode = " + this.opCodeToString() + ", notingUid = " + this.mNotingUid + ", attributionTag = " + this.mAttributionTag + ", message = " + this.mMessage + ", time = " + this.mTime + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncNotedAppOp that = (AsyncNotedAppOp)o;
        return this.mOpCode == that.mOpCode && this.mNotingUid == that.mNotingUid && Objects.equals(this.mAttributionTag, that.mAttributionTag) && Objects.equals(this.mMessage, that.mMessage) && this.mTime == that.mTime;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mOpCode;
        _hash = 31 * _hash + this.mNotingUid;
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionTag);
        _hash = 31 * _hash + Objects.hashCode(this.mMessage);
        _hash = 31 * _hash + Long.hashCode(this.mTime);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mAttributionTag != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mOpCode);
        dest.writeInt(this.mNotingUid);
        if (this.mAttributionTag != null) {
            dest.writeString(this.mAttributionTag);
        }
        dest.writeString(this.mMessage);
        dest.writeLong(this.mTime);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AsyncNotedAppOp(@NonNull Parcel in) {
        byte flg = in.readByte();
        int opCode = in.readInt();
        int notingUid = in.readInt();
        String attributionTag = (flg & 4) == 0 ? null : in.readString();
        String message = in.readString();
        long time = in.readLong();
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L);
        this.mNotingUid = notingUid;
        AnnotationValidations.validate(IntRange.class, null, this.mNotingUid, "from", 0L);
        this.mAttributionTag = attributionTag;
        this.mMessage = message;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMessage);
        this.mTime = time;
        AnnotationValidations.validate(CurrentTimeMillisLong.class, null, this.mTime);
        this.onConstructed();
    }

    @Deprecated
    private void __metadata() {
    }
}

