/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.compat.Compatibility;
import android.os.Process;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.compat.ChangeReporter;
import java.util.Arrays;

@RavenwoodKeepWholeClass
public class AppCompatCallbacks
implements Compatibility.BehaviorChangeDelegate {
    private final long[] mDisabledChanges;
    private final long[] mLoggableChanges;
    private final ChangeReporter mChangeReporter;

    public static void install(long[] disabledChanges, long[] loggableChanges) {
        Compatibility.setBehaviorChangeDelegate(new AppCompatCallbacks(disabledChanges, loggableChanges));
    }

    private AppCompatCallbacks(long[] disabledChanges, long[] loggableChanges) {
        this.mDisabledChanges = Arrays.copyOf(disabledChanges, disabledChanges.length);
        this.mLoggableChanges = Arrays.copyOf(loggableChanges, loggableChanges.length);
        Arrays.sort(this.mDisabledChanges);
        Arrays.sort(this.mLoggableChanges);
        this.mChangeReporter = new ChangeReporter(1);
    }

    private boolean changeIdInChangeList(long[] list, long changeId) {
        return Arrays.binarySearch(list, changeId) >= 0;
    }

    @Override
    public void onChangeReported(long changeId) {
        boolean isLoggable = this.changeIdInChangeList(this.mLoggableChanges, changeId);
        this.reportChange(changeId, 3, isLoggable);
    }

    @Override
    public boolean isChangeEnabled(long changeId) {
        boolean isEnabled = !this.changeIdInChangeList(this.mDisabledChanges, changeId);
        boolean isLoggable = this.changeIdInChangeList(this.mLoggableChanges, changeId);
        if (isEnabled) {
            this.reportChange(changeId, 1, isLoggable);
            return true;
        }
        this.reportChange(changeId, 2, isLoggable);
        return false;
    }

    private void reportChange(long changeId, int state, boolean isLoggable) {
        int uid = Process.myUid();
        this.mChangeReporter.reportChange(uid, changeId, state, false, isLoggable);
    }
}

