/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.topics;

import android.adservices.topics.EncryptedTopic;
import android.adservices.topics.Topic;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GetTopicsResponse {
    private final List<Topic> mTopics;
    private final List<EncryptedTopic> mEncryptedTopics;

    private GetTopicsResponse(List<Topic> topics, List<EncryptedTopic> encryptedTopics) {
        this.mTopics = topics;
        this.mEncryptedTopics = encryptedTopics;
    }

    @NonNull
    public List<Topic> getTopics() {
        return this.mTopics;
    }

    @NonNull
    @FlaggedApi(value="com.android.adservices.flags.topics_encryption_enabled")
    public List<EncryptedTopic> getEncryptedTopics() {
        return this.mEncryptedTopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTopicsResponse)) {
            return false;
        }
        GetTopicsResponse that = (GetTopicsResponse)o;
        return this.mTopics.equals(that.mTopics) && this.mEncryptedTopics.equals(that.mEncryptedTopics);
    }

    public int hashCode() {
        return Objects.hash(this.mTopics, this.mEncryptedTopics);
    }

    public static class Builder {
        private List<Topic> mTopics = new ArrayList<Topic>();
        private List<EncryptedTopic> mEncryptedTopics = new ArrayList<EncryptedTopic>();

        @Deprecated
        public Builder(@NonNull List<Topic> topics) {
            this.mTopics = Objects.requireNonNull(topics);
        }

        @FlaggedApi(value="com.android.adservices.flags.topics_encryption_enabled")
        public Builder(@NonNull List<Topic> topics, @NonNull List<EncryptedTopic> encryptedTopics) {
            this.mTopics = Objects.requireNonNull(topics);
            this.mEncryptedTopics = Objects.requireNonNull(encryptedTopics);
        }

        @NonNull
        public GetTopicsResponse build() {
            if (this.mTopics == null || this.mEncryptedTopics == null) {
                throw new IllegalArgumentException("Topics is null");
            }
            return new GetTopicsResponse(this.mTopics, this.mEncryptedTopics);
        }
    }
}

