/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.signals;

import android.annotation.NonNull;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class UpdateSignalsInput
implements Parcelable {
    @NonNull
    private final Uri mUpdateUri;
    @NonNull
    private final String mCallerPackageName;
    @NonNull
    public static final Parcelable.Creator<UpdateSignalsInput> CREATOR = new Parcelable.Creator<UpdateSignalsInput>(){

        @Override
        @NonNull
        public UpdateSignalsInput createFromParcel(@NonNull Parcel in) {
            return new UpdateSignalsInput(in);
        }

        @NonNull
        public UpdateSignalsInput[] newArray(int size) {
            return new UpdateSignalsInput[size];
        }
    };

    private UpdateSignalsInput(@NonNull Uri updateUri, @NonNull String callerPackageName) {
        Objects.requireNonNull(updateUri);
        Objects.requireNonNull(callerPackageName);
        this.mUpdateUri = updateUri;
        this.mCallerPackageName = callerPackageName;
    }

    private UpdateSignalsInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        Uri updateUri = Uri.CREATOR.createFromParcel(in);
        Objects.requireNonNull(updateUri);
        this.mUpdateUri = updateUri;
        String callerPackageName = in.readString();
        Objects.requireNonNull(callerPackageName);
        this.mCallerPackageName = callerPackageName;
    }

    @NonNull
    public Uri getUpdateUri() {
        return this.mUpdateUri;
    }

    @NonNull
    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mUpdateUri.writeToParcel(dest, flags);
        dest.writeString(this.mCallerPackageName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof UpdateSignalsInput)) {
            return false;
        }
        UpdateSignalsInput that = (UpdateSignalsInput)o;
        return ((Object)this.mUpdateUri).equals(that.mUpdateUri) && this.mCallerPackageName.equals(that.mCallerPackageName);
    }

    public int hashCode() {
        return Objects.hash(this.mUpdateUri, this.mCallerPackageName);
    }

    public String toString() {
        return "UpdateSignalsInput{mUpdateUri=" + this.mUpdateUri + ", mCallerPackageName='" + this.mCallerPackageName + '\'' + '}';
    }

    public static class Builder {
        @NonNull
        private Uri mUpdateUri;
        @NonNull
        private String mCallerPackageName;

        public Builder(@NonNull Uri updateUri, @NonNull String callerPackageName) {
            Objects.requireNonNull(updateUri);
            Objects.requireNonNull(callerPackageName);
            this.mUpdateUri = updateUri;
            this.mCallerPackageName = callerPackageName;
        }

        @NonNull
        public Builder setUpdateUri(@NonNull Uri updateUri) {
            Objects.requireNonNull(updateUri);
            this.mUpdateUri = updateUri;
            return this;
        }

        @NonNull
        public Builder setCallerPackageName(@NonNull String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        @NonNull
        public UpdateSignalsInput build() {
            return new UpdateSignalsInput(this.mUpdateUri, this.mCallerPackageName);
        }
    }
}

