/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.ondevicepersonalization;

import android.adservices.ondevicepersonalization.CalleeMetadata;
import android.adservices.ondevicepersonalization.CallerMetadata;
import android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest;
import android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceResponse;
import android.adservices.ondevicepersonalization.ExecuteOptionsParcel;
import android.adservices.ondevicepersonalization.IsolatedServiceException;
import android.adservices.ondevicepersonalization.OnDevicePersonalizationException;
import android.adservices.ondevicepersonalization.SurfacePackageToken;
import android.adservices.ondevicepersonalization.aidl.IExecuteCallback;
import android.adservices.ondevicepersonalization.aidl.IIsFeatureEnabledCallback;
import android.adservices.ondevicepersonalization.aidl.IOnDevicePersonalizationManagingService;
import android.adservices.ondevicepersonalization.aidl.IRequestSurfacePackageCallback;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.OutcomeReceiver;
import android.os.PersistableBundle;
import android.os.SystemClock;
import android.view.SurfaceControlViewHost;
import com.android.federatedcompute.internal.util.AbstractServiceBinder;
import com.android.internal.annotations.VisibleForTesting;
import com.android.ondevicepersonalization.internal.util.ByteArrayParceledSlice;
import com.android.ondevicepersonalization.internal.util.ExceptionInfo;
import com.android.ondevicepersonalization.internal.util.LoggerFactory;
import com.android.ondevicepersonalization.internal.util.PersistableBundleUtils;
import com.android.ondevicepersonalization.internal.util.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class OnDevicePersonalizationManager {
    public static final String ON_DEVICE_PERSONALIZATION_SERVICE = "on_device_personalization_service";
    private static final String INTENT_FILTER_ACTION = "android.OnDevicePersonalizationService";
    private static final String ODP_MANAGING_SERVICE_PACKAGE_SUFFIX = "com.android.ondevicepersonalization.services";
    private static final String ALT_ODP_MANAGING_SERVICE_PACKAGE_SUFFIX = "com.google.android.ondevicepersonalization.services";
    private static final String ODP_INTERNAL_ERROR_MESSAGE = "Internal error in the OnDevicePersonalizationService.";
    private static final String ISOLATED_SERVICE_ERROR_MESSAGE = "Error in the IsolatedService.";
    private static final String ODP_DISABLED_ERROR_MESSAGE = "Personalization disabled by device configuration.";
    private static final String ODP_MANIFEST_ERROR_MESSAGE = "OnDevicePersonalization manifest invalid.";
    private static final String ODP_SERVICE_LOADING_ERROR_MESSAGE = "Failed to load the isolated service.";
    private static final String ODP_SERVICE_TIMEOUT_ERROR_MESSAGE = "The isolated service timed out without returning.";
    private static final String TAG = OnDevicePersonalizationManager.class.getSimpleName();
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getLogger();
    @FlaggedApi(value="com.android.adservices.ondevicepersonalization.flags.is_feature_enabled_api_enabled")
    public static final int FEATURE_ENABLED = 0;
    @FlaggedApi(value="com.android.adservices.ondevicepersonalization.flags.is_feature_enabled_api_enabled")
    public static final int FEATURE_DISABLED = 1;
    @FlaggedApi(value="com.android.adservices.ondevicepersonalization.flags.is_feature_enabled_api_enabled")
    public static final int FEATURE_UNSUPPORTED = 2;
    private final AbstractServiceBinder<IOnDevicePersonalizationManagingService> mServiceBinder;
    private final Context mContext;

    public OnDevicePersonalizationManager(Context context) {
        this(context, AbstractServiceBinder.getServiceBinderByIntent(context, INTENT_FILTER_ACTION, List.of(ODP_MANAGING_SERVICE_PACKAGE_SUFFIX, ALT_ODP_MANAGING_SERVICE_PACKAGE_SUFFIX), SdkLevel.isAtLeastU() ? 512 : 0, IOnDevicePersonalizationManagingService.Stub::asInterface));
    }

    @VisibleForTesting
    public OnDevicePersonalizationManager(Context context, AbstractServiceBinder<IOnDevicePersonalizationManagingService> serviceBinder) {
        this.mContext = context;
        this.mServiceBinder = serviceBinder;
    }

    public void execute(final @NonNull ComponentName service, @NonNull PersistableBundle params, final @NonNull Executor executor, final @NonNull OutcomeReceiver<ExecuteResult, Exception> receiver) {
        Objects.requireNonNull(service);
        Objects.requireNonNull(params);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        Objects.requireNonNull(service.getPackageName());
        Objects.requireNonNull(service.getClassName());
        if (service.getPackageName().isEmpty()) {
            throw new IllegalArgumentException("missing service package name");
        }
        if (service.getClassName().isEmpty()) {
            throw new IllegalArgumentException("missing service class name");
        }
        final long startTimeMillis = SystemClock.elapsedRealtime();
        try {
            final IOnDevicePersonalizationManagingService odpService = this.mServiceBinder.getService(executor);
            try {
                IExecuteCallback.Stub callbackWrapper = new IExecuteCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess(Bundle callbackResult, CalleeMetadata calleeMetadata) {
                        long token = Binder.clearCallingIdentity();
                        try {
                            executor.execute(() -> {
                                try {
                                    String tokenString;
                                    SurfacePackageToken surfacePackageToken = null;
                                    if (callbackResult != null && (tokenString = callbackResult.getString("android.ondevicepersonalization.extra.surface_package_token_string")) != null && !tokenString.isBlank()) {
                                        surfacePackageToken = new SurfacePackageToken(tokenString);
                                    }
                                    receiver.onResult(new ExecuteResult(surfacePackageToken, null));
                                }
                                catch (Exception e) {
                                    receiver.onError(e);
                                }
                            });
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                            OnDevicePersonalizationManager.logApiCallStats(odpService, service.getPackageName(), 1, SystemClock.elapsedRealtime() - startTimeMillis, calleeMetadata.getServiceEntryTimeMillis() - startTimeMillis, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), 0);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(int errorCode, int isolatedServiceErrorCode, byte[] serializedExceptionInfo, CalleeMetadata calleeMetadata) {
                        long token = Binder.clearCallingIdentity();
                        try {
                            executor.execute(() -> receiver.onError(OnDevicePersonalizationManager.createException(errorCode, isolatedServiceErrorCode, serializedExceptionInfo, OnDevicePersonalizationManager.this.mContext)));
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                            OnDevicePersonalizationManager.logApiCallStats(odpService, service.getPackageName(), 1, SystemClock.elapsedRealtime() - startTimeMillis, calleeMetadata.getServiceEntryTimeMillis() - startTimeMillis, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), errorCode);
                        }
                    }
                };
                Bundle wrappedParams = new Bundle();
                wrappedParams.putParcelable("android.ondevicepersonalization.extra.app_params_serialized", new ByteArrayParceledSlice(PersistableBundleUtils.toByteArray(params)));
                String appPackageName = this.mContext.getPackageManager().getNameForUid(Binder.getCallingUid());
                odpService.execute(appPackageName, service, wrappedParams, new CallerMetadata.Builder().setStartTimeMillis(startTimeMillis).build(), ExecuteOptionsParcel.DEFAULT, callbackWrapper);
            }
            catch (Exception e) {
                OnDevicePersonalizationManager.logApiCallStats(odpService, service.getPackageName(), 1, SystemClock.elapsedRealtime() - startTimeMillis, 0L, 0L, 100);
                receiver.onError(e);
            }
        }
        catch (Exception e) {
            receiver.onError(e);
        }
    }

    @FlaggedApi(value="com.android.adservices.ondevicepersonalization.flags.execute_in_isolated_service_api_enabled")
    public void executeInIsolatedService(final @NonNull ExecuteInIsolatedServiceRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<ExecuteInIsolatedServiceResponse, Exception> receiver) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        OnDevicePersonalizationManager.validateRequest(request);
        final long startTimeMillis = SystemClock.elapsedRealtime();
        try {
            final IOnDevicePersonalizationManagingService odpService = this.mServiceBinder.getService(executor);
            try {
                IExecuteCallback.Stub callbackWrapper = new IExecuteCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess(Bundle callbackResult, CalleeMetadata calleeMetadata) {
                        long token = Binder.clearCallingIdentity();
                        try {
                            executor.execute(() -> {
                                try {
                                    String tokenString;
                                    SurfacePackageToken surfacePackageToken = null;
                                    if (callbackResult != null && (tokenString = callbackResult.getString("android.ondevicepersonalization.extra.surface_package_token_string")) != null && !tokenString.isBlank()) {
                                        surfacePackageToken = new SurfacePackageToken(tokenString);
                                    }
                                    int intValue = -1;
                                    if (request.getOutputSpec().getOutputType() == 1) {
                                        intValue = callbackResult.getInt("android.ondevicepersonalization.extra.output_best_value");
                                    }
                                    receiver.onResult(new ExecuteInIsolatedServiceResponse(surfacePackageToken, intValue));
                                }
                                catch (Exception e) {
                                    receiver.onError(e);
                                }
                            });
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                            OnDevicePersonalizationManager.logApiCallStats(odpService, request.getService().getPackageName(), 1, SystemClock.elapsedRealtime() - startTimeMillis, calleeMetadata.getServiceEntryTimeMillis() - startTimeMillis, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), 0);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(int errorCode, int isolatedServiceErrorCode, byte[] serializedExceptionInfo, CalleeMetadata calleeMetadata) {
                        long token = Binder.clearCallingIdentity();
                        try {
                            executor.execute(() -> receiver.onError(OnDevicePersonalizationManager.createException(errorCode, isolatedServiceErrorCode, serializedExceptionInfo, OnDevicePersonalizationManager.this.mContext, false)));
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                            OnDevicePersonalizationManager.logApiCallStats(odpService, request.getService().getPackageName(), 1, SystemClock.elapsedRealtime() - startTimeMillis, calleeMetadata.getServiceEntryTimeMillis() - startTimeMillis, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), errorCode);
                        }
                    }
                };
                Bundle wrappedParams = new Bundle();
                wrappedParams.putParcelable("android.ondevicepersonalization.extra.app_params_serialized", new ByteArrayParceledSlice(PersistableBundleUtils.toByteArray(request.getAppParams())));
                String appPackageName = this.mContext.getPackageManager().getNameForUid(Binder.getCallingUid());
                odpService.execute(appPackageName, request.getService(), wrappedParams, new CallerMetadata.Builder().setStartTimeMillis(startTimeMillis).build(), request.getOutputSpec() == null ? ExecuteOptionsParcel.DEFAULT : new ExecuteOptionsParcel(request.getOutputSpec()), callbackWrapper);
            }
            catch (Exception e) {
                OnDevicePersonalizationManager.logApiCallStats(odpService, request.getService().getPackageName(), 1, SystemClock.elapsedRealtime() - startTimeMillis, 0L, 0L, 100);
                receiver.onError(e);
            }
        }
        catch (Exception e) {
            receiver.onError(e);
        }
    }

    public void requestSurfacePackage(@NonNull SurfacePackageToken surfacePackageToken, @NonNull IBinder surfaceViewHostToken, int displayId, int width, int height, final @NonNull Executor executor, final @NonNull OutcomeReceiver<SurfaceControlViewHost.SurfacePackage, Exception> receiver) {
        Objects.requireNonNull(surfacePackageToken);
        Objects.requireNonNull(surfaceViewHostToken);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        if (width <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        if (displayId < 0) {
            throw new IllegalArgumentException("displayId must be >= 0");
        }
        final long startTimeMillis = SystemClock.elapsedRealtime();
        try {
            final IOnDevicePersonalizationManagingService service = Objects.requireNonNull(this.mServiceBinder.getService(executor));
            long serviceInvokedTimeMillis = SystemClock.elapsedRealtime();
            try {
                IRequestSurfacePackageCallback.Stub callbackWrapper = new IRequestSurfacePackageCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess(SurfaceControlViewHost.SurfacePackage surfacePackage, CalleeMetadata calleeMetadata) {
                        long token = Binder.clearCallingIdentity();
                        try {
                            executor.execute(() -> receiver.onResult(surfacePackage));
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                            OnDevicePersonalizationManager.logApiCallStats(service, "", 2, SystemClock.elapsedRealtime() - startTimeMillis, 0L, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), 0);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(int errorCode, int isolatedServiceErrorCode, byte[] serializedExceptionInfo, CalleeMetadata calleeMetadata) {
                        long token = Binder.clearCallingIdentity();
                        try {
                            executor.execute(() -> receiver.onError(OnDevicePersonalizationManager.createException(errorCode, isolatedServiceErrorCode, serializedExceptionInfo, OnDevicePersonalizationManager.this.mContext)));
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                            OnDevicePersonalizationManager.logApiCallStats(service, "", 2, SystemClock.elapsedRealtime() - startTimeMillis, 0L, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), errorCode);
                        }
                    }
                };
                service.requestSurfacePackage(surfacePackageToken.getTokenString(), surfaceViewHostToken, displayId, width, height, new CallerMetadata.Builder().setStartTimeMillis(startTimeMillis).build(), callbackWrapper);
                OnDevicePersonalizationManager.logApiCallStats(service, "", 2, SystemClock.elapsedRealtime() - startTimeMillis, SystemClock.elapsedRealtime() - serviceInvokedTimeMillis, 0L, 0);
            }
            catch (Exception e) {
                OnDevicePersonalizationManager.logApiCallStats(service, "", 2, SystemClock.elapsedRealtime() - startTimeMillis, 0L, 0L, 100);
                receiver.onError(e);
            }
        }
        catch (Exception e) {
            receiver.onError(e);
        }
    }

    @FlaggedApi(value="com.android.adservices.ondevicepersonalization.flags.is_feature_enabled_api_enabled")
    public void queryFeatureAvailability(@NonNull String featureName, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Integer, Exception> receiver) {
        Objects.requireNonNull(featureName);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        final long startTimeMillis = SystemClock.elapsedRealtime();
        try {
            final IOnDevicePersonalizationManagingService service = Objects.requireNonNull(this.mServiceBinder.getService(executor));
            try {
                IIsFeatureEnabledCallback.Stub callbackWrapper = new IIsFeatureEnabledCallback.Stub(this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResult(int result, CalleeMetadata calleeMetadata) {
                        long token = Binder.clearCallingIdentity();
                        try {
                            executor.execute(() -> receiver.onResult(result));
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                            OnDevicePersonalizationManager.logApiCallStats(service, "", 24, SystemClock.elapsedRealtime() - startTimeMillis, calleeMetadata.getServiceEntryTimeMillis() - startTimeMillis, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), 0);
                        }
                    }
                };
                service.isFeatureEnabled(featureName, new CallerMetadata.Builder().setStartTimeMillis(startTimeMillis).build(), callbackWrapper);
            }
            catch (Exception e) {
                OnDevicePersonalizationManager.logApiCallStats(service, "", 24, SystemClock.elapsedRealtime() - startTimeMillis, 0L, 0L, 100);
                receiver.onError(e);
            }
        }
        catch (Exception e) {
            receiver.onError(e);
        }
    }

    private static void validateRequest(ExecuteInIsolatedServiceRequest request) {
        Objects.requireNonNull(request.getService());
        ComponentName service = request.getService();
        Objects.requireNonNull(service.getPackageName());
        Objects.requireNonNull(service.getClassName());
        if (service.getPackageName().isEmpty()) {
            throw new IllegalArgumentException("missing service package name");
        }
        if (service.getClassName().isEmpty()) {
            throw new IllegalArgumentException("missing service class name");
        }
    }

    private static String convertMessage(int errorCode) {
        switch (errorCode) {
            case 100: {
                return ODP_INTERNAL_ERROR_MESSAGE;
            }
            case 103: {
                return ISOLATED_SERVICE_ERROR_MESSAGE;
            }
            case 104: {
                return ODP_DISABLED_ERROR_MESSAGE;
            }
            case 106: 
            case 107: {
                return ODP_MANIFEST_ERROR_MESSAGE;
            }
            case 108: {
                return ODP_SERVICE_LOADING_ERROR_MESSAGE;
            }
            case 109: {
                return ODP_SERVICE_TIMEOUT_ERROR_MESSAGE;
            }
        }
        sLogger.w(TAG + "Unexpected error code while creating exception: " + errorCode);
        return "";
    }

    private static int translateErrorCode(int errorCode, Context context) {
        if (errorCode < 106) {
            return errorCode;
        }
        sLogger.d(TAG, "Translating to legacy error codes for package " + context.getPackageName());
        int translatedCode = 100;
        switch (errorCode) {
            case 106: {
                translatedCode = 101;
                break;
            }
            case 107: {
                translatedCode = 102;
                break;
            }
            case 108: {
                translatedCode = 103;
                break;
            }
            case 109: {
                translatedCode = 103;
            }
        }
        return translatedCode;
    }

    private static Exception createException(int errorCode, int isolatedServiceErrorCode, byte[] serializedExceptionInfo, Context context) {
        return OnDevicePersonalizationManager.createException(errorCode, isolatedServiceErrorCode, serializedExceptionInfo, context, true);
    }

    private static Exception createException(int errorCode, int isolatedServiceErrorCode, byte[] serializedExceptionInfo, Context context, boolean translateToLegacyErrorCode) {
        if (translateToLegacyErrorCode) {
            errorCode = OnDevicePersonalizationManager.translateErrorCode(errorCode, context);
        }
        Exception cause = ExceptionInfo.fromByteArray(serializedExceptionInfo);
        switch (errorCode) {
            case 101: {
                PackageManager.NameNotFoundException e = new PackageManager.NameNotFoundException();
                try {
                    if (cause != null) {
                        e.initCause(cause);
                    }
                }
                catch (Exception e2) {
                    sLogger.i(TAG + ": could not update cause", e2);
                }
                return e;
            }
            case 102: {
                return new ClassNotFoundException("", cause);
            }
            case 103: {
                return isolatedServiceErrorCode > 0 && isolatedServiceErrorCode < 128 ? new OnDevicePersonalizationException(1, (Throwable)new IsolatedServiceException(isolatedServiceErrorCode)) : new OnDevicePersonalizationException(1, OnDevicePersonalizationManager.convertMessage(errorCode), cause);
            }
            case 104: {
                return new OnDevicePersonalizationException(2, OnDevicePersonalizationManager.convertMessage(errorCode), cause);
            }
            case 106: 
            case 107: {
                return new OnDevicePersonalizationException(4, OnDevicePersonalizationManager.convertMessage(errorCode), cause);
            }
            case 108: {
                return new OnDevicePersonalizationException(3, OnDevicePersonalizationManager.convertMessage(errorCode), cause);
            }
            case 109: {
                return new OnDevicePersonalizationException(5, OnDevicePersonalizationManager.convertMessage(errorCode), cause);
            }
        }
        return new IllegalStateException(OnDevicePersonalizationManager.convertMessage(errorCode), cause);
    }

    private static void logApiCallStats(IOnDevicePersonalizationManagingService service, String sdkPackageName, int apiName, long latencyMillis, long rpcCallLatencyMillis, long rpcReturnLatencyMillis, int responseCode) {
        try {
            if (service != null) {
                service.logApiCallStats(sdkPackageName, apiName, latencyMillis, rpcCallLatencyMillis, rpcReturnLatencyMillis, responseCode);
            }
        }
        catch (Exception e) {
            sLogger.e(e, TAG + ": Error logging API call stats");
        }
    }

    public static class ExecuteResult {
        @Nullable
        private final SurfacePackageToken mSurfacePackageToken;
        @Nullable
        private final byte[] mOutputData;

        ExecuteResult(@Nullable SurfacePackageToken surfacePackageToken, @Nullable byte[] outputData) {
            this.mSurfacePackageToken = surfacePackageToken;
            this.mOutputData = outputData;
        }

        @Nullable
        public SurfacePackageToken getSurfacePackageToken() {
            return this.mSurfacePackageToken;
        }

        @Nullable
        public byte[] getOutputData() {
            return this.mOutputData;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureStatus {
    }
}

