/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.measurement.WebSourceParams;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.view.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebSourceRegistrationRequest
implements Parcelable {
    private static final String ANDROID_APP_SCHEME = "android-app";
    private static final int WEB_SOURCE_PARAMS_MAX_COUNT = 80;
    @NonNull
    public static final Parcelable.Creator<WebSourceRegistrationRequest> CREATOR = new Parcelable.Creator<WebSourceRegistrationRequest>(){

        @Override
        public WebSourceRegistrationRequest createFromParcel(Parcel in) {
            return new WebSourceRegistrationRequest(in);
        }

        public WebSourceRegistrationRequest[] newArray(int size) {
            return new WebSourceRegistrationRequest[size];
        }
    };
    @NonNull
    private final List<WebSourceParams> mWebSourceParams;
    @NonNull
    private final Uri mTopOriginUri;
    @Nullable
    private final InputEvent mInputEvent;
    @Nullable
    private final Uri mAppDestination;
    @Nullable
    private final Uri mWebDestination;
    @Nullable
    private final Uri mVerifiedDestination;

    private WebSourceRegistrationRequest(@NonNull Builder builder) {
        this.mWebSourceParams = builder.mWebSourceParams;
        this.mInputEvent = builder.mInputEvent;
        this.mTopOriginUri = builder.mTopOriginUri;
        this.mAppDestination = builder.mAppDestination;
        this.mWebDestination = builder.mWebDestination;
        this.mVerifiedDestination = builder.mVerifiedDestination;
    }

    private WebSourceRegistrationRequest(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        ArrayList<WebSourceParams> sourceRegistrations = new ArrayList<WebSourceParams>();
        if (_Original_Build.VERSION.SDK_INT < 33) {
            in.readList(sourceRegistrations, WebSourceParams.class.getClassLoader());
        } else {
            in.readList(sourceRegistrations, WebSourceParams.class.getClassLoader(), WebSourceParams.class);
        }
        this.mWebSourceParams = sourceRegistrations;
        this.mTopOriginUri = Uri.CREATOR.createFromParcel(in);
        this.mInputEvent = in.readBoolean() ? InputEvent.CREATOR.createFromParcel(in) : null;
        this.mAppDestination = in.readBoolean() ? Uri.CREATOR.createFromParcel(in) : null;
        this.mWebDestination = in.readBoolean() ? Uri.CREATOR.createFromParcel(in) : null;
        this.mVerifiedDestination = in.readBoolean() ? Uri.CREATOR.createFromParcel(in) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSourceRegistrationRequest)) {
            return false;
        }
        WebSourceRegistrationRequest that = (WebSourceRegistrationRequest)o;
        return Objects.equals(this.mWebSourceParams, that.mWebSourceParams) && Objects.equals(this.mTopOriginUri, that.mTopOriginUri) && Objects.equals(this.mInputEvent, that.mInputEvent) && Objects.equals(this.mAppDestination, that.mAppDestination) && Objects.equals(this.mWebDestination, that.mWebDestination) && Objects.equals(this.mVerifiedDestination, that.mVerifiedDestination);
    }

    public int hashCode() {
        return Objects.hash(this.mWebSourceParams, this.mTopOriginUri, this.mInputEvent, this.mAppDestination, this.mWebDestination, this.mVerifiedDestination);
    }

    @NonNull
    public List<WebSourceParams> getSourceParams() {
        return this.mWebSourceParams;
    }

    @NonNull
    public Uri getTopOriginUri() {
        return this.mTopOriginUri;
    }

    @Nullable
    public InputEvent getInputEvent() {
        return this.mInputEvent;
    }

    @Nullable
    public Uri getAppDestination() {
        return this.mAppDestination;
    }

    @Nullable
    public Uri getWebDestination() {
        return this.mWebDestination;
    }

    @Nullable
    public Uri getVerifiedDestination() {
        return this.mVerifiedDestination;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Objects.requireNonNull(out);
        out.writeList(this.mWebSourceParams);
        this.mTopOriginUri.writeToParcel(out, flags);
        if (this.mInputEvent != null) {
            out.writeBoolean(true);
            this.mInputEvent.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
        if (this.mAppDestination != null) {
            out.writeBoolean(true);
            this.mAppDestination.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
        if (this.mWebDestination != null) {
            out.writeBoolean(true);
            this.mWebDestination.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
        if (this.mVerifiedDestination != null) {
            out.writeBoolean(true);
            this.mVerifiedDestination.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
    }

    private static void validateScheme(String name, Uri uri) throws IllegalArgumentException {
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException(name + " must have a scheme.");
        }
    }

    public static class Builder {
        @NonNull
        private final List<WebSourceParams> mWebSourceParams;
        @NonNull
        private final Uri mTopOriginUri;
        @Nullable
        private InputEvent mInputEvent;
        @Nullable
        private Uri mAppDestination;
        @Nullable
        private Uri mWebDestination;
        @Nullable
        private Uri mVerifiedDestination;

        public Builder(@NonNull List<WebSourceParams> webSourceParams, @NonNull Uri topOriginUri) {
            Objects.requireNonNull(webSourceParams);
            Objects.requireNonNull(topOriginUri);
            if (webSourceParams.isEmpty() || webSourceParams.size() > 80) {
                throw new IllegalArgumentException("web source params size is not within bounds, size: " + webSourceParams.size());
            }
            this.mWebSourceParams = webSourceParams;
            this.mTopOriginUri = topOriginUri;
        }

        @NonNull
        public Builder setInputEvent(@Nullable InputEvent inputEvent) {
            this.mInputEvent = inputEvent;
            return this;
        }

        @NonNull
        public Builder setAppDestination(@Nullable Uri appDestination) {
            if (appDestination != null) {
                Uri destination;
                String scheme = appDestination.getScheme();
                if (scheme == null) {
                    destination = Uri.parse("android-app://" + appDestination);
                } else {
                    if (!scheme.equals(WebSourceRegistrationRequest.ANDROID_APP_SCHEME)) {
                        throw new IllegalArgumentException(String.format("appDestination scheme must be %s or null. Received: %s", WebSourceRegistrationRequest.ANDROID_APP_SCHEME, scheme));
                    }
                    destination = appDestination;
                }
                this.mAppDestination = destination;
            }
            return this;
        }

        @NonNull
        public Builder setWebDestination(@Nullable Uri webDestination) {
            if (webDestination != null) {
                WebSourceRegistrationRequest.validateScheme("Web destination", webDestination);
                this.mWebDestination = webDestination;
            }
            return this;
        }

        @NonNull
        public Builder setVerifiedDestination(@Nullable Uri verifiedDestination) {
            this.mVerifiedDestination = verifiedDestination;
            return this;
        }

        @NonNull
        public WebSourceRegistrationRequest build() {
            return new WebSourceRegistrationRequest(this);
        }
    }
}

