/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdSelectionSignals;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.time.Instant;
import java.util.Objects;

@FlaggedApi(value="com.android.adservices.flags.fledge_schedule_custom_audience_update_enabled")
public class PartialCustomAudience
implements Parcelable {
    @NonNull
    private final String mName;
    @Nullable
    private final Instant mActivationTime;
    @Nullable
    private final Instant mExpirationTime;
    @Nullable
    private final AdSelectionSignals mUserBiddingSignals;
    @NonNull
    public static final Parcelable.Creator<PartialCustomAudience> CREATOR = new Parcelable.Creator<PartialCustomAudience>(){

        @Override
        @NonNull
        public PartialCustomAudience createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new PartialCustomAudience(in);
        }

        @NonNull
        public PartialCustomAudience[] newArray(int size) {
            return new PartialCustomAudience[size];
        }
    };

    private PartialCustomAudience(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mName = builder.mName;
        this.mActivationTime = builder.mActivationTime;
        this.mExpirationTime = builder.mExpirationTime;
        this.mUserBiddingSignals = builder.mUserBiddingSignals;
    }

    private PartialCustomAudience(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mName = in.readString();
        this.mActivationTime = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> Instant.ofEpochMilli(sourceParcel.readLong()));
        this.mExpirationTime = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> Instant.ofEpochMilli(sourceParcel.readLong()));
        this.mUserBiddingSignals = AdServicesParcelableUtil.readNullableFromParcel(in, AdSelectionSignals.CREATOR::createFromParcel);
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Instant getActivationTime() {
        return this.mActivationTime;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.mExpirationTime;
    }

    @Nullable
    public AdSelectionSignals getUserBiddingSignals() {
        return this.mUserBiddingSignals;
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mActivationTime, this.mExpirationTime, this.mUserBiddingSignals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartialCustomAudience)) {
            return false;
        }
        PartialCustomAudience that = (PartialCustomAudience)o;
        return Objects.equals(this.mName, that.mName) && Objects.equals(this.mActivationTime, that.mActivationTime) && Objects.equals(this.mExpirationTime, that.mExpirationTime) && Objects.equals(this.mUserBiddingSignals, that.mUserBiddingSignals);
    }

    public String toString() {
        return "PartialCustomAudience {name=" + this.mName + ", activationTime=" + this.mActivationTime + ", expirationTime=" + this.mExpirationTime + ", userBiddingSignals=" + this.mUserBiddingSignals + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeString(this.mName);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mActivationTime, (targetParcel, sourceInstant) -> targetParcel.writeLong(sourceInstant.toEpochMilli()));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mExpirationTime, (targetParcel, sourceInstant) -> targetParcel.writeLong(sourceInstant.toEpochMilli()));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mUserBiddingSignals, (targetParcel, sourceSignals) -> sourceSignals.writeToParcel(targetParcel, flags));
    }

    public static class Builder {
        @NonNull
        private String mName;
        @Nullable
        private Instant mActivationTime;
        @Nullable
        private Instant mExpirationTime;
        @Nullable
        private AdSelectionSignals mUserBiddingSignals;

        public Builder(@NonNull String name) {
            Objects.requireNonNull(name);
            this.mName = name;
        }

        @NonNull
        public Builder setActivationTime(@Nullable Instant activationTime) {
            this.mActivationTime = activationTime;
            return this;
        }

        @NonNull
        public Builder setExpirationTime(@Nullable Instant expirationTime) {
            this.mExpirationTime = expirationTime;
            return this;
        }

        @NonNull
        public Builder setUserBiddingSignals(@Nullable AdSelectionSignals userBiddingSignals) {
            this.mUserBiddingSignals = userBiddingSignals;
            return this;
        }

        @NonNull
        public PartialCustomAudience build() {
            Objects.requireNonNull(this.mName);
            return new PartialCustomAudience(this);
        }
    }
}

