/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.AdServicesCommonManager;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
public class UpdateAdServicesModuleStatesParams
implements Parcelable {
    private final SparseIntArray mAdServicesModuleStates;
    private final int mNotificationType;
    @NonNull
    public static final Parcelable.Creator<UpdateAdServicesModuleStatesParams> CREATOR = new Parcelable.Creator<UpdateAdServicesModuleStatesParams>(){

        @Override
        public UpdateAdServicesModuleStatesParams createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new UpdateAdServicesModuleStatesParams(in);
        }

        public UpdateAdServicesModuleStatesParams[] newArray(int size) {
            return new UpdateAdServicesModuleStatesParams[size];
        }
    };

    private UpdateAdServicesModuleStatesParams(SparseIntArray adServicesModuleStates, int notificationType) {
        this.mAdServicesModuleStates = Objects.requireNonNull(adServicesModuleStates);
        this.mNotificationType = notificationType;
    }

    private UpdateAdServicesModuleStatesParams(Parcel in) {
        int moduleStatesSize = in.readInt();
        this.mAdServicesModuleStates = new SparseIntArray(moduleStatesSize);
        for (int i = 0; i < moduleStatesSize; ++i) {
            this.mAdServicesModuleStates.put(in.readInt(), in.readInt());
        }
        this.mNotificationType = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Objects.requireNonNull(out);
        int size = this.mAdServicesModuleStates.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeInt(this.mAdServicesModuleStates.keyAt(i));
            out.writeInt(this.mAdServicesModuleStates.valueAt(i));
        }
        out.writeInt(this.mNotificationType);
    }

    public int getModuleState(int module) {
        return this.mAdServicesModuleStates.get(module, 0);
    }

    public SparseIntArray getModuleStates() {
        return this.mAdServicesModuleStates;
    }

    public int getNotificationType() {
        return this.mNotificationType;
    }

    public String toString() {
        return "UpdateAdIdRequest{mAdServicesModuleStates=" + this.mAdServicesModuleStates + ", mNotificationType=" + this.mNotificationType + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAdServicesModuleStatesParams)) {
            return false;
        }
        UpdateAdServicesModuleStatesParams that = (UpdateAdServicesModuleStatesParams)o;
        return this.mAdServicesModuleStates == that.mAdServicesModuleStates && this.mNotificationType == that.mNotificationType;
    }

    public int hashCode() {
        return Objects.hash(this.mAdServicesModuleStates, this.mNotificationType);
    }

    public static class Builder {
        private final SparseIntArray mAdServicesModuleStateList = new SparseIntArray();
        private int mNotificationType;

        @NonNull
        public Builder setModuleState(int module, int moduleState) {
            this.mAdServicesModuleStateList.put(AdServicesCommonManager.validateModule(module), AdServicesCommonManager.validateModuleState(moduleState));
            return this;
        }

        @NonNull
        public Builder setNotificationType(int notificationType) {
            this.mNotificationType = notificationType;
            return this;
        }

        @NonNull
        public UpdateAdServicesModuleStatesParams build() {
            return new UpdateAdServicesModuleStatesParams(this.mAdServicesModuleStateList, this.mNotificationType);
        }
    }
}

