/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.time.Duration;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyedFrequencyCap
implements Parcelable {
    @VisibleForTesting
    public static final String AD_COUNTER_KEY_FIELD_NAME = "ad_counter_key";
    @VisibleForTesting
    public static final String MAX_COUNT_FIELD_NAME = "max_count";
    @VisibleForTesting
    public static final String INTERVAL_FIELD_NAME = "interval_in_seconds";
    public static final String MAX_COUNT_NOT_POSITIVE_ERROR_MESSAGE = "KeyedFrequencyCap max count %d must be strictly positive";
    public static final String INTERVAL_NULL_ERROR_MESSAGE = "KeyedFrequencyCap interval must not be null";
    public static final String INTERVAL_NOT_POSITIVE_FORMAT = "KeyedFrequencyCap interval %s must be strictly positive";
    public static final String MAX_INTERVAL_EXCEEDED_FORMAT = "KeyedFrequencyCap interval %s must be no greater than %s";
    public static final Duration MAX_INTERVAL = Duration.ofDays(100L);
    private static final int SIZE_OF_FIXED_FIELDS = 20;
    private final int mAdCounterKey;
    private final int mMaxCount;
    @NonNull
    private final Duration mInterval;
    @NonNull
    public static final Parcelable.Creator<KeyedFrequencyCap> CREATOR = new Parcelable.Creator<KeyedFrequencyCap>(){

        @Override
        public KeyedFrequencyCap createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new KeyedFrequencyCap(in);
        }

        public KeyedFrequencyCap[] newArray(int size) {
            return new KeyedFrequencyCap[size];
        }
    };

    private KeyedFrequencyCap(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mMaxCount = builder.mMaxCount;
        this.mInterval = builder.mInterval;
    }

    private KeyedFrequencyCap(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mAdCounterKey = in.readInt();
        this.mMaxCount = in.readInt();
        this.mInterval = Duration.ofSeconds(in.readLong());
    }

    @NonNull
    public int getAdCounterKey() {
        return this.mAdCounterKey;
    }

    public int getMaxCount() {
        return this.mMaxCount;
    }

    @NonNull
    public Duration getInterval() {
        return this.mInterval;
    }

    public int getSizeInBytes() {
        return 20;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject toReturn = new JSONObject();
        toReturn.put(AD_COUNTER_KEY_FIELD_NAME, this.mAdCounterKey);
        toReturn.put(MAX_COUNT_FIELD_NAME, this.mMaxCount);
        toReturn.put(INTERVAL_FIELD_NAME, this.mInterval.getSeconds());
        return toReturn;
    }

    public static KeyedFrequencyCap fromJson(JSONObject json) throws JSONException {
        return new Builder(json.getInt(AD_COUNTER_KEY_FIELD_NAME), json.getInt(MAX_COUNT_FIELD_NAME), Duration.ofSeconds(json.getLong(INTERVAL_FIELD_NAME))).build();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mAdCounterKey);
        dest.writeInt(this.mMaxCount);
        dest.writeLong(this.mInterval.getSeconds());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyedFrequencyCap)) {
            return false;
        }
        KeyedFrequencyCap that = (KeyedFrequencyCap)o;
        return this.mMaxCount == that.mMaxCount && ((Object)this.mInterval).equals(that.mInterval) && this.mAdCounterKey == that.mAdCounterKey;
    }

    public int hashCode() {
        return Objects.hash(this.mAdCounterKey, this.mMaxCount, this.mInterval);
    }

    public String toString() {
        return "KeyedFrequencyCap{mAdCounterKey=" + this.mAdCounterKey + ", mMaxCount=" + this.mMaxCount + ", mInterval=" + this.mInterval + '}';
    }

    public static class Builder {
        private int mAdCounterKey;
        private int mMaxCount;
        @NonNull
        private Duration mInterval;

        public Builder(int adCounterKey, int maxCount, @NonNull Duration interval) {
            Preconditions.checkArgument(maxCount > 0, KeyedFrequencyCap.MAX_COUNT_NOT_POSITIVE_ERROR_MESSAGE, maxCount);
            Objects.requireNonNull(interval, KeyedFrequencyCap.INTERVAL_NULL_ERROR_MESSAGE);
            Preconditions.checkArgument(interval.getSeconds() > 0L, KeyedFrequencyCap.INTERVAL_NOT_POSITIVE_FORMAT, interval);
            Preconditions.checkArgument(interval.getSeconds() <= MAX_INTERVAL.getSeconds(), KeyedFrequencyCap.MAX_INTERVAL_EXCEEDED_FORMAT, interval, MAX_INTERVAL);
            this.mAdCounterKey = adCounterKey;
            this.mMaxCount = maxCount;
            this.mInterval = interval;
        }

        @NonNull
        public Builder setAdCounterKey(int adCounterKey) {
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        @NonNull
        public Builder setMaxCount(int maxCount) {
            Preconditions.checkArgument(maxCount > 0, KeyedFrequencyCap.MAX_COUNT_NOT_POSITIVE_ERROR_MESSAGE, maxCount);
            this.mMaxCount = maxCount;
            return this;
        }

        @NonNull
        public Builder setInterval(@NonNull Duration interval) {
            Objects.requireNonNull(interval, KeyedFrequencyCap.INTERVAL_NULL_ERROR_MESSAGE);
            Preconditions.checkArgument(interval.getSeconds() > 0L, KeyedFrequencyCap.INTERVAL_NOT_POSITIVE_FORMAT, interval);
            Preconditions.checkArgument(interval.getSeconds() <= MAX_INTERVAL.getSeconds(), KeyedFrequencyCap.MAX_INTERVAL_EXCEEDED_FORMAT, interval, MAX_INTERVAL);
            this.mInterval = interval;
            return this;
        }

        @NonNull
        public KeyedFrequencyCap build() {
            return new KeyedFrequencyCap(this);
        }
    }
}

