/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.KeyedFrequencyCap;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FrequencyCapFilters
implements Parcelable {
    public static final String NUM_FREQUENCY_CAP_FILTERS_EXCEEDED_FORMAT = "FrequencyCapFilters should have no more than %d filters";
    public static final int MAX_NUM_FREQUENCY_CAP_FILTERS = 20;
    public static final String FREQUENCY_CAP_FILTERS_NULL_LIST_ERROR_MESSAGE = "FrequencyCapFilters should not set null list of KeyedFrequencyCaps";
    public static final String FREQUENCY_CAP_FILTERS_NULL_ELEMENT_ERROR_MESSAGE = "FrequencyCapFilters should not contain null KeyedFrequencyCaps";
    public static final int AD_EVENT_TYPE_INVALID = -1;
    public static final int AD_EVENT_TYPE_WIN = 0;
    public static final int AD_EVENT_TYPE_IMPRESSION = 1;
    public static final int AD_EVENT_TYPE_VIEW = 2;
    public static final int AD_EVENT_TYPE_CLICK = 3;
    public static final int AD_EVENT_TYPE_MIN = 0;
    public static final int AD_EVENT_TYPE_MAX = 3;
    @VisibleForTesting
    public static final String WIN_EVENTS_FIELD_NAME = "win";
    @VisibleForTesting
    public static final String IMPRESSION_EVENTS_FIELD_NAME = "impression";
    @VisibleForTesting
    public static final String VIEW_EVENTS_FIELD_NAME = "view";
    @VisibleForTesting
    public static final String CLICK_EVENTS_FIELD_NAME = "click";
    @NonNull
    private final List<KeyedFrequencyCap> mKeyedFrequencyCapsForWinEvents;
    @NonNull
    private final List<KeyedFrequencyCap> mKeyedFrequencyCapsForImpressionEvents;
    @NonNull
    private final List<KeyedFrequencyCap> mKeyedFrequencyCapsForViewEvents;
    @NonNull
    private final List<KeyedFrequencyCap> mKeyedFrequencyCapsForClickEvents;
    @NonNull
    public static final Parcelable.Creator<FrequencyCapFilters> CREATOR = new Parcelable.Creator<FrequencyCapFilters>(){

        @Override
        public FrequencyCapFilters createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new FrequencyCapFilters(in);
        }

        public FrequencyCapFilters[] newArray(int size) {
            return new FrequencyCapFilters[size];
        }
    };

    private FrequencyCapFilters(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mKeyedFrequencyCapsForWinEvents = builder.mKeyedFrequencyCapsForWinEvents;
        this.mKeyedFrequencyCapsForImpressionEvents = builder.mKeyedFrequencyCapsForImpressionEvents;
        this.mKeyedFrequencyCapsForViewEvents = builder.mKeyedFrequencyCapsForViewEvents;
        this.mKeyedFrequencyCapsForClickEvents = builder.mKeyedFrequencyCapsForClickEvents;
    }

    private FrequencyCapFilters(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mKeyedFrequencyCapsForWinEvents = new ArrayList<KeyedFrequencyCap>();
        this.mKeyedFrequencyCapsForImpressionEvents = new ArrayList<KeyedFrequencyCap>();
        this.mKeyedFrequencyCapsForViewEvents = new ArrayList<KeyedFrequencyCap>();
        this.mKeyedFrequencyCapsForClickEvents = new ArrayList<KeyedFrequencyCap>();
        in.readTypedList(this.mKeyedFrequencyCapsForWinEvents, KeyedFrequencyCap.CREATOR);
        in.readTypedList(this.mKeyedFrequencyCapsForImpressionEvents, KeyedFrequencyCap.CREATOR);
        in.readTypedList(this.mKeyedFrequencyCapsForViewEvents, KeyedFrequencyCap.CREATOR);
        in.readTypedList(this.mKeyedFrequencyCapsForClickEvents, KeyedFrequencyCap.CREATOR);
    }

    @NonNull
    public List<KeyedFrequencyCap> getKeyedFrequencyCapsForWinEvents() {
        return this.mKeyedFrequencyCapsForWinEvents;
    }

    @NonNull
    public List<KeyedFrequencyCap> getKeyedFrequencyCapsForImpressionEvents() {
        return this.mKeyedFrequencyCapsForImpressionEvents;
    }

    @NonNull
    public List<KeyedFrequencyCap> getKeyedFrequencyCapsForViewEvents() {
        return this.mKeyedFrequencyCapsForViewEvents;
    }

    @NonNull
    public List<KeyedFrequencyCap> getKeyedFrequencyCapsForClickEvents() {
        return this.mKeyedFrequencyCapsForClickEvents;
    }

    public int getSizeInBytes() {
        return this.getSizeInBytesOfFcapList(this.mKeyedFrequencyCapsForWinEvents) + this.getSizeInBytesOfFcapList(this.mKeyedFrequencyCapsForImpressionEvents) + this.getSizeInBytesOfFcapList(this.mKeyedFrequencyCapsForViewEvents) + this.getSizeInBytesOfFcapList(this.mKeyedFrequencyCapsForClickEvents);
    }

    private int getSizeInBytesOfFcapList(List<KeyedFrequencyCap> fcaps) {
        int toReturn = 0;
        for (KeyedFrequencyCap fcap : fcaps) {
            toReturn += fcap.getSizeInBytes();
        }
        return toReturn;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject toReturn = new JSONObject();
        toReturn.put(WIN_EVENTS_FIELD_NAME, FrequencyCapFilters.fcapSetToJsonArray(this.mKeyedFrequencyCapsForWinEvents));
        toReturn.put(IMPRESSION_EVENTS_FIELD_NAME, FrequencyCapFilters.fcapSetToJsonArray(this.mKeyedFrequencyCapsForImpressionEvents));
        toReturn.put(VIEW_EVENTS_FIELD_NAME, FrequencyCapFilters.fcapSetToJsonArray(this.mKeyedFrequencyCapsForViewEvents));
        toReturn.put(CLICK_EVENTS_FIELD_NAME, FrequencyCapFilters.fcapSetToJsonArray(this.mKeyedFrequencyCapsForClickEvents));
        return toReturn;
    }

    private static JSONArray fcapSetToJsonArray(List<KeyedFrequencyCap> fcapSet) throws JSONException {
        JSONArray toReturn = new JSONArray();
        for (KeyedFrequencyCap fcap : fcapSet) {
            toReturn.put(fcap.toJson());
        }
        return toReturn;
    }

    public static FrequencyCapFilters fromJson(JSONObject json) throws JSONException {
        Builder builder = new Builder();
        if (json.has(WIN_EVENTS_FIELD_NAME)) {
            builder.setKeyedFrequencyCapsForWinEvents(FrequencyCapFilters.jsonArrayToFcapList(json.getJSONArray(WIN_EVENTS_FIELD_NAME)));
        }
        if (json.has(IMPRESSION_EVENTS_FIELD_NAME)) {
            builder.setKeyedFrequencyCapsForImpressionEvents(FrequencyCapFilters.jsonArrayToFcapList(json.getJSONArray(IMPRESSION_EVENTS_FIELD_NAME)));
        }
        if (json.has(VIEW_EVENTS_FIELD_NAME)) {
            builder.setKeyedFrequencyCapsForViewEvents(FrequencyCapFilters.jsonArrayToFcapList(json.getJSONArray(VIEW_EVENTS_FIELD_NAME)));
        }
        if (json.has(CLICK_EVENTS_FIELD_NAME)) {
            builder.setKeyedFrequencyCapsForClickEvents(FrequencyCapFilters.jsonArrayToFcapList(json.getJSONArray(CLICK_EVENTS_FIELD_NAME)));
        }
        return builder.build();
    }

    private static List<KeyedFrequencyCap> jsonArrayToFcapList(JSONArray json) throws JSONException {
        ArrayList<KeyedFrequencyCap> toReturn = new ArrayList<KeyedFrequencyCap>();
        for (int i = 0; i < json.length(); ++i) {
            toReturn.add(KeyedFrequencyCap.fromJson(json.getJSONObject(i)));
        }
        return toReturn;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeTypedList(this.mKeyedFrequencyCapsForWinEvents);
        dest.writeTypedList(this.mKeyedFrequencyCapsForImpressionEvents);
        dest.writeTypedList(this.mKeyedFrequencyCapsForViewEvents);
        dest.writeTypedList(this.mKeyedFrequencyCapsForClickEvents);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FrequencyCapFilters)) {
            return false;
        }
        FrequencyCapFilters that = (FrequencyCapFilters)o;
        return this.mKeyedFrequencyCapsForWinEvents.equals(that.mKeyedFrequencyCapsForWinEvents) && this.mKeyedFrequencyCapsForImpressionEvents.equals(that.mKeyedFrequencyCapsForImpressionEvents) && this.mKeyedFrequencyCapsForViewEvents.equals(that.mKeyedFrequencyCapsForViewEvents) && this.mKeyedFrequencyCapsForClickEvents.equals(that.mKeyedFrequencyCapsForClickEvents);
    }

    public int hashCode() {
        return Objects.hash(this.mKeyedFrequencyCapsForWinEvents, this.mKeyedFrequencyCapsForImpressionEvents, this.mKeyedFrequencyCapsForViewEvents, this.mKeyedFrequencyCapsForClickEvents);
    }

    public String toString() {
        return "FrequencyCapFilters{mKeyedFrequencyCapsForWinEvents=" + this.mKeyedFrequencyCapsForWinEvents + ", mKeyedFrequencyCapsForImpressionEvents=" + this.mKeyedFrequencyCapsForImpressionEvents + ", mKeyedFrequencyCapsForViewEvents=" + this.mKeyedFrequencyCapsForViewEvents + ", mKeyedFrequencyCapsForClickEvents=" + this.mKeyedFrequencyCapsForClickEvents + '}';
    }

    public static class Builder {
        @NonNull
        private List<KeyedFrequencyCap> mKeyedFrequencyCapsForWinEvents = new ArrayList<KeyedFrequencyCap>();
        @NonNull
        private List<KeyedFrequencyCap> mKeyedFrequencyCapsForImpressionEvents = new ArrayList<KeyedFrequencyCap>();
        @NonNull
        private List<KeyedFrequencyCap> mKeyedFrequencyCapsForViewEvents = new ArrayList<KeyedFrequencyCap>();
        @NonNull
        private List<KeyedFrequencyCap> mKeyedFrequencyCapsForClickEvents = new ArrayList<KeyedFrequencyCap>();

        @NonNull
        public Builder setKeyedFrequencyCapsForWinEvents(@NonNull List<KeyedFrequencyCap> keyedFrequencyCapsForWinEvents) {
            Objects.requireNonNull(keyedFrequencyCapsForWinEvents, FrequencyCapFilters.FREQUENCY_CAP_FILTERS_NULL_LIST_ERROR_MESSAGE);
            Preconditions.checkArgument(!keyedFrequencyCapsForWinEvents.contains(null), FrequencyCapFilters.FREQUENCY_CAP_FILTERS_NULL_ELEMENT_ERROR_MESSAGE);
            this.mKeyedFrequencyCapsForWinEvents = keyedFrequencyCapsForWinEvents;
            return this;
        }

        @NonNull
        public Builder setKeyedFrequencyCapsForImpressionEvents(@NonNull List<KeyedFrequencyCap> keyedFrequencyCapsForImpressionEvents) {
            Objects.requireNonNull(keyedFrequencyCapsForImpressionEvents, FrequencyCapFilters.FREQUENCY_CAP_FILTERS_NULL_LIST_ERROR_MESSAGE);
            Preconditions.checkArgument(!keyedFrequencyCapsForImpressionEvents.contains(null), FrequencyCapFilters.FREQUENCY_CAP_FILTERS_NULL_ELEMENT_ERROR_MESSAGE);
            this.mKeyedFrequencyCapsForImpressionEvents = keyedFrequencyCapsForImpressionEvents;
            return this;
        }

        @NonNull
        public Builder setKeyedFrequencyCapsForViewEvents(@NonNull List<KeyedFrequencyCap> keyedFrequencyCapsForViewEvents) {
            Objects.requireNonNull(keyedFrequencyCapsForViewEvents, FrequencyCapFilters.FREQUENCY_CAP_FILTERS_NULL_LIST_ERROR_MESSAGE);
            Preconditions.checkArgument(!keyedFrequencyCapsForViewEvents.contains(null), FrequencyCapFilters.FREQUENCY_CAP_FILTERS_NULL_ELEMENT_ERROR_MESSAGE);
            this.mKeyedFrequencyCapsForViewEvents = keyedFrequencyCapsForViewEvents;
            return this;
        }

        @NonNull
        public Builder setKeyedFrequencyCapsForClickEvents(@NonNull List<KeyedFrequencyCap> keyedFrequencyCapsForClickEvents) {
            Objects.requireNonNull(keyedFrequencyCapsForClickEvents, FrequencyCapFilters.FREQUENCY_CAP_FILTERS_NULL_LIST_ERROR_MESSAGE);
            Preconditions.checkArgument(!keyedFrequencyCapsForClickEvents.contains(null), FrequencyCapFilters.FREQUENCY_CAP_FILTERS_NULL_ELEMENT_ERROR_MESSAGE);
            this.mKeyedFrequencyCapsForClickEvents = keyedFrequencyCapsForClickEvents;
            return this;
        }

        @NonNull
        public FrequencyCapFilters build() {
            int numFrequencyCapFilters = 0;
            numFrequencyCapFilters += this.mKeyedFrequencyCapsForWinEvents.size();
            numFrequencyCapFilters += this.mKeyedFrequencyCapsForImpressionEvents.size();
            numFrequencyCapFilters += this.mKeyedFrequencyCapsForViewEvents.size();
            Preconditions.checkArgument((numFrequencyCapFilters += this.mKeyedFrequencyCapsForClickEvents.size()) <= 20, FrequencyCapFilters.NUM_FREQUENCY_CAP_FILTERS_EXCEEDED_FORMAT, 20);
            return new FrequencyCapFilters(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdEventType {
    }
}

