/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.Objects;
import java.util.Set;

public class SetAppInstallAdvertisersInput
implements Parcelable {
    @NonNull
    private final Set<AdTechIdentifier> mAdvertisers;
    @NonNull
    private final String mCallerPackageName;
    @NonNull
    public static final Parcelable.Creator<SetAppInstallAdvertisersInput> CREATOR = new Parcelable.Creator<SetAppInstallAdvertisersInput>(){

        @Override
        @NonNull
        public SetAppInstallAdvertisersInput createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new SetAppInstallAdvertisersInput(in);
        }

        @NonNull
        public SetAppInstallAdvertisersInput[] newArray(int size) {
            return new SetAppInstallAdvertisersInput[size];
        }
    };

    private SetAppInstallAdvertisersInput(@NonNull Set<AdTechIdentifier> advertisers, @NonNull String callerPackageName) {
        Objects.requireNonNull(advertisers);
        Objects.requireNonNull(callerPackageName);
        this.mAdvertisers = advertisers;
        this.mCallerPackageName = callerPackageName;
    }

    private SetAppInstallAdvertisersInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mAdvertisers = AdServicesParcelableUtil.readSetFromParcel(in, AdTechIdentifier.CREATOR);
        this.mCallerPackageName = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        AdServicesParcelableUtil.writeSetToParcel(dest, this.mAdvertisers);
        dest.writeString(this.mCallerPackageName);
    }

    @NonNull
    public Set<AdTechIdentifier> getAdvertisers() {
        return this.mAdvertisers;
    }

    @NonNull
    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public static class Builder {
        @Nullable
        private Set<AdTechIdentifier> mAdvertisers;
        @Nullable
        private String mCallerPackageName;

        @NonNull
        public Builder setAdvertisers(@NonNull Set<AdTechIdentifier> advertisers) {
            Objects.requireNonNull(advertisers);
            this.mAdvertisers = advertisers;
            return this;
        }

        @NonNull
        public Builder setCallerPackageName(@NonNull String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        @NonNull
        public SetAppInstallAdvertisersInput build() {
            Objects.requireNonNull(this.mAdvertisers);
            Objects.requireNonNull(this.mCallerPackageName);
            return new SetAppInstallAdvertisersInput(this.mAdvertisers, this.mCallerPackageName);
        }
    }
}

