/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@FlaggedApi(value="com.android.adservices.flags.fledge_get_ad_selection_data_seller_configuration_enabled")
public class PerBuyerConfiguration
implements Parcelable {
    @NonNull
    private final AdTechIdentifier mBuyer;
    private final int mTargetInputSizeBytes;
    @NonNull
    public static final Parcelable.Creator<PerBuyerConfiguration> CREATOR = new Parcelable.Creator<PerBuyerConfiguration>(){

        @Override
        public PerBuyerConfiguration createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new PerBuyerConfiguration(in);
        }

        public PerBuyerConfiguration[] newArray(int size) {
            return new PerBuyerConfiguration[size];
        }
    };

    private PerBuyerConfiguration(Parcel in) {
        this.mBuyer = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mTargetInputSizeBytes = in.readInt();
    }

    private PerBuyerConfiguration(@NonNull AdTechIdentifier buyer, int targetInputSizeBytes) {
        Objects.requireNonNull(buyer, "Buyer must be set.");
        this.mBuyer = buyer;
        this.mTargetInputSizeBytes = targetInputSizeBytes;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mBuyer.writeToParcel(dest, flags);
        dest.writeInt(this.mTargetInputSizeBytes);
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    public int getTargetInputSizeBytes() {
        return this.mTargetInputSizeBytes;
    }

    public boolean equals(Object o) {
        if (o instanceof PerBuyerConfiguration) {
            PerBuyerConfiguration perBuyerConfiguration = (PerBuyerConfiguration)o;
            return Objects.equals(this.mBuyer, perBuyerConfiguration.mBuyer) && this.mTargetInputSizeBytes == perBuyerConfiguration.mTargetInputSizeBytes;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mBuyer, this.mTargetInputSizeBytes);
    }

    public static class Builder {
        @NonNull
        private AdTechIdentifier mBuyer = null;
        private int mTargetInputSizeBytes;

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer);
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public Builder setTargetInputSizeBytes(int targetInputSizeB) {
            this.mTargetInputSizeBytes = targetInputSizeB;
            return this;
        }

        @NonNull
        public PerBuyerConfiguration build() {
            Objects.requireNonNull(this.mBuyer);
            if (this.mTargetInputSizeBytes < 0) {
                throw new IllegalArgumentException("Target input size must be non-negative.");
            }
            return new PerBuyerConfiguration(this.mBuyer, this.mTargetInputSizeBytes);
        }
    }
}

