/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import com.android.internal.util.Preconditions;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.Objects;

public class GetAdSelectionDataOutcome {
    private final long mAdSelectionId;
    @Nullable
    private final byte[] mAdSelectionData;

    private GetAdSelectionDataOutcome(long adSelectionId, @Nullable byte[] adSelectionData) {
        this.mAdSelectionId = adSelectionId;
        this.mAdSelectionData = adSelectionData;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_auction_server_get_ad_selection_data_id_enabled")
    public long getAdSelectionDataId() {
        return this.mAdSelectionId;
    }

    @Nullable
    public byte[] getAdSelectionData() {
        if (Objects.isNull(this.mAdSelectionData)) {
            return null;
        }
        return Arrays.copyOf(this.mAdSelectionData, this.mAdSelectionData.length);
    }

    public static class Builder {
        private long mAdSelectionId;
        @Nullable
        private byte[] mAdSelectionData;

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        public Builder setAdSelectionData(@Nullable byte[] adSelectionData) {
            this.mAdSelectionData = (byte[])(!Objects.isNull(adSelectionData) ? Arrays.copyOf(adSelectionData, adSelectionData.length) : null);
            return this;
        }

        @NonNull
        public GetAdSelectionDataOutcome build() {
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Non-zero ad selection ID must be set");
            return new GetAdSelectionDataOutcome(this.mAdSelectionId, this.mAdSelectionData);
        }
    }
}

