/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging.slf4j.internal;

import io.github.oshai.kotlinlogging.DelegatingKLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import io.github.oshai.kotlinlogging.slf4j.Slf4jExtensionsKt;
import io.github.oshai.kotlinlogging.slf4j.internal.Slf4jLogger;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.spi.LoggingEventBuilder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00030\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J3\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u0017\u00a2\u0006\u0002\b\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\"\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lio/github/oshai/kotlinlogging/slf4j/internal/LocationIgnorantKLogger;", "Lio/github/oshai/kotlinlogging/KLogger;", "Lio/github/oshai/kotlinlogging/DelegatingKLogger;", "Lorg/slf4j/Logger;", "Lio/github/oshai/kotlinlogging/slf4j/internal/Slf4jLogger;", "underlyingLogger", "<init>", "(Lorg/slf4j/Logger;)V", "getUnderlyingLogger", "()Lorg/slf4j/Logger;", "name", "", "getName", "()Ljava/lang/String;", "isLoggingEnabledFor", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "at", "", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "logWithPayload", "kLoggingEventBuilder", "logWithoutPayload", "kotlin-logging"})
@SourceDebugExtension(value={"SMAP\nLocationIgnorantKLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationIgnorantKLogger.kt\nio/github/oshai/kotlinlogging/slf4j/internal/LocationIgnorantKLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,68:1\n1#2:69\n216#3,2:70\n*S KotlinDebug\n*F\n+ 1 LocationIgnorantKLogger.kt\nio/github/oshai/kotlinlogging/slf4j/internal/LocationIgnorantKLogger\n*L\n45#1:70,2\n*E\n"})
public final class LocationIgnorantKLogger
extends Slf4jLogger<Logger>
implements KLogger,
DelegatingKLogger<Logger> {
    @NotNull
    private final Logger underlyingLogger;

    public LocationIgnorantKLogger(@NotNull Logger underlyingLogger) {
        Intrinsics.checkNotNullParameter((Object)underlyingLogger, (String)"underlyingLogger");
        this.underlyingLogger = underlyingLogger;
    }

    @Override
    @NotNull
    public Logger getUnderlyingLogger() {
        return this.underlyingLogger;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getUnderlyingLogger().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.isLoggingEnabledFor(this.getUnderlyingLogger(), level, marker);
    }

    @Override
    public void at(@NotNull Level level, @Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.isLoggingEnabledFor(level, marker)) {
            KLoggingEventBuilder kLoggingEventBuilder = new KLoggingEventBuilder();
            block.invoke((Object)kLoggingEventBuilder);
            KLoggingEventBuilder $this$at_u24lambda_u240 = kLoggingEventBuilder;
            boolean bl = false;
            if ($this$at_u24lambda_u240.getPayload() != null) {
                this.logWithPayload($this$at_u24lambda_u240, level, marker);
            } else {
                this.logWithoutPayload($this$at_u24lambda_u240, level, marker);
            }
        }
    }

    private final void logWithPayload(KLoggingEventBuilder kLoggingEventBuilder, Level level, Marker marker) {
        LoggingEventBuilder builder = this.getUnderlyingLogger().atLevel(Slf4jExtensionsKt.toSlf4j(level));
        Marker marker2 = marker;
        if (marker2 != null && (marker2 = Slf4jExtensionsKt.toSlf4j(marker2)) != null) {
            Marker it = marker2;
            boolean bl = false;
            builder.addMarker((org.slf4j.Marker)it);
        }
        Map<String, Object> map = kLoggingEventBuilder.getPayload();
        if (map != null) {
            Map<String, Object> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator.next();
                boolean bl = false;
                String key2 = entry.getKey();
                Object value = entry.getValue();
                builder.addKeyValue(key2, value);
            }
        }
        builder.setCause(kLoggingEventBuilder.getCause());
        builder.log(kLoggingEventBuilder.getMessage());
    }

    private final void logWithoutPayload(KLoggingEventBuilder kLoggingEventBuilder, Level level, Marker marker) {
        Marker marker2 = marker;
        org.slf4j.Marker slf4jMarker = marker2 != null ? Slf4jExtensionsKt.toSlf4j(marker2) : null;
        String message = kLoggingEventBuilder.getMessage();
        Throwable cause = kLoggingEventBuilder.getCause();
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                this.getUnderlyingLogger().trace(slf4jMarker, message, cause);
                break;
            }
            case 2: {
                this.getUnderlyingLogger().debug(slf4jMarker, message, cause);
                break;
            }
            case 3: {
                this.getUnderlyingLogger().info(slf4jMarker, message, cause);
                break;
            }
            case 4: {
                this.getUnderlyingLogger().warn(slf4jMarker, message, cause);
                break;
            }
            case 5: {
                this.getUnderlyingLogger().error(slf4jMarker, message, cause);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.OFF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

