/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.FastInput;
import com.esotericsoftware.kryo.io.FastOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.OCSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.PersistentByteStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestInfoSerializer
extends OCSerializer {
    private static final int TEST_SERIALIZATION_VERSION = 26;
    private static final int CHUNK_SIZE = 256;
    private final CidrTestFrameworkBase<?> myFramework;
    private final PsiManager myPsiManager;
    private PsiFile myPsiFile;
    private final MyStorage myStorage;

    public CidrTestInfoSerializer(@NotNull Project project, @NotNull CidrTestFrameworkBase<?> framework) {
        if (project == null) {
            CidrTestInfoSerializer.$$$reportNull$$$0(0);
        }
        if (framework == null) {
            CidrTestInfoSerializer.$$$reportNull$$$0(1);
        }
        this.myFramework = framework;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myFramework.registerSerializers(this);
        this.myStorage = new MyStorage("file_test_scopes" + this.myFramework.getFrameworkId());
    }

    public void writeTestInfo(@NotNull VirtualFile vfValidWithTests, @NotNull CidrTestInfoForFile testInfoForFile) {
        if (vfValidWithTests == null) {
            CidrTestInfoSerializer.$$$reportNull$$$0(2);
        }
        if (testInfoForFile == null) {
            CidrTestInfoSerializer.$$$reportNull$$$0(3);
        }
        try (DataOutputStream dos = this.myStorage.outputStream(vfValidWithTests);
             FastOutput output = new FastOutput((OutputStream)dos, 256);){
            output.writeLong(vfValidWithTests.getTimeStamp());
            this.getKryo().writeObject((Output)output, (Object)testInfoForFile);
            CidrTestLog.LOG.debug("write:", new Object[]{vfValidWithTests.getName(), " OK"});
        }
        catch (Throwable serializationProblem) {
            CidrTestLog.LOG.warn("Kryo error test write " + vfValidWithTests.getName() + ":" + serializationProblem.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Pair<Boolean, CidrTestInfoForFile> filterTestHoldersAndReadTestInfo(@NotNull VirtualFile vfAny) {
        block15: {
            if (vfAny == null) {
                CidrTestInfoSerializer.$$$reportNull$$$0(4);
            }
            if (!this.validPotentialTestHolder(vfAny)) {
                return Pair.create((Object)true, null);
            }
            try (DataInputStream dis = this.myStorage.inputStream(vfAny);){
                Pair pair;
                if (dis == null) break block15;
                Kryo kryo = this.getKryo();
                try (FastInput input = new FastInput((InputStream)dis, 256);){
                    boolean isActual = vfAny.getTimeStamp() == input.readLong();
                    CidrTestInfoForFile ti = (CidrTestInfoForFile)((Object)kryo.readObject((Input)input, CidrTestInfoForFile.class));
                    CidrTestLog.LOG.debug("read:", new Object[]{vfAny.getName(), " OK"});
                    pair = Pair.create((Object)isActual, (Object)((Object)ti));
                }
                return pair;
            }
            catch (Throwable serializationProblem) {
                CidrTestLog.LOG.warn("Kryo error test read " + vfAny.getName() + ":" + serializationProblem.getMessage());
            }
        }
        return null;
    }

    private boolean validPotentialTestHolder(@NotNull VirtualFile vfToCheck) {
        if (vfToCheck == null) {
            CidrTestInfoSerializer.$$$reportNull$$$0(5);
        }
        if (!vfToCheck.isValid()) {
            return false;
        }
        this.myPsiFile = this.myPsiManager.findFile(vfToCheck);
        return this.myPsiFile != null && this.myFramework.isPotentialTestHolderFile(this.myPsiFile);
    }

    protected void registerSerializers() {
        Kryo kryo = this.getKryo();
        kryo.register(CidrTestFrameworkVersion.class);
        kryo.register(CidrTestInfoForFile.class, (Serializer)new Serializer<CidrTestInfoForFile>(){

            public void write(Kryo kryo, Output output, CidrTestInfoForFile testInfo) {
                CidrTestFrameworkVersion version = testInfo.getFrameworkVersion();
                kryo.writeObject(output, (Object)version);
                if (version != CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    CidrTestInfoSerializer.this.myFramework.writeTestInfo(kryo, output, testInfo);
                }
            }

            public CidrTestInfoForFile read(Kryo kryo, Input input, Class<CidrTestInfoForFile> type) {
                CidrTestFrameworkVersion version = (CidrTestFrameworkVersion)((Object)kryo.readObject(input, CidrTestFrameworkVersion.class));
                CidrTestInfoForFile ret = new CidrTestInfoForFile(-1L, version);
                if (version != CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    CidrTestInfoSerializer.this.myFramework.readTestInfo(kryo, input, ret, CidrTestInfoSerializer.this.myPsiFile);
                }
                return ret;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfValidWithTests";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testInfoForFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfAny";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfToCheck";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestInfoSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTestInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "filterTestHoldersAndReadTestInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "validPotentialTestHolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyStorage {
        private final PersistentByteStorage storage;
        private final String mySerializationId;

        private MyStorage(@NotNull String serializationId) {
            if (serializationId == null) {
                MyStorage.$$$reportNull$$$0(0);
            }
            this.storage = PersistentByteStorage.create((int)26);
            this.mySerializationId = serializationId;
        }

        @NotNull
        DataOutputStream outputStream(VirtualFile file) {
            DataOutputStream dataOutputStream = this.storage.outputStream(file, this.mySerializationId);
            if (dataOutputStream == null) {
                MyStorage.$$$reportNull$$$0(1);
            }
            return dataOutputStream;
        }

        @Nullable
        DataInputStream inputStream(VirtualFile file) {
            return this.storage.inputStream(file, this.mySerializationId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serializationId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestInfoSerializer$MyStorage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestInfoSerializer$MyStorage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "outputStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

