/*
 * Decompiled with CFR 0.152.
 */
package aida.io.opencensus.trace.samplers;

import aida.io.opencensus.internal.Utils;
import aida.io.opencensus.trace.Sampler;
import aida.io.opencensus.trace.Span;
import aida.io.opencensus.trace.SpanContext;
import aida.io.opencensus.trace.SpanId;
import aida.io.opencensus.trace.TraceId;
import aida.io.opencensus.trace.samplers.AutoValue_ProbabilitySampler;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class ProbabilitySampler
extends Sampler {
    ProbabilitySampler() {
    }

    abstract double getProbability();

    abstract long getIdUpperBound();

    static ProbabilitySampler create(double probability) {
        Utils.checkArgument(probability >= 0.0 && probability <= 1.0, "probability must be in range [0.0, 1.0]");
        long idUpperBound = probability == 0.0 ? Long.MIN_VALUE : (probability == 1.0 ? Long.MAX_VALUE : (long)(probability * 9.223372036854776E18));
        return new AutoValue_ProbabilitySampler(probability, idUpperBound);
    }

    @Override
    public final boolean shouldSample(@Nullable SpanContext parentContext, @Nullable Boolean hasRemoteParent, TraceId traceId, SpanId spanId, String name, @Nullable List<Span> parentLinks) {
        if (parentContext != null && parentContext.getTraceOptions().isSampled()) {
            return true;
        }
        if (parentLinks != null) {
            for (Span parentLink : parentLinks) {
                if (!parentLink.getContext().getTraceOptions().isSampled()) continue;
                return true;
            }
        }
        return Math.abs(traceId.getLowerLong()) < this.getIdUpperBound();
    }

    @Override
    public final String getDescription() {
        return String.format("ProbabilitySampler{%.6f}", this.getProbability());
    }
}

