/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.okhttp;

import aida.io.grpc.Attributes;
import aida.io.grpc.Metadata;
import aida.io.grpc.Status;
import aida.io.grpc.internal.AbstractServerStream;
import aida.io.grpc.internal.StatsTraceContext;
import aida.io.grpc.internal.TransportTracer;
import aida.io.grpc.internal.WritableBuffer;
import aida.io.grpc.okhttp.ExceptionHandlingFrameWriter;
import aida.io.grpc.okhttp.Headers;
import aida.io.grpc.okhttp.OkHttpReadableBuffer;
import aida.io.grpc.okhttp.OkHttpServerTransport;
import aida.io.grpc.okhttp.OkHttpWritableBuffer;
import aida.io.grpc.okhttp.OkHttpWritableBufferAllocator;
import aida.io.grpc.okhttp.OutboundFlowController;
import aida.io.grpc.okhttp.internal.framed.ErrorCode;
import aida.io.grpc.okhttp.internal.framed.Header;
import aida.io.perfmark.PerfMark;
import aida.io.perfmark.Tag;
import aida.io.perfmark.TaskCloseable;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import okio.Buffer;

class OkHttpServerStream
extends AbstractServerStream {
    private final String authority;
    private final TransportState state;
    private final Sink sink = new Sink();
    private final TransportTracer transportTracer;
    private final Attributes attributes;

    public OkHttpServerStream(TransportState state, Attributes transportAttrs, String authority, StatsTraceContext statsTraceCtx, TransportTracer transportTracer) {
        super(new OkHttpWritableBufferAllocator(), statsTraceCtx);
        this.state = (TransportState)Preconditions.checkNotNull((Object)state, (Object)"state");
        this.attributes = (Attributes)Preconditions.checkNotNull((Object)transportAttrs, (Object)"transportAttrs");
        this.authority = authority;
        this.transportTracer = (TransportTracer)Preconditions.checkNotNull((Object)transportTracer, (Object)"transportTracer");
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    @Override
    public int streamId() {
        return this.state.streamId;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    static class TransportState
    extends AbstractServerStream.TransportState
    implements OutboundFlowController.Stream,
    OkHttpServerTransport.StreamState {
        @GuardedBy(value="lock")
        private final OkHttpServerTransport transport;
        private final int streamId;
        private final int initialWindowSize;
        private final Object lock;
        @GuardedBy(value="lock")
        private boolean cancelSent = false;
        @GuardedBy(value="lock")
        private int window;
        @GuardedBy(value="lock")
        private int processedWindow;
        @GuardedBy(value="lock")
        private final ExceptionHandlingFrameWriter frameWriter;
        @GuardedBy(value="lock")
        private final OutboundFlowController outboundFlow;
        @GuardedBy(value="lock")
        private boolean receivedEndOfStream;
        private final Tag tag;
        private final OutboundFlowController.StreamState outboundFlowState;

        public TransportState(OkHttpServerTransport transport, int streamId, int maxMessageSize, StatsTraceContext statsTraceCtx, Object lock, ExceptionHandlingFrameWriter frameWriter, OutboundFlowController outboundFlow, int initialWindowSize, TransportTracer transportTracer, String methodName) {
            super(maxMessageSize, statsTraceCtx, transportTracer);
            this.transport = (OkHttpServerTransport)Preconditions.checkNotNull((Object)transport, (Object)"transport");
            this.streamId = streamId;
            this.lock = Preconditions.checkNotNull((Object)lock, (Object)"lock");
            this.frameWriter = frameWriter;
            this.outboundFlow = outboundFlow;
            this.window = initialWindowSize;
            this.processedWindow = initialWindowSize;
            this.initialWindowSize = initialWindowSize;
            this.tag = PerfMark.createTag(methodName);
            this.outboundFlowState = outboundFlow.createState(this, streamId);
        }

        @Override
        @GuardedBy(value="lock")
        public void deframeFailed(Throwable cause) {
            this.cancel(ErrorCode.INTERNAL_ERROR, Status.fromThrowable(cause));
        }

        @Override
        @GuardedBy(value="lock")
        public void bytesRead(int processedBytes) {
            this.processedWindow -= processedBytes;
            if ((float)this.processedWindow <= (float)this.initialWindowSize * 0.5f) {
                int delta = this.initialWindowSize - this.processedWindow;
                this.window += delta;
                this.processedWindow += delta;
                this.frameWriter.windowUpdate(this.streamId, delta);
                this.frameWriter.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @GuardedBy(value="lock")
        public void runOnTransportThread(Runnable r) {
            Object object = this.lock;
            synchronized (object) {
                r.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inboundDataReceived(Buffer frame, int dataLength, int paddingLength, boolean endOfStream) {
            Object object = this.lock;
            synchronized (object) {
                PerfMark.event("OkHttpServerTransport$FrameHandler.data", this.tag);
                if (endOfStream) {
                    this.receivedEndOfStream = true;
                }
                this.window -= dataLength + paddingLength;
                this.processedWindow -= paddingLength;
                super.inboundDataReceived(new OkHttpReadableBuffer(frame), endOfStream);
            }
        }

        @Override
        public void inboundRstReceived(Status status) {
            PerfMark.event("OkHttpServerTransport$FrameHandler.rstStream", this.tag);
            this.transportReportStatus(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasReceivedEndOfStream() {
            Object object = this.lock;
            synchronized (object) {
                return this.receivedEndOfStream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int inboundWindowAvailable() {
            Object object = this.lock;
            synchronized (object) {
                return this.window;
            }
        }

        @GuardedBy(value="lock")
        private void sendBuffer(Buffer buffer, boolean flush) {
            if (this.cancelSent) {
                return;
            }
            this.outboundFlow.data(false, this.outboundFlowState, buffer, flush);
        }

        @GuardedBy(value="lock")
        private void sendHeaders(List<Header> responseHeaders) {
            this.frameWriter.synReply(false, this.streamId, responseHeaders);
            this.frameWriter.flush();
        }

        @GuardedBy(value="lock")
        private void sendTrailers(List<Header> responseTrailers) {
            this.outboundFlow.notifyWhenNoPendingData(this.outboundFlowState, () -> this.sendTrailersAfterFlowControlled(responseTrailers));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendTrailersAfterFlowControlled(List<Header> responseTrailers) {
            Object object = this.lock;
            synchronized (object) {
                this.frameWriter.synReply(true, this.streamId, responseTrailers);
                if (!this.receivedEndOfStream) {
                    this.frameWriter.rstStream(this.streamId, ErrorCode.NO_ERROR);
                }
                this.transport.streamClosed(this.streamId, true);
                this.complete();
            }
        }

        @GuardedBy(value="lock")
        private void cancel(ErrorCode http2Error, Status reason) {
            if (this.cancelSent) {
                return;
            }
            this.cancelSent = true;
            this.frameWriter.rstStream(this.streamId, http2Error);
            this.transportReportStatus(reason);
            this.transport.streamClosed(this.streamId, true);
        }

        @Override
        public OutboundFlowController.StreamState getOutboundFlowState() {
            return this.outboundFlowState;
        }
    }

    class Sink
    implements AbstractServerStream.Sink {
        Sink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeHeaders(Metadata metadata, boolean flush) {
            try (TaskCloseable ignore = PerfMark.traceTask("OkHttpServerStream$Sink.writeHeaders");){
                List<Header> responseHeaders = Headers.createResponseHeaders(metadata);
                Object object = OkHttpServerStream.this.state.lock;
                synchronized (object) {
                    OkHttpServerStream.this.state.sendHeaders(responseHeaders);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeFrame(WritableBuffer frame, boolean flush, int numMessages) {
            try (TaskCloseable ignore = PerfMark.traceTask("OkHttpServerStream$Sink.writeFrame");){
                Buffer buffer = ((OkHttpWritableBuffer)frame).buffer();
                int size = (int)buffer.size();
                if (size > 0) {
                    OkHttpServerStream.this.onSendingBytes(size);
                }
                Object object = OkHttpServerStream.this.state.lock;
                synchronized (object) {
                    OkHttpServerStream.this.state.sendBuffer(buffer, flush);
                    OkHttpServerStream.this.transportTracer.reportMessageSent(numMessages);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTrailers(Metadata trailers, boolean headersSent, Status status) {
            try (TaskCloseable ignore = PerfMark.traceTask("OkHttpServerStream$Sink.writeTrailers");){
                List<Header> responseTrailers = Headers.createResponseTrailers(trailers, headersSent);
                Object object = OkHttpServerStream.this.state.lock;
                synchronized (object) {
                    OkHttpServerStream.this.state.sendTrailers(responseTrailers);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(Status reason) {
            try (TaskCloseable ignore = PerfMark.traceTask("OkHttpServerStream$Sink.cancel");){
                Object object = OkHttpServerStream.this.state.lock;
                synchronized (object) {
                    OkHttpServerStream.this.state.cancel(ErrorCode.CANCEL, reason);
                }
            }
        }
    }
}

