/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc;

import aida.io.grpc.Configurator;
import aida.io.grpc.ConfiguratorRegistry;
import aida.io.grpc.Internal;
import aida.io.grpc.InternalConfigurator;
import aida.io.grpc.ManagedChannelBuilder;
import aida.io.grpc.ServerBuilder;
import java.util.List;

@Internal
public final class InternalConfiguratorRegistry {
    private InternalConfiguratorRegistry() {
    }

    public static void setConfigurators(List<InternalConfigurator> configurators) {
        ConfiguratorRegistry.getDefaultRegistry().setConfigurators(configurators);
    }

    public static List<?> getConfigurators() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfigurators();
    }

    public static void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureChannelBuilder(channelBuilder);
        }
    }

    public static void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureServerBuilder(serverBuilder);
        }
    }

    public static boolean wasSetConfiguratorsCalled() {
        return ConfiguratorRegistry.getDefaultRegistry().wasSetConfiguratorsCalled();
    }
}

