/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.Interner;
import com.jetbrains.cidr.lang.OCExperimentalInterner;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class OCInterner<T>
extends Interner<T> {
    private static final boolean isExperimental = Boolean.getBoolean("cidr.memory.efficient.interner");
    private final ConcurrentMap<T, T> cache = isExperimental ? null : CollectionFactory.createConcurrentWeakKeyWeakValueMap();
    private final OCExperimentalInterner<T> experimentalInterner = isExperimental ? new OCExperimentalInterner() : null;

    @NotNull
    public T intern(@NotNull T value) {
        if (value == null) {
            OCInterner.$$$reportNull$$$0(0);
        }
        if (isExperimental) {
            T t = this.experimentalInterner.intern(value);
            if (t == null) {
                OCInterner.$$$reportNull$$$0(1);
            }
            return t;
        }
        Object internedValue = this.cache.get(value);
        if (internedValue != null) {
            Object v = internedValue;
            if (v == null) {
                OCInterner.$$$reportNull$$$0(2);
            }
            return (T)v;
        }
        T valueToIntern = this.valueToStore(value);
        Object object = ConcurrencyUtil.cacheOrGet(this.cache, valueToIntern, valueToIntern);
        if (object == null) {
            OCInterner.$$$reportNull$$$0(3);
        }
        return (T)object;
    }

    public void clear() {
        if (isExperimental) {
            this.experimentalInterner.clear();
        } else {
            this.cache.clear();
        }
    }

    @NotNull
    public Set<T> getValues() {
        if (isExperimental) {
            Set<T> set = this.experimentalInterner.getValues();
            if (set == null) {
                OCInterner.$$$reportNull$$$0(4);
            }
            return set;
        }
        return new HashSet(this.cache.values());
    }

    @NotNull
    protected T valueToStore(@NotNull T original) {
        if (original == null) {
            OCInterner.$$$reportNull$$$0(5);
        }
        T t = original;
        if (t == null) {
            OCInterner.$$$reportNull$$$0(6);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCInterner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCInterner";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "valueToStore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "valueToStore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

