/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose.intentions;

import com.android.tools.compose.intentions.ComposeSurroundWithWidgetActionKt;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H$J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/compose/intentions/ComposeSurroundWithWidgetAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "<init>", "()V", "getFamilyName", "", "startInWriteAction", "", "findSurroundableRange", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "getTemplate", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "invoke", "", "intellij.android.compose-ide-plugin"})
public abstract class ComposeSurroundWithWidgetAction
implements IntentionAction,
HighPriorityAction {
    @NotNull
    public String getFamilyName() {
        return "Compose Surround With Action";
    }

    public boolean startInWriteAction() {
        return true;
    }

    private final TextRange findSurroundableRange(PsiFile file, Editor editor) {
        Object object;
        if (editor.getSelectionModel().hasSelection()) {
            object = ComposeSurroundWithWidgetActionKt.findSurroundingSelectionRange(file, editor);
        } else {
            PsiElement psiElement = ComposeSurroundWithWidgetActionKt.access$findNearestSurroundableElement(file, editor.getCaretModel().getOffset());
            object = psiElement != null ? psiElement.getTextRange() : null;
        }
        return object;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return file == null || editor == null ? false : (!file.isWritable() || !(file instanceof KtFile) || ((KtFile)file).isScript() ? false : this.findSurroundableRange(file, editor) != null);
    }

    @Nullable
    protected abstract TemplateImpl getTemplate();

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || file == null) {
            return;
        }
        TextRange textRange = this.findSurroundableRange(file, editor);
        if (textRange == null) {
            return;
        }
        TextRange surroundRange = textRange;
        if (editor.getSelectionModel().getSelectionStart() != surroundRange.getStartOffset() || editor.getSelectionModel().getSelectionEnd() != surroundRange.getEndOffset()) {
            editor.getSelectionModel().setSelection(surroundRange.getStartOffset(), surroundRange.getEndOffset());
        }
        new InvokeTemplateAction(this.getTemplate(), editor, project, (Set)new HashSet()).perform();
    }
}

