/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose.formatting;

import com.android.tools.compose.ComposePluginUtilsKt;
import com.android.tools.compose.formatting.ComposeModifierProcessor;
import com.android.tools.compose.settings.ComposeCustomCodeStyleSettings;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/compose/formatting/ComposePostFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessor;", "<init>", "()V", "isAvailable", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "processElement", "source", "processText", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "intellij.android.compose-ide-plugin"})
public final class ComposePostFormatProcessor
implements PostFormatProcessor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAvailable(PsiElement psiElement, CodeStyleSettings settings) {
        if (!(psiElement.getContainingFile() instanceof KtFile)) return false;
        if (!ComposePluginUtilsKt.isComposeEnabled(psiElement)) return false;
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) return false;
        if (!((ComposeCustomCodeStyleSettings)settings.getCustomSettings(ComposeCustomCodeStyleSettings.class)).USE_CUSTOM_FORMATTING_FOR_MODIFIERS) return false;
        return true;
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return this.isAvailable(source, settings) ? new ComposeModifierProcessor(settings).process(source) : source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return this.isAvailable((PsiElement)source, settings) ? new ComposeModifierProcessor(settings).processText(source, rangeToReformat) : rangeToReformat;
    }
}

