/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.editor;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.editor.CMakeGoToTargetRenderer;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeArgumentImplMixin;
import com.jetbrains.cmake.psi.util.CMakeFileLocationUtil;
import com.jetbrains.cmake.psi.util.CMakeTargetUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class CMakeArgumentPresentation
implements ItemPresentation {
    private CMakeArgumentImplMixin myMixin;

    public CMakeArgumentPresentation(CMakeArgumentImplMixin mixin) {
        this.myMixin = mixin;
    }

    @NlsSafe
    @Nullable
    public String getPresentableText() {
        if (this.myMixin.isCommandDefinitionName()) {
            StringBuilder ret = new StringBuilder(this.myMixin.getLiteralNotNull().getText());
            ret.append('(');
            boolean appendedArguments = false;
            for (CMakeArgument nextArgument = this.myMixin.getNextArgument(); nextArgument != null; nextArgument = nextArgument.getNextArgument()) {
                ret.append(nextArgument.getText()).append(' ');
                appendedArguments = true;
            }
            if (appendedArguments) {
                ret.deleteCharAt(ret.length() - 1);
            }
            ret.append(')');
            return ret.toString();
        }
        if (this.myMixin.isCMakeTargetDefinitionName()) {
            return CMakeGoToTargetRenderer.getTargetDefinitionText(this.myMixin.getParentCommandArguments().getCommand());
        }
        return this.myMixin.getText();
    }

    @Nullable
    public String getLocationString() {
        return CMakeFileLocationUtil.getLocationInFile(this.myMixin, false);
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        Icon icon;
        if (this.myMixin.isFunctionName() || this.myMixin.isMacroName()) {
            return CMakeCompletionUtils.getRoutineIcon(this.myMixin.isFunctionName());
        }
        if (this.myMixin.isCMakeTargetDefinitionName() && (icon = CMakeTargetUtils.getTargetDefinitionIcon(this.myMixin)) != null) {
            return icon;
        }
        return null;
    }
}

