/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.consolereceiver.validator;

import com.google.services.firebase.consolereceiver.validator.RequestValidator;
import com.intellij.openapi.diagnostic.Logger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;

public class OriginRequestValidator
implements RequestValidator {
    private static final Logger LOGGER = Logger.getInstance(OriginRequestValidator.class);
    public final List<String> allowedOriginHosts;

    public OriginRequestValidator(@NotNull List<String> allowedOriginHosts) {
        this.allowedOriginHosts = allowedOriginHosts;
    }

    @Override
    public boolean isValid(HttpServletRequest request) {
        URI requestOriginUri;
        String requestOrigin = request.getHeader("origin");
        try {
            requestOriginUri = new URI(requestOrigin);
        }
        catch (NullPointerException | URISyntaxException e) {
            LOGGER.warn(String.format("Invalid request, couldn't parse \"origin\" header: \"%s\"", requestOrigin));
            return false;
        }
        return this.originHasHost(requestOriginUri, requestOrigin) && this.isOriginHostAllowed(requestOriginUri, requestOrigin);
    }

    private boolean originHasHost(URI requestOriginUri, String requestOrigin) {
        if (requestOriginUri.getHost() != null) {
            return true;
        }
        LOGGER.warn("Invalid request, \"origin\" header value is missing host: " + requestOrigin);
        return false;
    }

    private boolean isOriginHostAllowed(URI requestOriginUri, String requestOrigin) {
        if (this.allowedOriginHosts.contains(requestOriginUri.getHost())) {
            return true;
        }
        LOGGER.warn("Invalid request origin " + requestOrigin);
        return false;
    }
}

