/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.dependency;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.assistant.RecipeUtils;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseTutorialBundle;
import com.google.services.firebase.action.dependency.DependencyDialog;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.FirebaseContextDetails;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

public class AddDependencyAction
implements AssistActionHandler {
    protected static final String ACTION_KEY = "firebase.add_dependencies";

    private static Logger getLog() {
        return Logger.getInstance(AssistActionHandler.class);
    }

    @NotNull
    public String getId() {
        return ACTION_KEY;
    }

    public void handleAction(@NotNull ActionData actionData, @NotNull Project project) {
        if (!(actionData instanceof FirebaseTutorialBundle.Action)) {
            throw new RuntimeException("This should be impossible, malformed actiondata");
        }
        FirebaseTutorialBundle.Action castAction = (FirebaseTutorialBundle.Action)actionData;
        if (castAction.getRecipe() == null) {
            AddDependencyAction.getLog().error("No instructions found to add dependencies for " + actionData.getLabel());
            return;
        }
        DependencyDialog dependencyDialog = new DependencyDialog(castAction, project);
        dependencyDialog.pack();
        if (!dependencyDialog.showAndGet()) {
            return;
        }
        Module module = dependencyDialog.getModule();
        AddDependencyAction.getLog().info("Performing action " + actionData.getLabel() + " for module " + module.getName());
        RecipeUtils.execute((Function2)castAction.getRecipe(), (Module)module);
        for (String dependency : dependencyDialog.getDependenciesToBeApplied()) {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_DEPENDENCY_ADDED).withProject(project).withDetails(FirebaseContextDetails.newBuilder().setPerformedOn(dependency)).log();
        }
        GradleSyncInvoker.getInstance().requestProjectSync(module.getProject(), new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_ADDDEPENDENCYACTION_CALLED), new GradleSyncListener(this){

            public void syncSucceeded(@NotNull Project project) {
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
            }

            public void syncSkipped(@NotNull Project project) {
            }
        });
    }
}

