/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.DxLanguage;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.editor.OCEnterInBlockCommentHandler;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.settings.CidrCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DxEnterInBlockCommentHandler
extends OCEnterInBlockCommentHandler {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language;
        if (file == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(4);
        }
        if (!((language = EnterHandler.getLanguage((DataContext)dataContext)) instanceof DxLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return this.doProcessEnter(file, editor, caretAdvanceRef);
    }

    @NotNull
    protected EnterHandlerDelegate.Result doProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretAdvanceRef) {
        if (file == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(6);
        }
        if (caretAdvanceRef == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(7);
        }
        PsiFile topFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        Editor topEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)editor);
        int caretOffset = topEditor.getCaretModel().getOffset();
        if (topFile == null) {
            EnterHandlerDelegate.Result result = EnterHandlerDelegate.Result.Continue;
            if (result == null) {
                DxEnterInBlockCommentHandler.$$$reportNull$$$0(8);
            }
            return result;
        }
        EnterHandlerDelegate.Result result = super.doProcessEnter(topFile, topEditor, Ref.create((Object)caretOffset));
        if (result == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(9);
        }
        return result;
    }

    protected boolean shouldBeProcessed(HighlighterIterator it) {
        return super.shouldBeProcessed(it) && DoxygenUtil.isDoxygenBlockComment(it.getDocument().getCharsSequence().subSequence(it.getStart(), it.getEnd()).toString());
    }

    protected Pair<Integer, Integer> generateComment(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int caretInStringOffset, @NotNull StringBuilder result) {
        if (file == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(11);
        }
        if (commentText == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(12);
        }
        if (result == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(13);
        }
        result.append("* ");
        Project project = editor.getProject();
        String tagPrefix = DxEnterInBlockCommentHandler.getTagPrefix(file);
        boolean needSuffix = DxEnterInBlockCommentHandler.needCommentSuffixGeneration((PsiFile)file, (Editor)editor, (int)caretOffset, (String)commentText, ch -> "{}".indexOf(ch.charValue()) >= 0);
        if (needSuffix) {
            result.append(DxEnterInBlockCommentHandler.addBriefIfNeeded(editor, tagPrefix));
        }
        int newCaretPosition = caretOffset + result.length();
        if (commentText.startsWith("/**") || commentText.startsWith("/*!")) {
            Document document = editor.getDocument();
            if (project != null) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                document.insertString(caretOffset, (CharSequence)"*/");
                documentManager.commitDocument(document);
                PsiComment comment = DxEnterInBlockCommentHandler.findCommentAt(file, editor, caretOffset);
                if (!DoxygenUtil.hasNextDocCommentSibling(comment) && comment instanceof PsiDocCommentBase) {
                    PsiElement owner = ((PsiDocCommentBase)comment).getOwner();
                    String linePrefix = DxEnterInBlockCommentHandler.getIndentLine((Editor)editor, (int)caretOffset) + "*";
                    DxEnterInBlockCommentHandler.generateDocComment(owner, linePrefix, tagPrefix, result);
                }
                document.deleteString(caretOffset, caretOffset + 2);
                documentManager.commitDocument(document);
            }
        }
        int insertCommentSuffixPosition = -1;
        if (needSuffix) {
            insertCommentSuffixPosition = caretOffset + result.length();
        }
        return Pair.create((Object)insertCommentSuffixPosition, (Object)newCaretPosition);
    }

    @NotNull
    public static String addBriefIfNeeded(@NotNull Editor editor, @NotNull String tagPrefix) {
        if (editor == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(14);
        }
        if (tagPrefix == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(15);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)editor).getCustomSettings(OCCodeStyleSettings.class);
        if (settings.ADD_BRIEF_TAG) {
            String string = tagPrefix + DoxygenCmd.BRIEF.toString() + " ";
            if (string == null) {
                DxEnterInBlockCommentHandler.$$$reportNull$$$0(16);
            }
            return string;
        }
        return "";
    }

    public static void generateDocComment(@Nullable PsiElement owner, @NotNull String linePrefix, @NotNull String tagPrefix, @NotNull StringBuilder result) {
        if (linePrefix == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(17);
        }
        if (tagPrefix == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(18);
        }
        if (result == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(19);
        }
        if (owner == null) {
            return;
        }
        DoxygenUtil.traverseTemplateParametersList(owner, name -> DxEnterInBlockCommentHandler.appendLine(name, linePrefix, tagPrefix, DoxygenCmd.TPARAM, result));
        if (owner instanceof OCCallable) {
            OCSymbol symbol;
            OCCallable callable = (OCCallable)owner;
            List params = callable.getParameters();
            if (params != null) {
                for (PsiNamedElement param : params) {
                    String name2 = DoxygenUtil.getName(param.getName(), param);
                    DxEnterInBlockCommentHandler.appendLine(name2, linePrefix, tagPrefix, DoxygenCmd.PARAM, result);
                }
            }
            if ((symbol = callable.getSymbol()) != null && !symbol.getKind().isConstructorOrDestructor() && !callable.getReturnType().isVoid()) {
                result.append("\n").append(linePrefix).append(" ").append(tagPrefix).append(DoxygenCmd.RETURN).append(" ");
            }
        }
    }

    protected void flushChanges(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int commentStart, int caretInStringOffset, int insertCommentSuffixPosition, @NotNull StringBuilder indent) {
        if (file == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(21);
        }
        if (commentText == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(22);
        }
        if (indent == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(23);
        }
        Document document = editor.getDocument();
        int deleteTo = DxEnterInBlockCommentHandler.countWS(commentText, caretInStringOffset);
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            document.deleteString(caretOffset, commentStart + deleteTo);
        } else if (insertCommentSuffixPosition != -1) {
            insertCommentSuffixPosition += deleteTo - caretInStringOffset;
        }
        int lineEnd = commentText.indexOf(10) != -1 ? commentText.indexOf(10) : commentText.length();
        document.insertString(caretOffset, (CharSequence)indent);
        if (insertCommentSuffixPosition >= 0) {
            String contextIndent = DxEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext((Editor)editor, (int)caretOffset);
            String settingIndent = DxEnterInBlockCommentHandler.customSettingsIndent((Editor)editor);
            StringBuilder suffix = new StringBuilder().append('\n').append(contextIndent).append(settingIndent).append("*/");
            if (lineEnd > deleteTo) {
                suffix.append('\n').append(contextIndent);
            }
            document.insertString(insertCommentSuffixPosition, (CharSequence)suffix);
        }
    }

    public static int countWS(String commentText, int initValue) {
        while (initValue < commentText.length() && "\t ".indexOf(commentText.charAt(initValue)) >= 0) {
            ++initValue;
        }
        return initValue;
    }

    @Nullable
    public static PsiComment findCommentAt(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        if (file == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(24);
        }
        if (editor == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(25);
        }
        return (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)DxEnterInBlockCommentHandler.findElementAt(file, editor, caretOffset), (Class[])new Class[]{PsiComment.class});
    }

    @Nullable
    public static PsiElement findElementAt(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        if (file == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(26);
        }
        if (editor == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(27);
        }
        return file.findElementAt(caretOffset == editor.getDocument().getTextLength() && caretOffset > 0 ? caretOffset - 1 : caretOffset);
    }

    @NotNull
    private static String getTagPrefix(@NotNull PsiFile refFile) {
        if (refFile == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(28);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
        return settings.TAG_PREFIX_OF_BLOCK_COMMENT == CidrCodeStyleSettings.DocTagPrefix.AT ? "@" : "\\";
    }

    private static void appendLine(@NotNull String name, @NotNull String linePrefix, @NotNull String tagPrefix, @NotNull DoxygenCmd tag, @NotNull StringBuilder result) {
        if (name == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(29);
        }
        if (linePrefix == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(30);
        }
        if (tagPrefix == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(31);
        }
        if (tag == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(32);
        }
        if (result == null) {
            DxEnterInBlockCommentHandler.$$$reportNull$$$0(33);
        }
        if (!name.equals("<unnamed>")) {
            result.append("\n").append(linePrefix).append(" ").append(tagPrefix).append(tag).append(" ").append(name).append(" ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 14: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/DxEnterInBlockCommentHandler";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 13: 
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 18: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPrefix";
                break;
            }
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linePrefix";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/DxEnterInBlockCommentHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doProcessEnter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addBriefIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doProcessEnter";
                break;
            }
            case 8: 
            case 9: 
            case 16: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateComment";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addBriefIfNeeded";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateDocComment";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "flushChanges";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findCommentAt";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTagPrefix";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "appendLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 16 -> new IllegalStateException(string);
        };
    }
}

