/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import com.android.tools.profiler.asm.ClassVisitor;
import com.android.tools.profiler.asm.MethodVisitor;
import com.android.tools.profiler.asm.Opcodes;

final class InitializerAdapter
extends ClassVisitor
implements Opcodes {
    public static final String ANDROID_APPLICATION = "android/app/Application";
    public static final String ANDROID_ACTIVITY = "android/app/Activity";
    public static final String PROFILER_APPLICATION_CLASSNAME = "com/android/tools/profiler/support/ProfilerService";
    private static final String SERVICE_ADDRESS_PROPERTY = "profiler.service.address";
    private String superName;
    private final boolean myUnifiedPipeline;
    private final boolean myKeyboardEventEnabled;

    public InitializerAdapter(ClassVisitor classVisitor, boolean unifiedPipeline, boolean keyboardEvent) {
        super(589824, classVisitor);
        this.myUnifiedPipeline = unifiedPipeline;
        this.myKeyboardEventEnabled = keyboardEvent;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superName = superName;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((this.superName.equals(ANDROID_ACTIVITY) || this.superName.equals(ANDROID_APPLICATION)) && name.equals("<init>")) {
            return new MethodAdapter(mv, this.myUnifiedPipeline, this.myKeyboardEventEnabled);
        }
        return mv;
    }

    private static final class MethodAdapter
    extends MethodVisitor
    implements Opcodes {
        private final boolean myUnifiedPipeline;
        private final boolean myKeyboardEventEnabled;

        public MethodAdapter(MethodVisitor mv, boolean unifiedPipeline, boolean keyboardEvent) {
            super(589824, mv);
            this.myUnifiedPipeline = unifiedPipeline;
            this.myKeyboardEventEnabled = keyboardEvent;
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    super.visitLdcInsn(InitializerAdapter.SERVICE_ADDRESS_PROPERTY);
                    super.visitLdcInsn(this.myUnifiedPipeline ? 1 : 0);
                    super.visitLdcInsn(this.myKeyboardEventEnabled ? 1 : 0);
                    super.visitMethodInsn(184, InitializerAdapter.PROFILER_APPLICATION_CLASSNAME, "initialize", "(Ljava/lang/String;ZZ)V", false);
                }
            }
            super.visitInsn(opcode);
        }
    }
}

