/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.settings;

import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRecorderSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final TestRecorderSettings mySettings;
    private JPanel myPanel;
    private JSpinner myEvaluationDepthSpinner;
    private JSpinner myScrollDepthSpinner;
    private JSpinner myAssertionDepthSpinner;
    private JCheckBox myCapEvaluationDepthCheckBox;
    private JCheckBox myCleanBeforeStartCheckbox;
    private JCheckBox myCleanAfterFinishCheckbox;
    private JCheckBox myStopAppCheckbox;
    private JPanel myLaunchAndTearDownSettingsPanel;
    private JPanel myDataCollecationAndCodeGenerationSettingsPanel;
    private JCheckBox myUseTextForElementMatchingCheckBox;
    private JCheckBox myUseContentDescriptionForElementMatchingCheckBox;
    private JCheckBox myEnableTestFragmentRecordingCheckBox;

    public TestRecorderSettingsConfigurable() {
        this.setupUI();
        this.mySettings = TestRecorderSettings.getInstance();
    }

    @NotNull
    public String getId() {
        return "test.recorder";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Espresso Test Recorder";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        this.myDataCollecationAndCodeGenerationSettingsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Data collection and code generation settings", (boolean)false, (Insets)new Insets(7, 0, 0, 0)));
        this.myLaunchAndTearDownSettingsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Launch and tear down settings", (boolean)false, (Insets)new Insets(7, 0, 0, 0)));
        this.myCleanAfterFinishCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestRecorderSettingsConfigurable.this.updateDependentCheckboxes();
            }
        });
        return this.myPanel;
    }

    private void updateDependentCheckboxes() {
        if (this.myCleanAfterFinishCheckbox.isSelected()) {
            this.myStopAppCheckbox.setSelected(true);
            this.myStopAppCheckbox.setEnabled(false);
        } else {
            this.myStopAppCheckbox.setEnabled(true);
        }
    }

    public boolean isModified() {
        Integer evaluationDepth = this.getSpinnerValue(this.myEvaluationDepthSpinner);
        Integer scrollDepth = this.getSpinnerValue(this.myScrollDepthSpinner);
        Integer assertionDepth = this.getSpinnerValue(this.myAssertionDepthSpinner);
        return evaluationDepth != null && this.mySettings.EVALUATION_DEPTH != evaluationDepth || scrollDepth != null && this.mySettings.SCROLL_DEPTH != scrollDepth || assertionDepth != null && this.mySettings.ASSERTION_DEPTH != assertionDepth || this.mySettings.CAP_AT_NON_IDENTIFIABLE_ELEMENTS != this.myCapEvaluationDepthCheckBox.isSelected() || this.mySettings.USE_TEXT_FOR_ELEMENT_MATCHING != this.myUseTextForElementMatchingCheckBox.isSelected() || this.mySettings.USE_CONTENT_DESCRIPTION_FOR_ELEMENT_MATCHING != this.myUseContentDescriptionForElementMatchingCheckBox.isSelected() || this.mySettings.ENABLE_TEST_FRAGMENT_RECORDING != this.myEnableTestFragmentRecordingCheckBox.isSelected() || this.mySettings.CLEAN_BEFORE_START != this.myCleanBeforeStartCheckbox.isSelected() || this.mySettings.CLEAN_AFTER_FINISH != this.myCleanAfterFinishCheckbox.isSelected() || this.mySettings.STOP_APP_AFTER_RECORDING != this.myStopAppCheckbox.isSelected();
    }

    public void apply() throws ConfigurationException {
        Integer assertionDepth;
        Integer scrollDepth;
        Integer evaluationDepth = this.getSpinnerValue(this.myEvaluationDepthSpinner);
        if (evaluationDepth != null) {
            this.mySettings.EVALUATION_DEPTH = evaluationDepth;
        }
        if ((scrollDepth = this.getSpinnerValue(this.myScrollDepthSpinner)) != null) {
            this.mySettings.SCROLL_DEPTH = scrollDepth;
        }
        if ((assertionDepth = this.getSpinnerValue(this.myAssertionDepthSpinner)) != null) {
            this.mySettings.ASSERTION_DEPTH = assertionDepth;
        }
        this.mySettings.CAP_AT_NON_IDENTIFIABLE_ELEMENTS = this.myCapEvaluationDepthCheckBox.isSelected();
        this.mySettings.USE_TEXT_FOR_ELEMENT_MATCHING = this.myUseTextForElementMatchingCheckBox.isSelected();
        this.mySettings.USE_CONTENT_DESCRIPTION_FOR_ELEMENT_MATCHING = this.myUseContentDescriptionForElementMatchingCheckBox.isSelected();
        this.mySettings.ENABLE_TEST_FRAGMENT_RECORDING = this.myEnableTestFragmentRecordingCheckBox.isSelected();
        this.mySettings.CLEAN_BEFORE_START = this.myCleanBeforeStartCheckbox.isSelected();
        this.mySettings.CLEAN_AFTER_FINISH = this.myCleanAfterFinishCheckbox.isSelected();
        this.mySettings.STOP_APP_AFTER_RECORDING = this.myStopAppCheckbox.isSelected();
    }

    public void reset() {
        this.myEvaluationDepthSpinner.setValue(this.mySettings.EVALUATION_DEPTH);
        this.myScrollDepthSpinner.setValue(this.mySettings.SCROLL_DEPTH);
        this.myAssertionDepthSpinner.setValue(this.mySettings.ASSERTION_DEPTH);
        this.myCapEvaluationDepthCheckBox.setSelected(this.mySettings.CAP_AT_NON_IDENTIFIABLE_ELEMENTS);
        this.myUseTextForElementMatchingCheckBox.setSelected(this.mySettings.USE_TEXT_FOR_ELEMENT_MATCHING);
        this.myUseContentDescriptionForElementMatchingCheckBox.setSelected(this.mySettings.USE_CONTENT_DESCRIPTION_FOR_ELEMENT_MATCHING);
        this.myEnableTestFragmentRecordingCheckBox.setSelected(this.mySettings.ENABLE_TEST_FRAGMENT_RECORDING);
        this.myCleanBeforeStartCheckbox.setSelected(this.mySettings.CLEAN_BEFORE_START);
        this.myCleanAfterFinishCheckbox.setSelected(this.mySettings.CLEAN_AFTER_FINISH);
        this.myStopAppCheckbox.setSelected(this.mySettings.STOP_APP_AFTER_RECORDING);
        this.updateDependentCheckboxes();
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        TestRecorderSettings testRecorderSettings = TestRecorderSettings.getInstance();
        this.myEvaluationDepthSpinner = new JSpinner(new SpinnerNumberModel(testRecorderSettings.EVALUATION_DEPTH, 1, 20, 1));
        this.forceToAcceptNumbersOnly(this.myEvaluationDepthSpinner);
        this.myScrollDepthSpinner = new JSpinner(new SpinnerNumberModel(testRecorderSettings.SCROLL_DEPTH, 1, 20, 1));
        this.forceToAcceptNumbersOnly(this.myScrollDepthSpinner);
        this.myAssertionDepthSpinner = new JSpinner(new SpinnerNumberModel(testRecorderSettings.ASSERTION_DEPTH, 1, 20, 1));
        this.forceToAcceptNumbersOnly(this.myAssertionDepthSpinner);
    }

    @Nullable
    private Integer getSpinnerValue(JSpinner spinner) {
        Object value = spinner.getValue();
        return value instanceof Integer ? (Integer)value : null;
    }

    private void forceToAcceptNumbersOnly(JSpinner spinner) {
        JFormattedTextField.AbstractFormatter formatter;
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.NumberEditor && (formatter = ((JSpinner.NumberEditor)editor).getTextField().getFormatter()) instanceof NumberFormatter) {
            ((NumberFormatter)formatter).setAllowsInvalid(false);
        }
    }

    private void setupUI() {
        this.createUIComponents();
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("<html><b>Warning:</b> changing these settings could affect the performance of Test Recorder, or impact the quality of the recorded tests.</html>");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 4, 0, 1, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        this.myPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 4, 0, 0, 0, 0, null, null, null, 0, false));
        this.myDataCollecationAndCodeGenerationSettingsPanel = new JPanel();
        this.myDataCollecationAndCodeGenerationSettingsPanel.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)this.myDataCollecationAndCodeGenerationSettingsPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Max UI depth");
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1, false));
        Spacer spacer1 = new Spacer();
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)spacer1, new GridConstraints(0, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("ScrollView detection depth");
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1, false));
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)this.myScrollDepthSpinner, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)this.myEvaluationDepthSpinner, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Assertion depth");
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1, false));
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)this.myAssertionDepthSpinner, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myCapEvaluationDepthCheckBox = new JCheckBox();
        this.myCapEvaluationDepthCheckBox.setSelected(true);
        this.myCapEvaluationDepthCheckBox.setText("Limit max depth to identifiable elements");
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)this.myCapEvaluationDepthCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myUseTextForElementMatchingCheckBox = new JCheckBox();
        this.myUseTextForElementMatchingCheckBox.setSelected(true);
        this.myUseTextForElementMatchingCheckBox.setText("Use text for element matching");
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)this.myUseTextForElementMatchingCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myUseContentDescriptionForElementMatchingCheckBox = new JCheckBox();
        this.myUseContentDescriptionForElementMatchingCheckBox.setSelected(true);
        this.myUseContentDescriptionForElementMatchingCheckBox.setText("Use content description for element matching");
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)this.myUseContentDescriptionForElementMatchingCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myEnableTestFragmentRecordingCheckBox = new JCheckBox();
        this.myEnableTestFragmentRecordingCheckBox.setText("Enable test fragment recording");
        this.myDataCollecationAndCodeGenerationSettingsPanel.add((Component)this.myEnableTestFragmentRecordingCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myLaunchAndTearDownSettingsPanel = new JPanel();
        this.myLaunchAndTearDownSettingsPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)this.myLaunchAndTearDownSettingsPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myCleanBeforeStartCheckbox = new JCheckBox();
        this.myCleanBeforeStartCheckbox.setSelected(true);
        this.myCleanBeforeStartCheckbox.setText("Clear app data before recording");
        this.myLaunchAndTearDownSettingsPanel.add((Component)this.myCleanBeforeStartCheckbox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myLaunchAndTearDownSettingsPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myCleanAfterFinishCheckbox = new JCheckBox();
        this.myCleanAfterFinishCheckbox.setSelected(true);
        this.myCleanAfterFinishCheckbox.setText("Clear app data after recording");
        this.myLaunchAndTearDownSettingsPanel.add((Component)this.myCleanAfterFinishCheckbox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myStopAppCheckbox = new JCheckBox();
        this.myStopAppCheckbox.setEnabled(false);
        this.myStopAppCheckbox.setSelected(true);
        this.myStopAppCheckbox.setText("Exit app after recording");
        this.myLaunchAndTearDownSettingsPanel.add((Component)this.myStopAppCheckbox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myPanel.add((Component)spacer3, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
    }
}

