/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.internal.algorithm;

import java.util.Collection;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.eclipse.elk.core.options.PortAlignment;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.core.util.nodespacing.internal.NodeContext;
import org.eclipse.elk.core.util.nodespacing.internal.PortContext;
import org.eclipse.elk.core.util.nodespacing.internal.algorithm.HorizontalPortPlacementSizeCalculator;
import org.eclipse.elk.core.util.nodespacing.internal.algorithm.NodeLabelAndSizeUtilities;
import org.eclipse.elk.core.util.nodespacing.internal.algorithm.PortPlacementCalculator;

public final class VerticalPortPlacementSizeCalculator {
    private VerticalPortPlacementSizeCalculator() {
    }

    public static void calculateVerticalPortPlacementSize(NodeContext nodeContext) {
        switch (nodeContext.portConstraints) {
            case FIXED_POS: {
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFixedPosPorts(nodeContext, PortSide.EAST);
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFixedPosPorts(nodeContext, PortSide.WEST);
                break;
            }
            case FIXED_RATIO: {
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFixedRatioPorts(nodeContext, PortSide.EAST);
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFixedRatioPorts(nodeContext, PortSide.WEST);
                break;
            }
            default: {
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFreePorts(nodeContext, PortSide.EAST);
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFreePorts(nodeContext, PortSide.WEST);
            }
        }
    }

    private static void calculateVerticalNodeSizeRequiredByFixedPosPorts(NodeContext nodeContext, PortSide portSide) {
        double bottommostPortBorder = 0.0;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            bottommostPortBorder = Math.max(bottommostPortBorder, portContext.portPosition.y + portContext.port.getSize().y);
        }
        AtomicCell cell = nodeContext.insidePortLabelCells.get((Object)portSide);
        cell.getPadding().top = 0.0;
        cell.getMinimumContentAreaSize().y = bottommostPortBorder;
    }

    private static void calculateVerticalNodeSizeRequiredByFixedRatioPorts(NodeContext nodeContext, PortSide portSide) {
        AtomicCell cell = nodeContext.insidePortLabelCells.get((Object)portSide);
        Collection portContexts = nodeContext.portContexts.get((Object)portSide);
        if (portContexts.isEmpty()) {
            cell.getPadding().top = 0.0;
            cell.getPadding().bottom = 0.0;
            return;
        }
        boolean includePortLabels = nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORT_LABELS);
        boolean spaceEfficientPortLabels = nodeContext.sizeOptions.contains((Object)SizeOptions.SPACE_EFFICIENT_PORT_LABELS);
        boolean portLabelsInside = nodeContext.portLabelsPlacement == PortLabelPlacement.INSIDE;
        double minHeight = 0.0;
        Iterator portContextIterator = portContexts.iterator();
        PortContext previousPortContext = null;
        double previousPortRatio = 0.0;
        double previousPortHeight = 0.0;
        while (portContextIterator.hasNext()) {
            PortContext currentPortContext = (PortContext)portContextIterator.next();
            double currentPortRatio = currentPortContext.port.getProperty(PortPlacementCalculator.PORT_RATIO_OR_POSITION);
            double currentPortHeight = currentPortContext.port.getSize().y;
            if (includePortLabels) {
                VerticalPortPlacementSizeCalculator.setVerticalPortMargins(nodeContext, portSide, 0.0, portLabelsInside, !portLabelsInside && spaceEfficientPortLabels);
            }
            if (previousPortContext == null) {
                if (nodeContext.surroundingPortMargins != null && nodeContext.surroundingPortMargins.top > 0.0) {
                    minHeight = Math.max(minHeight, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(nodeContext.surroundingPortMargins.top + currentPortContext.portMargin.top, 0.0, currentPortRatio));
                }
            } else {
                double requiredSpace = previousPortHeight + previousPortContext.portMargin.bottom + nodeContext.portPortSpacing + currentPortContext.portMargin.top;
                minHeight = Math.max(minHeight, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(requiredSpace, previousPortRatio, currentPortRatio));
            }
            previousPortContext = currentPortContext;
            previousPortRatio = currentPortRatio;
            previousPortHeight = currentPortHeight;
        }
        if (nodeContext.surroundingPortMargins != null && nodeContext.surroundingPortMargins.bottom > 0.0) {
            double requiredSpace = previousPortHeight + nodeContext.surroundingPortMargins.bottom;
            if (portLabelsInside) {
                requiredSpace += previousPortContext.portMargin.bottom;
            }
            minHeight = Math.max(minHeight, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(requiredSpace, previousPortRatio, 1.0));
        }
        cell.getPadding().top = 0.0;
        cell.getMinimumContentAreaSize().y = minHeight;
    }

    private static void calculateVerticalNodeSizeRequiredByFreePorts(NodeContext nodeContext, PortSide portSide) {
        AtomicCell cell = nodeContext.insidePortLabelCells.get((Object)portSide);
        if (nodeContext.portContexts.get((Object)portSide).isEmpty()) {
            cell.getPadding().top = 0.0;
            cell.getPadding().bottom = 0.0;
            return;
        }
        cell.getPadding().top = nodeContext.surroundingPortMargins.top;
        cell.getPadding().bottom = nodeContext.surroundingPortMargins.bottom;
        boolean includePortLabels = nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORT_LABELS);
        boolean twoPorts = nodeContext.portContexts.get((Object)portSide).size() == 2;
        boolean portLabelsOutside = nodeContext.portLabelsPlacement == PortLabelPlacement.OUTSIDE;
        boolean spaceEfficientPortLabels = nodeContext.sizeOptions.contains((Object)SizeOptions.SPACE_EFFICIENT_PORT_LABELS);
        boolean uniformPortSpacing = nodeContext.sizeOptions.contains((Object)SizeOptions.UNIFORM_PORT_SPACING);
        double height = 0.0;
        if (!includePortLabels || twoPorts && portLabelsOutside) {
            height = VerticalPortPlacementSizeCalculator.portHeightPlusPortPortSpacing(nodeContext, portSide, false, false);
        } else if (portLabelsOutside) {
            if (uniformPortSpacing) {
                double maxLabelHeight = VerticalPortPlacementSizeCalculator.maximumPortLabelHeight(nodeContext, portSide, spaceEfficientPortLabels);
                if (maxLabelHeight > 0.0) {
                    VerticalPortPlacementSizeCalculator.setVerticalPortMargins(nodeContext, portSide, maxLabelHeight, false, false);
                }
                height = VerticalPortPlacementSizeCalculator.portHeightPlusPortPortSpacing(nodeContext, portSide, true, false);
            } else {
                VerticalPortPlacementSizeCalculator.setVerticalPortMargins(nodeContext, portSide, 0.0, false, spaceEfficientPortLabels);
                height = VerticalPortPlacementSizeCalculator.portHeightPlusPortPortSpacing(nodeContext, portSide, true, false);
            }
        } else if (!portLabelsOutside) {
            if (uniformPortSpacing) {
                int ports = nodeContext.portContexts.get((Object)portSide).size();
                double maxPortAndLabelHeight = VerticalPortPlacementSizeCalculator.maximumPortAndLabelHeight(nodeContext, portSide);
                height = maxPortAndLabelHeight * (double)ports + nodeContext.portPortSpacing * (double)(ports - 1);
                if (maxPortAndLabelHeight > 0.0) {
                    VerticalPortPlacementSizeCalculator.setVerticalPortMargins(nodeContext, portSide, maxPortAndLabelHeight, true, false);
                }
            } else {
                VerticalPortPlacementSizeCalculator.setVerticalPortMargins(nodeContext, portSide, 0.0, true, false);
                height = VerticalPortPlacementSizeCalculator.portHeightPlusPortPortSpacing(nodeContext, portSide, true, true);
            }
        } else assert (false);
        if (nodeContext.getPortAlignment(portSide) == PortAlignment.DISTRIBUTED) {
            height += 2.0 * nodeContext.portPortSpacing;
        }
        cell.getMinimumContentAreaSize().y = height;
    }

    private static double maximumPortLabelHeight(NodeContext nodeContext, PortSide portSide, boolean ignoreFirstPort) {
        boolean ignore = ignoreFirstPort;
        PrimitiveIterator.OfDouble labelCellHeights = nodeContext.portContexts.get((Object)portSide).stream().mapToDouble(portContext -> portContext.portLabelCell == null ? 0.0 : portContext.portLabelCell.getMinimumHeight()).iterator();
        double maxLabelHeight = 0.0;
        while (labelCellHeights.hasNext()) {
            if (ignore) {
                labelCellHeights.nextDouble();
                ignore = false;
                continue;
            }
            double currLabelHeight = labelCellHeights.nextDouble();
            if (!labelCellHeights.hasNext()) continue;
            maxLabelHeight = Math.max(maxLabelHeight, currLabelHeight);
        }
        return maxLabelHeight;
    }

    private static double maximumPortAndLabelHeight(NodeContext nodeContext, PortSide portSide) {
        double maxResult = 0.0;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            double labelHeight = portContext.portLabelCell.getMinimumHeight();
            if (NodeLabelAndSizeUtilities.effectiveCompoundNodeMode(portContext)) {
                maxResult = Math.max(maxResult, labelHeight);
                maxResult = Math.max(maxResult, portContext.port.getSize().y);
                continue;
            }
            double labelPlusPortHeight = portContext.port.getSize().y + nodeContext.portLabelSpacing + labelHeight;
            maxResult = Math.max(maxResult, labelPlusPortHeight);
        }
        return maxResult;
    }

    private static double portHeightPlusPortPortSpacing(NodeContext nodeContext, PortSide portSide, boolean includeMargins, boolean includeMarginsOfLastPort) {
        double result = 0.0;
        Iterator portContextIterator = nodeContext.portContexts.get((Object)portSide).iterator();
        while (portContextIterator.hasNext()) {
            PortContext portContext = (PortContext)portContextIterator.next();
            result += portContext.port.getSize().y;
            if (includeMargins && (portContextIterator.hasNext() || includeMarginsOfLastPort)) {
                result += portContext.portMargin.top + portContext.portMargin.bottom;
            }
            if (!portContextIterator.hasNext()) continue;
            result += nodeContext.portPortSpacing;
        }
        return result;
    }

    private static void setVerticalPortMargins(NodeContext nodeContext, PortSide portSide, double uniformLabelHeight, boolean insidePortLabels, boolean excludeFirstPort) {
        boolean exclude = excludeFirstPort;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            double overhang;
            if (exclude) {
                exclude = false;
                continue;
            }
            double labelHeight = 0.0;
            if (uniformLabelHeight > 0.0) {
                labelHeight = uniformLabelHeight;
            } else if (portContext.portLabelCell != null) {
                labelHeight = portContext.portLabelCell.getMinimumHeight();
            }
            if (!(labelHeight > 0.0)) continue;
            if (insidePortLabels && NodeLabelAndSizeUtilities.effectiveCompoundNodeMode(portContext)) {
                portContext.portMargin.bottom = nodeContext.portLabelSpacing + labelHeight;
                continue;
            }
            double portHeight = portContext.port.getSize().y;
            if (!(labelHeight > portHeight)) continue;
            portContext.portMargin.top = overhang = (labelHeight - portHeight) / 2.0;
            portContext.portMargin.bottom = overhang;
        }
    }
}

