/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangFormatChangeSettingsProvider {
    public static final ExtensionPointName<ClangFormatChangeSettingsProvider> CLANG_FORMAT_PROVIDER = ExtensionPointName.create((String)"com.intellij.clangFormatProvider");
    @NonNls
    public static final String CFC_NO_LANGUAGE_SERVICE_FUTURE = ClangFormatFileUtils.getErrorStyleFor("no `clangd` server future.");
    @NonNls
    public static final String CFC_WRONG_SERVICE_FUTURE_RESPOND = ClangFormatFileUtils.getErrorStyleFor("unpredictable respond from `clangd` server future.");
    @NonNls
    public static final String CFC_NO_CONTEXT_FUTURE = ClangFormatFileUtils.getErrorStyleFor("`clangd` crash or error respond while reading `.clang-format`.");
    @NonNls
    public static final String CFC_WRONG_CONTEXT_FUTURE_RESPOND = ClangFormatFileUtils.getErrorStyleFor("unpredictable respond from `clangd` about content of `.clang-format`.");
    @NonNls
    public static final String CFK_BreakBeforeBraces = "BreakBeforeBraces";
    @NonNls
    public static final String CFK_AfterClass = "AfterClass";
    @NonNls
    public static final String CFK_AfterControlStatement = "AfterControlStatement";
    @NonNls
    public static final String CFK_AfterEnum = "AfterEnum";
    @NonNls
    public static final String CFK_AfterFunction = "AfterFunction";
    @NonNls
    public static final String CFK_AfterNamespace = "AfterNamespace";
    @NonNls
    public static final String CFK_AfterObjCDeclaration = "AfterObjCDeclaration";
    @NonNls
    public static final String CFK_AfterStruct = "AfterStruct";
    @NonNls
    public static final String CFK_AfterUnion = "AfterUnion";
    @NonNls
    public static final String CFK_AfterExternBlock = "AfterExternBlock";
    @NonNls
    public static final String CFK_BeforeCatch = "BeforeCatch";
    @NonNls
    public static final String CFK_BeforeElse = "BeforeElse";
    @NonNls
    public static final String CFK_IndentBraces = "IndentBraces";
    @NonNls
    public static final String CFK_SplitEmptyFunction = "SplitEmptyFunction";
    @NonNls
    public static final String CFK_SplitEmptyRecord = "SplitEmptyRecord";
    @NonNls
    public static final String CFK_SplitEmptyNamespace = "SplitEmptyNamespace";
    @NonNls
    public static final String CFK_MaxEmptyLinesToKeep = "MaxEmptyLinesToKeep";
    @NonNls
    public static final String CFK_KEEP_EMPTY_LINES_AT_THE_START_OF_BLOCKS = "KeepEmptyLinesAtTheStartOfBlocks";
    @NonNls
    public static final String CFK_ColumnLimit = "ColumnLimit";
    @NonNls
    public static final String CFK_IndentWidth = "IndentWidth";
    @NonNls
    public static final String CFK_ObjCBlockIndentWidth = "ObjCBlockIndentWidth";
    @NonNls
    public static final String CFK_ContinuationIndentWidth = "ContinuationIndentWidth";
    @NonNls
    public static final String CFK_TabWidth = "TabWidth";
    @NonNls
    public static final String CFK_UseTab = "UseTab";
    @NonNls
    public static final String CFK_AccessModifierOffset = "AccessModifierOffset";
    @NonNls
    public static final String CFK_IndentCaseLabels = "IndentCaseLabels";
    @NonNls
    public static final String CFK_NamespaceIndentation = "NamespaceIndentation";
    @NonNls
    public static final String CFV_Custom = "Custom";
    @NonNls
    public static final String CFV_Never = "Never";
    @NonNls
    public static final String CFV_Always = "Always";
    @NonNls
    public static final String CFV_None = "None";
    @NonNls
    public static final String CFV_Inner = "Inner";
    @NonNls
    public static final String CFV_All = "All";

    @Nullable
    public static ClangFormatChangeSettingsProvider findApplicableFormatProvider(@NotNull Project project, @NotNull FileType language) {
        if (project == null) {
            ClangFormatChangeSettingsProvider.$$$reportNull$$$0(0);
        }
        if (language == null) {
            ClangFormatChangeSettingsProvider.$$$reportNull$$$0(1);
        }
        for (ClangFormatChangeSettingsProvider extension : CLANG_FORMAT_PROVIDER.getExtensionList()) {
            if (!extension.isApplicable(project, language)) continue;
            return extension;
        }
        return null;
    }

    @NotNull
    public static String convertCurrentCodeStyleToClangFormat(@Nullable Project project, @NotNull CodeStyleSettings style) {
        if (style == null) {
            ClangFormatChangeSettingsProvider.$$$reportNull$$$0(2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ClangFormatChangeSettingsProvider extension : CLANG_FORMAT_PROVIDER.getExtensionList()) {
            String options = extension.convertCodeStyleToClangFormat(project, style);
            if (options.isEmpty()) continue;
            stringBuilder.append(options);
            break;
        }
        String string = stringBuilder.toString();
        if (string == null) {
            ClangFormatChangeSettingsProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void syncCurrentClangFormatSettings(@NotNull Project project, @NotNull CodeStyleSettings settings, boolean changeFromWidget) {
        if (project == null) {
            ClangFormatChangeSettingsProvider.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            ClangFormatChangeSettingsProvider.$$$reportNull$$$0(5);
        }
        for (ClangFormatChangeSettingsProvider extension : CLANG_FORMAT_PROVIDER.getExtensionList()) {
            extension.syncClangFormatSettings(project, settings, changeFromWidget);
        }
    }

    @Nullable
    public static Consumer<CodeStyleSettings> getCurrentDisablingFunction(@NotNull Project project) {
        if (project == null) {
            ClangFormatChangeSettingsProvider.$$$reportNull$$$0(6);
        }
        for (ClangFormatChangeSettingsProvider extension : CLANG_FORMAT_PROVIDER.getExtensionList()) {
            Consumer<CodeStyleSettings> switcherOff = extension.getDisablingFunction(project);
            if (switcherOff == null) continue;
            return switcherOff;
        }
        return null;
    }

    @Nullable
    public static AnAction getCurrentActivatingAction(@NotNull PsiFile psiFile) {
        ClangFormatChangeSettingsProvider provider;
        if (psiFile == null) {
            ClangFormatChangeSettingsProvider.$$$reportNull$$$0(7);
        }
        if ((provider = ClangFormatChangeSettingsProvider.findApplicableFormatProvider(psiFile.getProject(), psiFile.getFileType())) != null && provider.isActive(psiFile.getProject(), psiFile.getFileType())) {
            return provider.getActivatingAction(psiFile);
        }
        return null;
    }

    public AnAction getActivatingAction(@NotNull PsiFile var1);

    @Nullable
    public Consumer<CodeStyleSettings> getDisablingFunction(@NotNull Project var1);

    @NonNls
    @NotNull
    public String findClangFormatContent(@NotNull Project var1, @NotNull VirtualFile var2);

    public VirtualFile extractClangFormatFile(@NotNull String var1);

    public boolean applyCollectedSettings(@NotNull TransientCodeStyleSettings var1, @NotNull PsiFile var2, @NotNull Map<String, Object> var3);

    @NonNls
    @NotNull
    public String convertCodeStyleToClangFormat(@Nullable Project var1, @NotNull CodeStyleSettings var2);

    public void syncClangFormatSettings(@NotNull Project var1, @NotNull CodeStyleSettings var2, boolean var3);

    public boolean isApplicable(@NotNull Project var1, @NotNull FileType var2);

    public boolean isActive(@NotNull Project var1, @NotNull FileType var2);

    @Nullable
    public TextRange format(@NotNull PsiFile var1, @NotNull TextRange var2, @Nullable String var3, boolean var4, boolean var5, boolean var6, int var7);

    @Nullable
    public String indent(@NotNull PsiFile var1, int var2, @Nullable String var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangFormatChangeSettingsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangFormatChangeSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertCurrentCodeStyleToClangFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableFormatProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertCurrentCodeStyleToClangFormat";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "syncCurrentClangFormatSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDisablingFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentActivatingAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

