/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.android.tools.idea.gradle.model.impl.IdeModuleWellKnownSourceSet;
import com.android.tools.idea.gradle.project.sync.IdeAndroidModels;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.Order;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.configure.KotlinAndroidMPPGradleProjectResolverKt;
import org.jetbrains.kotlin.idea.gradle.configuration.KotlinSourceSetData;
import org.jetbrains.kotlin.idea.gradle.configuration.KotlinSourceSetInfo;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinMppGradleProjectResolver;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinMppGradleProjectResolverKt;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinMPPGradleModel;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinMPPGradleModelBuilder;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinSourceSetContainer;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinSourceSetContainerKt;
import org.jetbrains.kotlin.idea.projectModel.KotlinCompilation;
import org.jetbrains.kotlin.idea.projectModel.KotlinSourceSet;
import org.jetbrains.kotlin.idea.projectModel.KotlinTarget;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Order(value=999)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005H\u0016J&\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0016J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidMPPGradleProjectResolver;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "<init>", "()V", "getToolingExtensionsClasses", "", "Ljava/lang/Class;", "", "getExtraProjectModelClasses", "createModule", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "projectDataNode", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "populateModuleDependencies", "", "ideModule", "ideProject", "intellij.android.projectSystem.gradle"})
public final class KotlinAndroidMPPGradleProjectResolver
extends AbstractProjectResolverExtension {
    @NotNull
    public Set<Class<? extends Object>> getToolingExtensionsClasses() {
        Object[] objectArray = new Class[]{KotlinMPPGradleModelBuilder.class, KotlinTarget.class, Unit.class};
        return SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public Set<Class<? extends Object>> getExtraProjectModelClasses() {
        Object[] objectArray = new Class[]{KotlinMPPGradleModel.class, KotlinTarget.class};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        DataNode dataNode;
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter(projectDataNode, (String)"projectDataNode");
        IdeAndroidModels androidModels = (IdeAndroidModels)this.resolverCtx.getExtraProject(gradleModule, IdeAndroidModels.class);
        ProjectResolverContext projectResolverContext = this.resolverCtx;
        Intrinsics.checkNotNullExpressionValue((Object)projectResolverContext, (String)"resolverCtx");
        KotlinMPPGradleModel mppModel = KotlinMppGradleProjectResolverKt.getMppModel((ProjectResolverContext)projectResolverContext, (IdeaModule)gradleModule);
        if (androidModels == null || mppModel == null) {
            return super.createModule(gradleModule, projectDataNode);
        }
        String selectedVariantName = androidModels.getSelectedVariantName();
        KotlinAndroidMPPGradleProjectResolverKt.access$removeWrongCompilationsAndMergeNonNeededSourceSets(mppModel, selectedVariantName);
        DataNode dataNode2 = super.createModule(gradleModule, projectDataNode);
        Intrinsics.checkNotNull((Object)dataNode2);
        DataNode ideModule = dataNode = dataNode2;
        boolean bl = false;
        Map sourceSetByName = KotlinAndroidMPPGradleProjectResolverKt.access$sourceSetsByName(ideModule);
        for (Pair pair : KotlinAndroidMPPGradleProjectResolverKt.access$androidCompilationsForVariant(mppModel, selectedVariantName)) {
            KotlinSourceSetInfo kotlinSourceSetInfo;
            DataNode androidGradleSourceSetDataNode;
            IdeModuleWellKnownSourceSet sourceSetDesc = (IdeModuleWellKnownSourceSet)pair.component1();
            KotlinCompilation compilation = (KotlinCompilation)pair.component2();
            ProjectResolverContext projectResolverContext2 = this.resolverCtx;
            Intrinsics.checkNotNullExpressionValue((Object)projectResolverContext2, (String)"resolverCtx");
            if (KotlinMppGradleProjectResolver.Companion.createSourceSetInfo(mppModel, compilation, gradleModule, projectResolverContext2) == null || (DataNode)sourceSetByName.get(sourceSetDesc.getSourceSetName()) == null) continue;
            androidGradleSourceSetDataNode.createChild(KotlinSourceSetData.Companion.getKEY(), (Object)new KotlinSourceSetData(kotlinSourceSetInfo));
        }
        return dataNode;
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter(ideModule, (String)"ideModule");
        Intrinsics.checkNotNullParameter(ideProject, (String)"ideProject");
        super.populateModuleDependencies(gradleModule, ideModule, ideProject);
        ProjectResolverContext projectResolverContext = this.resolverCtx;
        Intrinsics.checkNotNullExpressionValue((Object)projectResolverContext, (String)"resolverCtx");
        KotlinMPPGradleModel kotlinMPPGradleModel = KotlinMppGradleProjectResolverKt.getMppModel((ProjectResolverContext)projectResolverContext, (IdeaModule)gradleModule);
        if (kotlinMPPGradleModel == null) {
            return;
        }
        KotlinMPPGradleModel mppModel = kotlinMPPGradleModel;
        IdeAndroidModels ideAndroidModels = (IdeAndroidModels)this.resolverCtx.getExtraProject(gradleModule, IdeAndroidModels.class);
        if (ideAndroidModels == null) {
            return;
        }
        IdeAndroidModels androidModels = ideAndroidModels;
        String selectedVariantName = androidModels.getSelectedVariantName();
        Map sourceSetByName = KotlinAndroidMPPGradleProjectResolverKt.access$sourceSetsByName(ideModule);
        for (Pair pair : KotlinAndroidMPPGradleProjectResolverKt.access$androidCompilationsForVariant(mppModel, selectedVariantName)) {
            KotlinSourceSet kotlinSourceSet;
            IdeModuleWellKnownSourceSet sourceSetDesc = (IdeModuleWellKnownSourceSet)pair.component1();
            KotlinCompilation compilation = (KotlinCompilation)pair.component2();
            if ((DataNode)sourceSetByName.get(sourceSetDesc.getSourceSetName()) == null || KotlinAndroidMPPGradleProjectResolverKt.access$getRootKotlinSourceSet(sourceSetDesc, compilation) == null) continue;
            Set resolvedDependsOnSourceSets = KotlinSourceSetContainerKt.resolveAllDependsOnSourceSets((KotlinSourceSetContainer)((KotlinSourceSetContainer)mppModel), (KotlinSourceSet)kotlinSourceSet);
            for (KotlinSourceSet dependsOn : resolvedDependsOnSourceSets) {
                DataNode dependsOnGradleSourceSet;
                DataNode androidGradleSourceSetDataNode;
                if ((DataNode)sourceSetByName.get(dependsOn.getName()) == null) continue;
                androidGradleSourceSetDataNode.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)new ModuleDependencyData((ModuleData)androidGradleSourceSetDataNode.getData(), (ModuleData)dependsOnGradleSourceSet.getData()));
            }
        }
    }
}

