/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.layoutlib.reflection.TrackingThreadLocal;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.module.ModuleDisposableService;
import com.android.tools.idea.rendering.BuildTargetReference;
import com.android.tools.idea.rendering.StudioModuleRenderContext;
import com.android.tools.idea.rendering.classloading.FilteringClassLoader;
import com.android.tools.idea.rendering.classloading.FirewalledResourcesClassLoader;
import com.android.tools.idea.rendering.classloading.ReflectionUtilKt;
import com.android.tools.idea.rendering.classloading.RepackageTransform;
import com.android.tools.idea.rendering.classloading.StringReplaceTransform;
import com.android.tools.idea.rendering.classloading.ThreadControllingTransform;
import com.android.tools.idea.rendering.classloading.ThreadLocalTrackingTransform;
import com.android.tools.idea.rendering.classloading.ViewTreeLifecycleTransform;
import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.classloading.ClassBinaryCache;
import com.android.tools.rendering.classloading.ClassBinaryCacheManager;
import com.android.tools.rendering.classloading.ClassConverter;
import com.android.tools.rendering.classloading.ClassTransform;
import com.android.tools.rendering.classloading.CooperativeInterruptTransform;
import com.android.tools.rendering.classloading.ModuleClassLoader;
import com.android.tools.rendering.classloading.ModuleClassLoaderDiagnosticsRead;
import com.android.tools.rendering.classloading.ModuleClassLoaderDiagnosticsWrite;
import com.android.tools.rendering.classloading.PreviewAnimationClockMethodTransform;
import com.android.tools.rendering.classloading.RenderActionAllocationLimiterTransform;
import com.android.tools.rendering.classloading.RequestExecutorTransform;
import com.android.tools.rendering.classloading.ResourcesCompatTransform;
import com.android.tools.rendering.classloading.SdkIntReplacer;
import com.android.tools.rendering.classloading.UtilKt;
import com.android.tools.rendering.classloading.VersionClassTransform;
import com.android.tools.rendering.classloading.ViewMethodWrapperTransform;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jetbrains.android.uipreview.ModuleClassLoaderImpl;
import org.jetbrains.android.uipreview.ModuleClassLoaderUtil;
import org.jetbrains.android.uipreview.classloading.LibraryResourceClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;

public final class StudioModuleClassLoader
extends ModuleClassLoader {
    private static final Logger LOG = Logger.getInstance(StudioModuleClassLoader.class);
    private static final ImmutableList<String> PACKAGES_TO_RENAME = ImmutableList.of((Object)"kotlin.", (Object)"kotlinx.", (Object)"android.support.constraint.solver.", (Object)"okio.");
    private static final ImmutableList<String> ALLOWED_PACKAGES_FROM_PLUGIN = ImmutableList.of((Object)"java.", (Object)"javax.", (Object)"jdk.", (Object)"sun.", (Object)"com.sun.", (Object)"org.w3c.", (Object)"org.xml.", (Object)"android.", (Object)"dalvik.", (Object)"org.apache.", (Object)"org.xmlpull.", (Object)"org.json.", (Object[])new String[]{"junit.", "com.android.", "org.jetbrains.android.uipreview.", "androidx.compose.animation.tooling."});
    private static final Map<String, ? extends Map<String, String>> STRING_REPLACEMENTS = ImmutableMap.of((Object)"_layoutlib_._internal_.kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames", (Object)ImmutableMap.of((Object)"kotlin.Metadata", (Object)"_layoutlib_._internal_.kotlin.Metadata", (Object)"kotlin.annotations.jvm.ReadOnly", (Object)"_layoutlib_._internal_.kotlin.annotations.jvm.ReadOnly", (Object)"kotlin.annotations.jvm.Mutable", (Object)"_layoutlib_._internal_.kotlin.annotations.jvm.Mutable", (Object)"kotlin.jvm.internal", (Object)"_layoutlib_._internal_.kotlin.jvm.internal", (Object)"kotlin.jvm.internal.EnhancedNullability", (Object)"_layoutlib_._internal_.kotlin.jvm.internal.EnhancedNullability", (Object)"kotlin.jvm.internal.SerializedIr", (Object)"_layoutlib_._internal_.kotlin.jvm.internal.SerializedIr"));
    static final ClassTransform PROJECT_DEFAULT_TRANSFORMS = UtilKt.toClassTransform(ViewMethodWrapperTransform::new, visitor2 -> new VersionClassTransform((ClassVisitor)visitor2, ClassConverter.getCurrentClassVersion(), 0), ThreadLocalTrackingTransform::new, ThreadControllingTransform::new, CooperativeInterruptTransform::new, visitor2 -> (Boolean)StudioFlags.COMPOSE_ALLOCATION_LIMITER.get() != false ? new RenderActionAllocationLimiterTransform((ClassVisitor)visitor2) : visitor2, SdkIntReplacer::new, visitor2 -> new RepackageTransform((ClassVisitor)visitor2, (Collection<String>)PACKAGES_TO_RENAME, "_layoutlib_._internal_."));
    static final ClassTransform NON_PROJECT_CLASSES_DEFAULT_TRANSFORMS = UtilKt.toClassTransform(ViewMethodWrapperTransform::new, visitor2 -> new VersionClassTransform((ClassVisitor)visitor2, ClassConverter.getCurrentClassVersion(), 0), ThreadLocalTrackingTransform::new, ThreadControllingTransform::new, PreviewAnimationClockMethodTransform::new, ResourcesCompatTransform::new, RequestExecutorTransform::new, ViewTreeLifecycleTransform::new, SdkIntReplacer::new, visitor2 -> new StringReplaceTransform((ClassVisitor)visitor2, STRING_REPLACEMENTS), visitor2 -> new RepackageTransform((ClassVisitor)visitor2, (Collection<String>)PACKAGES_TO_RENAME, "_layoutlib_._internal_."));
    private static final ExecutorService ourDisposeService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ModuleClassLoader Dispose Thread", (int)1);
    private final BuildTargetReference myBuildTargetReference;
    @NotNull
    private final ModuleClassLoaderDiagnosticsWrite myDiagnostics;
    private final ModuleClassLoaderImpl myImpl;
    private final ClassLoader myParentAtConstruction;
    private final CheckedDisposable myDisposable = Disposer.newCheckedDisposable();

    StudioModuleClassLoader(@Nullable ClassLoader parent, @NotNull StudioModuleRenderContext renderContext, @NotNull ClassTransform projectTransformations, @NotNull ClassTransform nonProjectTransformations, @NotNull ModuleClassLoaderDiagnosticsWrite diagnostics) {
        this(parent, renderContext, projectTransformations, nonProjectTransformations, ClassBinaryCacheManager.getInstance().getCache(renderContext.getBuildTargetReference().getModuleIfNotDisposed()), diagnostics);
    }

    private StudioModuleClassLoader(@Nullable ClassLoader parent, @NotNull StudioModuleRenderContext renderContext, @NotNull ModuleClassLoaderImpl loader2, @NotNull ModuleClassLoaderDiagnosticsWrite diagnostics) {
        super(new LibraryResourceClassLoader(new FirewalledResourcesClassLoader(FilteringClassLoader.allowedPrefixes(parent, ALLOWED_PACKAGES_FROM_PLUGIN)), renderContext.getBuildTargetReference().getModuleIfNotDisposed(), loader2), loader2);
        this.myParentAtConstruction = parent;
        this.myImpl = loader2;
        this.myBuildTargetReference = renderContext.getBuildTargetReference();
        Module module = renderContext.getBuildTargetReference().getModuleIfNotDisposed();
        Disposer.register((Disposable)this.myDisposable, this::disposeImpl);
        this.myDiagnostics = diagnostics;
        if (module == null || !Disposer.tryRegister((Disposable)ModuleDisposableService.getInstance(module), (Disposable)this.myDisposable)) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    @Override
    public boolean hasLoadedClass(@NotNull String fqcn) {
        return this.getProjectLoadedClasses().contains(fqcn) || this.getNonProjectLoadedClasses().contains(fqcn);
    }

    private StudioModuleClassLoader(@Nullable ClassLoader parent, @NotNull StudioModuleRenderContext renderContext, @NotNull ClassTransform projectTransformations, @NotNull ClassTransform nonProjectTransformations, @NotNull ClassBinaryCache cache, @NotNull ModuleClassLoaderDiagnosticsWrite diagnostics) {
        this(parent, renderContext, new ModuleClassLoaderImpl(renderContext.getBuildTargetReference(), renderContext.createInjectableClassLoaderLoader(), parent, projectTransformations, nonProjectTransformations, cache, diagnostics), diagnostics);
    }

    @Override
    protected boolean isCompatibleParentClassLoader(@Nullable ClassLoader parent) {
        return this.getParentAtConstruction() == parent;
    }

    @Nullable
    ClassLoader getParentAtConstruction() {
        return this.myParentAtConstruction;
    }

    @Override
    @NotNull
    public Set<String> getNonProjectLoadedClasses() {
        return this.myImpl.getNonProjectLoadedClassNames();
    }

    @Override
    @NotNull
    public Set<String> getProjectLoadedClasses() {
        return this.myImpl.getProjectLoadedClassNames();
    }

    @Override
    @NotNull
    public ClassTransform getProjectClassesTransform() {
        return this.myImpl.getProjectTransforms();
    }

    @Override
    @NotNull
    public ClassTransform getNonProjectClassesTransform() {
        return this.myImpl.getNonProjectTransforms();
    }

    @Override
    public boolean areDependenciesUpToDate() {
        Module module = this.myBuildTargetReference.getModuleIfNotDisposed();
        if (module == null) {
            return true;
        }
        HashSet<Path> currentlyLoadedLibraries = new HashSet<Path>(this.myImpl.getExternalLibraries());
        List<Path> moduleLibraries = ModuleClassLoaderUtil.getExternalLibraries(this.myBuildTargetReference);
        return currentlyLoadedLibraries.size() == moduleLibraries.size() && currentlyLoadedLibraries.containsAll(moduleLibraries);
    }

    @Override
    public boolean isUserCodeUpToDate() {
        return this.myImpl.isUserCodeUpToDate(this.myBuildTargetReference);
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        return this.myImpl.getResources(name2);
    }

    @Override
    @Nullable
    public URL getResource(String name2) {
        return this.myImpl.getResource(name2);
    }

    @Override
    protected void onBeforeLoadClass(@NotNull String fqcn) {
        this.myDiagnostics.classLoadStart(fqcn);
    }

    @Override
    protected void onAfterLoadClass(@NotNull String fqcn, boolean loaded, long durationMs) {
        this.myDiagnostics.classLoadedEnd(fqcn, durationMs);
    }

    @Override
    protected void onBeforeFindClass(@NotNull String fqcn) {
        this.myDiagnostics.classFindStart(fqcn);
    }

    @Override
    protected void onAfterFindClass(@NotNull String fqcn, boolean found, long durationMs) {
        this.myDiagnostics.classFindEnd(fqcn, found, durationMs);
    }

    @Nullable
    public Module getModule() {
        return this.myBuildTargetReference.getModuleIfNotDisposed();
    }

    @Override
    @NotNull
    public ModuleClassLoaderDiagnosticsRead getStats() {
        return this.myDiagnostics;
    }

    @Nullable
    public StudioModuleRenderContext getModuleContext() {
        return this.isDisposed() ? null : StudioModuleRenderContext.forBuildTargetReference(this.myBuildTargetReference);
    }

    private void waitForCoroutineThreadToStop() {
        try {
            Class<?> defaultExecutorClass = this.findLoadedClass("_layoutlib_._internal_.kotlinx.coroutines.DefaultExecutor");
            if (defaultExecutorClass == null) {
                return;
            }
            Method isThreadPresentMethod = ReflectionUtilKt.findMethodLike(defaultExecutorClass, "isThreadPresent");
            if (isThreadPresentMethod == null) {
                LOG.warn("Method to check coroutine thread existence is not found.");
                return;
            }
            Field instanceField = defaultExecutorClass.getDeclaredField("INSTANCE");
            Object defaultExecutorObj = instanceField.get(null);
            isThreadPresentMethod.setAccessible(true);
            int ITERATIONS = 11;
            for (int i = 0; i <= 11; ++i) {
                if (!((Boolean)isThreadPresentMethod.invoke(defaultExecutorObj, new Object[0])).booleanValue()) {
                    return;
                }
                if (i == 11) continue;
                Thread.sleep(100L);
            }
            LOG.warn("DefaultExecutor thread is still running");
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    @Nullable
    StudioModuleClassLoader copy(@NotNull ModuleClassLoaderDiagnosticsWrite diagnostics) {
        StudioModuleRenderContext renderContext = this.getModuleContext();
        if (this.isDisposed() || renderContext == null || renderContext.getBuildTargetReference().getModuleIfNotDisposed() == null) {
            return null;
        }
        return new StudioModuleClassLoader(this.myParentAtConstruction, renderContext, this.getProjectClassesTransform(), this.getNonProjectClassesTransform(), diagnostics);
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposable.isDisposed();
    }

    public void disposeImpl() {
        Set<ThreadLocal<?>> threadLocals = TrackingThreadLocal.clearThreadLocals(this);
        ourDisposeService.submit(() -> {
            this.waitForCoroutineThreadToStop();
            this.myImpl.dispose();
            if (threadLocals == null || threadLocals.isEmpty()) {
                return;
            }
            RenderService.getRenderAsyncActionExecutor().runAsyncAction(RenderAsyncActionExecutor.RenderingTopic.CLEAN, () -> {
                for (ThreadLocal threadLocal : threadLocals) {
                    try {
                        threadLocal.remove();
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
            });
        });
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }
}

