/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.SdkPaths;
import com.intellij.CommonBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.sdk.AndroidNewSdkDialog;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkConfigurable;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.StudioAndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkType
extends SdkType
implements JavaSdkType {
    @NonNls
    public static final String SDK_NAME = "Android SDK";
    @NonNls
    public static final String DEFAULT_EXTERNAL_DOCUMENTATION_PATH = "developer.android.com/reference/";
    @NonNls
    public static final String DEFAULT_EXTERNAL_DOCUMENTATION_URL = "http://developer.android.com/reference/";

    public AndroidSdkType() {
        super(SDK_NAME);
    }

    @Nullable
    public String getBinPath(@NotNull Sdk sdk) {
        Sdk jdk = IdeSdks.getInstance().getJdk();
        return jdk == null ? null : JavaSdk.getInstance().getBinPath(jdk);
    }

    @Nullable
    public String getToolsPath(@NotNull Sdk sdk) {
        Sdk jdk = IdeSdks.getInstance().getJdk();
        if (jdk != null && jdk.getVersionString() != null) {
            return JavaSdk.getInstance().getToolsPath(jdk);
        }
        return null;
    }

    @Nullable
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        Sdk jdk = IdeSdks.getInstance().getJdk();
        return jdk == null ? null : JavaSdk.getInstance().getVMExecutablePath(jdk);
    }

    @Nullable
    public String suggestHomePath() {
        return null;
    }

    public boolean isValidSdkHome(@NotNull String path) {
        if (StringUtil.isEmpty((String)path)) {
            return false;
        }
        File sdkPath = FilePaths.stringToFile((String)path);
        return SdkPaths.validateAndroidSdk((File)sdkPath, (boolean)false).success;
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        return SDK_NAME;
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        IAndroidTarget target2;
        AndroidSdkData sdkData = StudioAndroidSdkData.getSdkData(sdk);
        if (sdkData == null) {
            Messages.showErrorDialog((String)AndroidBundle.message("cannot.parse.sdk.error", new Object[0]), (String)"SDK Parsing Error");
            return false;
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        if (targets.length == 0) {
            if (Messages.showOkCancelDialog((String)AndroidBundle.message("no.android.targets.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (String)"Open SDK Manager", (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon()) == 0) {
                SdkQuickfixUtils.showAndroidSdkManager();
            }
            return false;
        }
        String[] targetNames = new String[targets.length];
        String newestPlatform = null;
        AndroidVersion version2 = null;
        for (int i = 0; i < targets.length; ++i) {
            String targetName;
            target2 = targets[i];
            targetNames[i] = targetName = AndroidSdkUtils.getTargetPresentableName(target2);
            if (!target2.isPlatform() || version2 != null && target2.getVersion().compareTo(version2) <= 0) continue;
            newestPlatform = targetName;
            version2 = target2.getVersion();
        }
        AndroidNewSdkDialog dialog2 = new AndroidNewSdkDialog(null, new ArrayList<String>(Arrays.asList(targetNames)), newestPlatform != null ? newestPlatform : targetNames[0]);
        if (!dialog2.showAndGet()) {
            return false;
        }
        target2 = targets[dialog2.getSelectedTargetIndex()];
        String sdkName = AndroidSdks.getInstance().chooseNameForNewLibrary(target2);
        AndroidSdks.getInstance().setUpSdk(sdk, target2, sdkName, Arrays.asList(sdkModel.getSdks()));
        return true;
    }

    @NotNull
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        return new AndroidSdkConfigurable(sdkModificator);
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData data2, @NotNull Element e) {
        if (data2 instanceof AndroidSdkAdditionalData) {
            ((AndroidSdkAdditionalData)data2).save(e);
        }
    }

    @NotNull
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        return new AndroidSdkAdditionalData(currentSdk, additional);
    }

    @NotNull
    public String getPresentableName() {
        return AndroidBundle.message("android.sdk.presentable.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        return StudioIcons.Common.ANDROID_HEAD;
    }

    @NotNull
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        return DEFAULT_EXTERNAL_DOCUMENTATION_URL;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance() || type == AnnotationOrderRootType.getInstance();
    }

    public static AndroidSdkType getInstance() {
        return (AndroidSdkType)SdkType.findInstance(AndroidSdkType.class);
    }
}

