/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.sdk.AndroidPlatform;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkNotConfiguredNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return null;
        }
        if (AndroidModel.isRequired(facet)) {
            return null;
        }
        if (!IdeResourcesUtil.isResourceFile(file, facet) && !file.equals(AndroidRootUtil.getPrimaryManifestFile(facet))) {
            return null;
        }
        AndroidPlatform platform = AndroidPlatforms.getInstance(module);
        if (platform != null) {
            return null;
        }
        return fileEditor -> new MySdkNotConfiguredNotificationPanel(project, (FileEditor)fileEditor, module);
    }

    private static class MySdkNotConfiguredNotificationPanel
    extends EditorNotificationPanel {
        MySdkNotConfiguredNotificationPanel(Project myProject, @NotNull FileEditor fileEditor, @NotNull Module module) {
            super(fileEditor, EditorNotificationPanel.Status.Warning);
            this.setText(AndroidBundle.message("android.sdk.not.configured.notification", module.getName()));
            this.createActionLabel(AndroidBundle.message("action.label.open.project.structure", new Object[0]), () -> {
                ModulesConfigurator.showDialog((Project)module.getProject(), (String)module.getName(), (String)ClasspathEditor.getName());
                EditorNotifications.getInstance((Project)myProject).updateAllNotifications();
            });
        }
    }
}

